/*
 * Decompiled with CFR 0.152.
 */
package com.apotheosisbalancer.mixin;

import com.apotheosisbalancer.ApotheosisBalancer;
import com.apotheosisbalancer.BalancerConfig;
import dev.shadowsoffire.apotheosis.adventure.loot.AffixLootEntry;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.Optional;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={AffixLootEntry.class}, remap=false)
public class AffixLootEntryMixin {
    @ModifyVariable(method={"<init>(IFLnet/minecraft/world/item/ItemStack;Ljava/util/Set;Ldev/shadowsoffire/placebo/reload/DynamicHolder;Ldev/shadowsoffire/placebo/reload/DynamicHolder;Ljava/util/Optional;)V"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0, remap=false)
    private static float multiplyQuality(float quality) {
        if (BalancerConfig.qualityMultiplier == 1.0) {
            return quality;
        }
        float modified = (float)Math.max(0.0, (double)quality * BalancerConfig.qualityMultiplier);
        if (BalancerConfig.enableDebugLogging) {
            ApotheosisBalancer.LOGGER.debug("Modified quality: {} -> {} (multiplier: {})", new Object[]{Float.valueOf(quality), Float.valueOf(modified), BalancerConfig.qualityMultiplier});
        }
        return modified;
    }

    @ModifyVariable(method={"<init>(IFLnet/minecraft/world/item/ItemStack;Ljava/util/Set;Ldev/shadowsoffire/placebo/reload/DynamicHolder;Ldev/shadowsoffire/placebo/reload/DynamicHolder;Ljava/util/Optional;)V"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0, remap=false)
    private static DynamicHolder<LootRarity> shiftMinRarity(DynamicHolder<LootRarity> min, int weight, float quality, ItemStack stack, Set<ResourceLocation> dimensions, DynamicHolder<LootRarity> minParam, DynamicHolder<LootRarity> max, Optional<Set<String>> stages) {
        int offset = BalancerConfig.minRarityOffset;
        if (offset == 0) {
            return min;
        }
        DynamicHolder<LootRarity> shifted = BalancerConfig.shiftRarity(min, offset);
        if (BalancerConfig.enableDebugLogging) {
            String originalId = min.isBound() ? min.getId().toString() : "unbound";
            String shiftedId = shifted.isBound() ? shifted.getId().toString() : "unbound";
            ApotheosisBalancer.LOGGER.debug("Shifted min_rarity: {} -> {} (offset: {})", new Object[]{originalId, shiftedId, offset});
        }
        return shifted;
    }

    @ModifyVariable(method={"<init>(IFLnet/minecraft/world/item/ItemStack;Ljava/util/Set;Ldev/shadowsoffire/placebo/reload/DynamicHolder;Ldev/shadowsoffire/placebo/reload/DynamicHolder;Ljava/util/Optional;)V"}, at=@At(value="HEAD"), argsOnly=true, ordinal=1, remap=false)
    private static DynamicHolder<LootRarity> shiftMaxRarity(DynamicHolder<LootRarity> max, int weight, float quality, ItemStack stack, Set<ResourceLocation> dimensions, DynamicHolder<LootRarity> min, DynamicHolder<LootRarity> maxParam, Optional<Set<String>> stages) {
        int offset = BalancerConfig.maxRarityOffset;
        if (offset == 0) {
            return max;
        }
        DynamicHolder<LootRarity> shifted = BalancerConfig.shiftRarity(max, offset);
        if (BalancerConfig.enableDebugLogging) {
            String originalId = max.isBound() ? max.getId().toString() : "unbound";
            String shiftedId = shifted.isBound() ? shifted.getId().toString() : "unbound";
            ApotheosisBalancer.LOGGER.debug("Shifted max_rarity: {} -> {} (offset: {})", new Object[]{originalId, shiftedId, offset});
        }
        return shifted;
    }
}

