/*
 * Decompiled with CFR 0.152.
 */
package com.apotheosisbalancer.mixin;

import com.apotheosisbalancer.BalancerConfig;
import com.apotheosisbalancer.util.RarityContext;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.EnchantmentBonus;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnchantmentBonus.class}, remap=false)
public class EnchantmentBonusMixin {
    @Inject(method={"getSocketBonusTooltip"}, at={@At(value="HEAD")}, remap=false)
    private void captureRarityTooltip(ItemStack gem, LootRarity rarity, CallbackInfoReturnable<?> cir) {
        RarityContext.set(rarity);
    }

    @Inject(method={"getSocketBonusTooltip"}, at={@At(value="RETURN")}, remap=false)
    private void clearRarityTooltip(ItemStack gem, LootRarity rarity, CallbackInfoReturnable<?> cir) {
        RarityContext.clear();
    }

    @Inject(method={"getEnchantmentLevels"}, at={@At(value="HEAD")}, remap=false)
    private void captureRarityEnchantment(ItemStack gemStack, LootRarity rarity, Map<?, ?> enchantments, CallbackInfo ci) {
        RarityContext.set(rarity);
    }

    @Inject(method={"getEnchantmentLevels"}, at={@At(value="RETURN")}, remap=false)
    private void clearRarityEnchantment(ItemStack gemStack, LootRarity rarity, Map<?, ?> enchantments, CallbackInfo ci) {
        RarityContext.clear();
    }

    @ModifyVariable(method={"getSocketBonusTooltip"}, at=@At(value="STORE"), ordinal=0, remap=false)
    private int multiplyLevelTooltip(int level) {
        if (!BalancerConfig.enableEnchantmentBalance) {
            return level;
        }
        double multiplier = BalancerConfig.getMultiplierForContext();
        if (multiplier == 1.0) {
            return level;
        }
        float result = (float)((double)level * multiplier);
        return BalancerConfig.applyRounding(result, BalancerConfig.enchantmentRounding);
    }

    @ModifyVariable(method={"getEnchantmentLevels"}, at=@At(value="STORE"), ordinal=0, remap=false)
    private int multiplyLevelEnchantment(int level) {
        if (!BalancerConfig.enableEnchantmentBalance) {
            return level;
        }
        double multiplier = BalancerConfig.getMultiplierForContext();
        if (multiplier == 1.0) {
            return level;
        }
        float result = (float)((double)level * multiplier);
        return BalancerConfig.applyRounding(result, BalancerConfig.enchantmentRounding);
    }
}

