/*
 * Decompiled with CFR 0.152.
 */
package com.apotheosisbalancer.mixin;

import com.apotheosisbalancer.BalancerConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Mixin(targets={"dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.PotionBonus$EffectData"}, remap=false)
public class PotionBonusMixin {
    @ModifyArg(method={"build"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/effect/MobEffectInstance;<init>(Lnet/minecraft/world/effect/MobEffect;II)V"), index=1, remap=false)
    private int multiplyDuration(int duration) {
        if (!BalancerConfig.enablePotionBalance) {
            return duration;
        }
        double multiplier = BalancerConfig.getMultiplierForContext();
        if (multiplier == 1.0) {
            return duration;
        }
        return Math.max(20, (int)Math.round((double)duration * multiplier));
    }

    @ModifyArg(method={"build"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/effect/MobEffectInstance;<init>(Lnet/minecraft/world/effect/MobEffect;II)V"), index=2, remap=false)
    private int multiplyAmplifier(int amplifier) {
        if (!BalancerConfig.enablePotionBalance) {
            return amplifier;
        }
        double multiplier = BalancerConfig.getMultiplierForContext();
        if (multiplier == 1.0) {
            return amplifier;
        }
        float result = (float)((double)amplifier * multiplier);
        return BalancerConfig.applyRoundingForPotions(result, BalancerConfig.potionRounding);
    }
}

