/*
 * Decompiled with CFR 0.152.
 */
package com.apotheosisbalancer.mixin;

import com.apotheosisbalancer.BalancerConfig;
import com.apotheosisbalancer.util.RarityContext;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.PotionBonus;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PotionBonus.class}, remap=false)
class PotionBonusParentMixin {
    PotionBonusParentMixin() {
    }

    @Inject(method={"getSocketBonusTooltip"}, at={@At(value="HEAD")}, remap=false)
    private void captureRarityTooltip(ItemStack gem, LootRarity rarity, CallbackInfoReturnable<?> cir) {
        RarityContext.set(rarity);
    }

    @Inject(method={"getSocketBonusTooltip"}, at={@At(value="RETURN")}, remap=false)
    private void clearRarityTooltip(ItemStack gem, LootRarity rarity, CallbackInfoReturnable<?> cir) {
        RarityContext.clear();
    }

    @Inject(method={"applyEffect"}, at={@At(value="HEAD")}, remap=false)
    private void captureRarityApply(ItemStack gemStack, LivingEntity target, LootRarity rarity, CallbackInfoReturnable<?> cir) {
        RarityContext.set(rarity);
    }

    @Inject(method={"applyEffect"}, at={@At(value="RETURN")}, remap=false)
    private void clearRarityApply(ItemStack gemStack, LivingEntity target, LootRarity rarity, CallbackInfoReturnable<?> cir) {
        RarityContext.clear();
    }

    @Inject(method={"getCooldown"}, at={@At(value="HEAD")}, remap=false)
    private void captureRarityCooldown(LootRarity rarity, CallbackInfoReturnable<Integer> cir) {
        RarityContext.set(rarity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"getCooldown"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    private void multiplyCooldown(LootRarity rarity, CallbackInfoReturnable<Integer> cir) {
        try {
            if (!BalancerConfig.enablePotionBalance) {
                return;
            }
            double multiplier = BalancerConfig.getMultiplierForContext();
            if (multiplier != 1.0) {
                int cooldown = (Integer)cir.getReturnValue();
                int multipliedCooldown = Math.max(0, (int)Math.round((double)cooldown * multiplier));
                cir.setReturnValue((Object)multipliedCooldown);
            }
        }
        finally {
            RarityContext.clear();
        }
    }
}

