/*
 * Decompiled with CFR 0.152.
 */
package com.apotheosisbalancer.mixin;

import com.apotheosisbalancer.ApotheosisBalancer;
import com.apotheosisbalancer.BalancerConfig;
import dev.shadowsoffire.placebo.util.StepFunction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={StepFunction.class}, remap=false)
public class StepFunctionMixin {
    private static final ThreadLocal<Boolean> APPLYING_MULTIPLIER = ThreadLocal.withInitial(() -> false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"get(F)F"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    private void applyGlobalMultiplier(float level, CallbackInfoReturnable<Float> cir) {
        if (!BalancerConfig.enableAttributeBalance) {
            return;
        }
        if (APPLYING_MULTIPLIER.get().booleanValue()) {
            return;
        }
        try {
            APPLYING_MULTIPLIER.set(true);
            double multiplier = BalancerConfig.getMultiplierForContext();
            if (multiplier == 1.0) {
                return;
            }
            float originalValue = ((Float)cir.getReturnValue()).floatValue();
            float multipliedValue = (float)((double)originalValue * multiplier);
            if (BalancerConfig.enableDebugLogging && originalValue != 0.0f) {
                String caller;
                StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                String string = caller = stackTrace.length > 3 ? stackTrace[3].getClassName() : "Unknown";
                if (caller.contains("apotheosis") || caller.contains("shadowsoffire")) {
                    String modSource = StepFunctionMixin.determineModSource(stackTrace);
                    ApotheosisBalancer.LOGGER.debug("[{}] Multiplying value: {} * {} = {} (from: {})", new Object[]{modSource, Float.valueOf(originalValue), multiplier, Float.valueOf(multipliedValue), caller});
                }
            }
            cir.setReturnValue((Object)Float.valueOf(multipliedValue));
        }
        finally {
            APPLYING_MULTIPLIER.set(false);
        }
    }

    private static String determineModSource(StackTraceElement[] stackTrace) {
        for (StackTraceElement element : stackTrace) {
            String className = element.getClassName();
            if (className.contains("apotheoticadditions")) {
                return "ApotheoticAdditions";
            }
            if (!className.contains("apotheosis") || className.contains("balancer")) continue;
            return "Apotheosis";
        }
        return "Unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"getInt(F)I"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    private void applyGlobalMultiplierInt(float level, CallbackInfoReturnable<Integer> cir) {
        if (!BalancerConfig.enableAttributeBalance) {
            return;
        }
        if (APPLYING_MULTIPLIER.get().booleanValue()) {
            return;
        }
        try {
            APPLYING_MULTIPLIER.set(true);
            double multiplier = BalancerConfig.getMultiplierForContext();
            if (multiplier == 1.0) {
                return;
            }
            int originalValue = (Integer)cir.getReturnValue();
            int multipliedValue = (int)((double)originalValue * multiplier);
            if (BalancerConfig.enableDebugLogging && originalValue != 0) {
                StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                String modSource = StepFunctionMixin.determineModSource(stackTrace);
                ApotheosisBalancer.LOGGER.debug("[{}] Multiplying int value: {} * {} = {}", new Object[]{modSource, originalValue, multiplier, multipliedValue});
            }
            cir.setReturnValue((Object)multipliedValue);
        }
        finally {
            APPLYING_MULTIPLIER.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"max()F"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    private void applyGlobalMultiplierMax(CallbackInfoReturnable<Float> cir) {
        if (!BalancerConfig.enableAttributeBalance) {
            return;
        }
        if (APPLYING_MULTIPLIER.get().booleanValue()) {
            return;
        }
        try {
            APPLYING_MULTIPLIER.set(true);
            double multiplier = BalancerConfig.getMultiplierForContext();
            if (multiplier == 1.0) {
                return;
            }
            float originalValue = ((Float)cir.getReturnValue()).floatValue();
            float multipliedValue = (float)((double)originalValue * multiplier);
            cir.setReturnValue((Object)Float.valueOf(multipliedValue));
        }
        finally {
            APPLYING_MULTIPLIER.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"getForStep(I)F"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    private void applyGlobalMultiplierForStep(int step, CallbackInfoReturnable<Float> cir) {
        if (!BalancerConfig.enableAttributeBalance) {
            return;
        }
        if (APPLYING_MULTIPLIER.get().booleanValue()) {
            return;
        }
        try {
            APPLYING_MULTIPLIER.set(true);
            double multiplier = BalancerConfig.getMultiplierForContext();
            if (multiplier == 1.0) {
                return;
            }
            float originalValue = ((Float)cir.getReturnValue()).floatValue();
            float multipliedValue = (float)((double)originalValue * multiplier);
            cir.setReturnValue((Object)Float.valueOf(multipliedValue));
        }
        finally {
            APPLYING_MULTIPLIER.set(false);
        }
    }
}

