/*
 * Decompiled with CFR 0.152.
 */
package com.apotheosisbalancer.util;

import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class RarityContext {
    private static final ThreadLocal<DynamicHolder<LootRarity>> CURRENT_RARITY = new ThreadLocal();

    public static void set(LootRarity rarity) {
        if (rarity == null) {
            CURRENT_RARITY.remove();
            return;
        }
        DynamicHolder holder = RarityRegistry.INSTANCE.holder((CodecProvider)rarity);
        CURRENT_RARITY.set((DynamicHolder<LootRarity>)holder);
    }

    public static void setHolder(DynamicHolder<LootRarity> holder) {
        CURRENT_RARITY.set(holder);
    }

    @Nullable
    public static DynamicHolder<LootRarity> getHolder() {
        return CURRENT_RARITY.get();
    }

    @Nullable
    public static LootRarity get() {
        DynamicHolder<LootRarity> holder = CURRENT_RARITY.get();
        return holder != null && holder.isBound() ? (LootRarity)holder.get() : null;
    }

    public static void clear() {
        CURRENT_RARITY.remove();
    }

    public static boolean isApotheoticAdditions() {
        DynamicHolder<LootRarity> holder = RarityContext.getHolder();
        if (holder == null) {
            return false;
        }
        try {
            ResourceLocation id = holder.getId();
            return id != null && id.m_135827_().equals("apotheotic_additions");
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isBaseApotheosis() {
        DynamicHolder<LootRarity> holder = RarityContext.getHolder();
        if (holder == null) {
            return false;
        }
        try {
            ResourceLocation id = holder.getId();
            return id != null && id.m_135827_().equals("apotheosis");
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getRarityId() {
        DynamicHolder<LootRarity> holder = RarityContext.getHolder();
        if (holder == null) {
            return "unknown";
        }
        try {
            ResourceLocation id = holder.getId();
            return id != null ? id.toString() : "unknown";
        }
        catch (Exception e) {
            return "error";
        }
    }
}

