/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.fletchingrecipe.datagen.recipebuilder;

import com.coolerpromc.fletchingrecipe.FletchingRecipe;
import com.coolerpromc.fletchingrecipe.util.SizedIngredient;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_1865;
import net.minecraft.class_2444;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class FletchingRecipeBuilder
implements class_5797 {
    private SizedIngredient top;
    private SizedIngredient middle;
    private SizedIngredient bottom;
    private class_1799 output;
    private final Map<String, class_184> criteria = new LinkedHashMap<String, class_184>();
    @Nullable
    private String group;

    public static FletchingRecipeBuilder builder() {
        return new FletchingRecipeBuilder();
    }

    private FletchingRecipeBuilder() {
    }

    public FletchingRecipeBuilder top(SizedIngredient top) {
        this.top = top;
        return this;
    }

    public FletchingRecipeBuilder middle(SizedIngredient middle) {
        this.middle = middle;
        return this;
    }

    public FletchingRecipeBuilder bottom(SizedIngredient bottom) {
        this.bottom = bottom;
        return this;
    }

    public FletchingRecipeBuilder output(class_1799 output) {
        this.output = output;
        return this;
    }

    public FletchingRecipeBuilder criterion(String s, class_184 criterion) {
        this.criteria.put(s, criterion);
        return this;
    }

    public FletchingRecipeBuilder group(@Nullable String s) {
        this.group = s;
        return this;
    }

    public class_1792 method_36441() {
        return this.output.method_7909();
    }

    public void method_17972(Consumer<class_2444> exporter, class_2960 recipeId) {
        exporter.accept(new Result(this.top, this.middle, this.bottom != null ? Optional.of(this.bottom) : Optional.empty(), this.output, recipeId));
    }

    public static JsonElement itemToJson(class_1799 stack) {
        JsonObject json = new JsonObject();
        json.addProperty("item", class_7923.field_41178.method_10221((Object)stack.method_7909()).toString());
        json.addProperty("count", (Number)stack.method_7947());
        if (stack.method_7985()) {
            json.add("nbt", (JsonElement)class_2509.field_11560.method_29146((DynamicOps)JsonOps.INSTANCE, (class_2520)stack.method_7969()));
        }
        return json;
    }

    public record Result(SizedIngredient top, SizedIngredient middle, Optional<SizedIngredient> bottom, class_1799 output, class_2960 id) implements class_2444
    {
        public void method_10416(JsonObject jsonObject) {
            jsonObject.addProperty("type", "fletchingrecipe:fletching");
            jsonObject.add("top", this.top.toJson());
            jsonObject.add("middle", this.middle.toJson());
            this.bottom.ifPresent(sizedIngredient -> jsonObject.add("bottom", sizedIngredient.toJson()));
            jsonObject.add("output", FletchingRecipeBuilder.itemToJson(this.output));
        }

        public class_2960 method_10417() {
            return this.id;
        }

        public class_1865<?> method_17800() {
            return FletchingRecipe.FLETCHING_RECIPE_SERIALIZER;
        }

        @Nullable
        public JsonObject method_10415() {
            return null;
        }

        @Nullable
        public class_2960 method_10418() {
            return null;
        }
    }
}

