/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.fletchingrecipe.recipe;

import com.coolerpromc.fletchingrecipe.FletchingRecipe;
import com.coolerpromc.fletchingrecipe.recipe.FletchingRecipeInput;
import com.coolerpromc.fletchingrecipe.util.SizedIngredient;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3577;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_7923;

public record FletchingTableRecipe(SizedIngredient top, SizedIngredient middle, Optional<SizedIngredient> bottom, class_1799 output, class_2960 id) implements class_1860<FletchingRecipeInput>
{
    public boolean matches(FletchingRecipeInput fletchingRecipeInput, class_1937 level) {
        return this.bottom.map(sizedIngredient -> this.top.test(fletchingRecipeInput.top()) && this.middle.test(fletchingRecipeInput.middle()) && sizedIngredient.test(fletchingRecipeInput.bottom())).orElseGet(() -> this.top.test(fletchingRecipeInput.top()) && this.middle.test(fletchingRecipeInput.middle()) && fletchingRecipeInput.bottom().method_7960());
    }

    public class_1799 craft(FletchingRecipeInput inventory, class_5455 registryManager) {
        return this.output.method_7972();
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110(class_5455 registryManager) {
        return this.output.method_7972();
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<? extends class_1860<FletchingRecipeInput>> method_8119() {
        return FletchingRecipe.FLETCHING_RECIPE_SERIALIZER;
    }

    public class_3956<? extends class_1860<FletchingRecipeInput>> method_17716() {
        return FletchingRecipe.FLETCHING_RECIPE_TYPE;
    }

    public static class_1799 getItemStack(JsonObject json, boolean readNBT, boolean disallowsAirInRecipe) {
        String itemName = class_3518.method_15265((JsonObject)json, (String)"item");
        class_1792 item = FletchingTableRecipe.getItem(itemName, disallowsAirInRecipe);
        if (readNBT && json.has("nbt")) {
            class_2487 nbt = FletchingTableRecipe.getNBT(json.get("nbt"));
            class_2487 tmp = new class_2487();
            if (nbt.method_10545("ForgeCaps")) {
                tmp.method_10566("ForgeCaps", nbt.method_10580("ForgeCaps"));
                nbt.method_10551("ForgeCaps");
            }
            tmp.method_10566("tag", (class_2520)nbt);
            tmp.method_10582("id", itemName);
            tmp.method_10569("Count", class_3518.method_15282((JsonObject)json, (String)"count", (int)1));
            return class_1799.method_7915((class_2487)tmp);
        }
        return new class_1799((class_1935)item, class_3518.method_15282((JsonObject)json, (String)"count", (int)1));
    }

    public static class_1792 getItem(String itemName, boolean disallowsAirInRecipe) {
        class_2960 itemKey = new class_2960(itemName);
        if (!class_7923.field_41178.method_10250(itemKey)) {
            throw new JsonSyntaxException("Unknown item '" + itemName + "'");
        }
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemKey);
        if (disallowsAirInRecipe && item == class_1802.field_8162) {
            throw new JsonSyntaxException("Invalid item: " + itemName);
        }
        return Objects.requireNonNull(item);
    }

    public static class_2487 getNBT(JsonElement element) {
        try {
            return element.isJsonObject() ? class_2522.method_10718((String)class_3577.field_15827.toJson(element)) : class_2522.method_10718((String)class_3518.method_15287((JsonElement)element, (String)"nbt"));
        }
        catch (CommandSyntaxException e) {
            throw new JsonSyntaxException("Invalid NBT Entry: " + String.valueOf((Object)e));
        }
    }

    public static class Serializer
    implements class_1865<FletchingTableRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public FletchingTableRecipe read(class_2960 id, JsonObject jsonObject) {
            SizedIngredient top = SizedIngredient.fromJson((JsonElement)jsonObject.getAsJsonObject("top"));
            SizedIngredient middle = SizedIngredient.fromJson((JsonElement)jsonObject.getAsJsonObject("middle"));
            Optional<SizedIngredient> bottom = Optional.empty();
            if (jsonObject.has("bottom")) {
                bottom = Optional.of(SizedIngredient.fromJson((JsonElement)jsonObject.getAsJsonObject("bottom")));
            }
            class_1799 output = FletchingTableRecipe.getItemStack(jsonObject.getAsJsonObject("output"), true, true);
            return new FletchingTableRecipe(top, middle, bottom, output, id);
        }

        public FletchingTableRecipe read(class_2960 id, class_2540 buf) {
            SizedIngredient top = SizedIngredient.fromPacket(buf);
            SizedIngredient middle = SizedIngredient.fromPacket(buf);
            Optional<SizedIngredient> bottom = Optional.empty();
            if (buf.readBoolean()) {
                bottom = Optional.of(SizedIngredient.fromPacket(buf));
            }
            class_1799 output = buf.method_10819();
            return new FletchingTableRecipe(top, middle, bottom, output, id);
        }

        public void write(class_2540 buf, FletchingTableRecipe recipe) {
            recipe.top.write(buf);
            recipe.middle.write(buf);
            buf.writeBoolean(recipe.bottom.isPresent());
            recipe.bottom.ifPresent(sizedIngredient -> sizedIngredient.write(buf));
            buf.method_10793(recipe.output);
        }
    }
}

