package net.sabio.abyssium_1_21_8.block;

import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.block.*;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.sabio.abyssium_1_21_8.Abyssium_1_21_8;

import java.util.function.Function;

public class ModBlocks {
    public static final class_2248 ABYSSIUM_ORE = register(
            "abyssium_ore",
            class_2248::new,
            class_4970.class_2251.method_9637().method_9626(class_2498.field_22151),
            35.0f, // Strength value
            true
    );

    public static final class_2248 BLOCK_OF_ABYSSIUM = register(
            "block_of_abyssium",
            class_2248::new,
            class_4970.class_2251.method_9637().method_9626(class_2498.field_22150),
            60.0f, // Strength value
            true
    );

    public static class_4970.class_2251 endStoneSettings = class_4970.class_2251.method_9630(class_2246.field_10471);

    public static final class_2248 INFESTED_END_STONE = register(
            "infested_end_stone",
            settings -> new EndermiteInfestedBlock(class_2246.field_10471, settings),
            endStoneSettings,
            15.0f,
            true
    );

    private static class_2248 register(String name, Function<class_4970.class_2251, class_2248> blockFactory, class_4970.class_2251 settings, float strength, boolean shouldRegisterItem) {
        class_5321<class_2248> blockKey = keyOfBlock(name);

        // Apply strength to settings
        settings = settings.method_9632(strength);

        // *** Add this line to require a tool for harvesting ***
        settings = settings.method_29292();

        class_2248 block = blockFactory.apply(settings.method_63500(blockKey));

        if (shouldRegisterItem) {
            class_5321<class_1792> itemKey = keyOfItem(name);
            class_1747 blockItem = new class_1747(block, new class_1792.class_1793().method_63686(itemKey));
            class_2378.method_39197(class_7923.field_41178, itemKey, blockItem);
        }

        return class_2378.method_39197(class_7923.field_41175, blockKey, block);
    }

    private static class_5321<class_2248> keyOfBlock(String name) {
        return class_5321.method_29179(class_7924.field_41254, class_2960.method_60655(Abyssium_1_21_8.MOD_ID, name));
    }

    private static class_5321<class_1792> keyOfItem(String name) {
        return class_5321.method_29179(class_7924.field_41197, class_2960.method_60655(Abyssium_1_21_8.MOD_ID, name));
    }

    public static void initialize() {
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40743)
                .register(itemGroup -> {
                    itemGroup.method_45421(ModBlocks.ABYSSIUM_ORE);
                    itemGroup.method_45421(ModBlocks.INFESTED_END_STONE);
                });

        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40195)
                .register((itemGroup) -> itemGroup.method_45421(ModBlocks.BLOCK_OF_ABYSSIUM));
    }
}
