/*
 * Decompiled with CFR 0.152.
 */
package com.kfhzs.allthingsflying.capability;

import com.kfhzs.allthingsflying.capability.IEngineCapability;
import com.kfhzs.allthingsflying.items.Engine;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class EngineCapabilityImpl
implements IEngineCapability {
    private ItemStack engineItem = ItemStack.f_41583_;
    private double power = 0.0;
    private float flightSpeed = 1.0f;
    private float friction = 0.93f;
    private float stopThreshold = 0.005f;
    private float acceleration = 0.3f;
    private int engineLevel = 1;
    private int engineDurability = 2564;
    private int maxEngineDurability = 2564;
    private int engineSoundTime = 0;
    private SoundEvent engineSound;

    @Override
    public ItemStack getEngineItem() {
        return this.engineItem;
    }

    @Override
    public void setEngineItem(ItemStack engineStack) {
        this.engineItem = engineStack.m_41777_();
        this.setPropertiesFromEngine(engineStack);
    }

    @Override
    public double getPower() {
        return this.power;
    }

    @Override
    public void setPower(double power) {
        this.power = power;
    }

    @Override
    public int getEngineDurability() {
        return this.engineDurability;
    }

    @Override
    public void setEngineDurability(int durability) {
        this.engineDurability = durability;
    }

    @Override
    public int getMaxEngineDurability() {
        return this.maxEngineDurability;
    }

    @Override
    public float getFlightSpeed() {
        float speedMultiplier;
        if (this.engineLevel <= 7) {
            speedMultiplier = 1.0f + (float)(this.engineLevel - 1) * 0.2f;
        } else {
            int extraLevels = this.engineLevel - 7;
            speedMultiplier = 2.2f + (float)extraLevels * 0.4f;
        }
        return this.flightSpeed * speedMultiplier;
    }

    @Override
    public void setFlightSpeed(float speed) {
        this.flightSpeed = speed;
    }

    @Override
    public float getFriction() {
        return this.friction;
    }

    @Override
    public void setFriction(float friction) {
        this.friction = friction;
    }

    @Override
    public float getStopThreshold() {
        return this.stopThreshold;
    }

    @Override
    public void setStopThreshold(float stopThreshold) {
        this.stopThreshold = stopThreshold;
    }

    @Override
    public float getAcceleration() {
        return this.acceleration;
    }

    @Override
    public void setAcceleration(float acceleration) {
        this.acceleration = acceleration;
    }

    @Override
    public int getEngineLevel() {
        return this.engineLevel;
    }

    @Override
    public void setEngineLevel(int level) {
        this.engineLevel = level;
        this.engineDurability += (this.engineLevel - 1) * 577;
        this.maxEngineDurability += (this.engineLevel - 1) * 577;
    }

    @Override
    public boolean hasEngine() {
        return !this.engineItem.m_41619_() && this.power > 0.0;
    }

    @Override
    public int getEngineSoundTime() {
        return this.engineSoundTime;
    }

    @Override
    public void setEngineSoundTime(int engineSoundTime) {
        this.engineSoundTime = engineSoundTime;
    }

    @Override
    public SoundEvent getEngineSound() {
        return this.engineSound;
    }

    @Override
    public void setEngineSound(SoundEvent engineSound) {
        this.engineSound = engineSound;
    }

    @Override
    public void copyFrom(IEngineCapability other) {
        this.engineItem = other.getEngineItem().m_41777_();
        this.power = other.getPower();
        this.flightSpeed = other.getFlightSpeed();
        this.friction = other.getFriction();
        this.stopThreshold = other.getStopThreshold();
        this.acceleration = other.getAcceleration();
        this.engineLevel = other.getEngineLevel();
        this.engineDurability = other.getEngineDurability();
        this.maxEngineDurability = other.getMaxEngineDurability();
        this.engineSoundTime = other.getEngineSoundTime();
        this.engineSound = other.getEngineSound();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (!this.engineItem.m_41619_()) {
            CompoundTag engineTag = new CompoundTag();
            this.engineItem.m_41739_(engineTag);
            tag.m_128365_("EngineItem", (Tag)engineTag);
        }
        tag.m_128347_("Power", this.power);
        tag.m_128350_("FlightSpeed", this.flightSpeed);
        tag.m_128350_("Friction", this.friction);
        tag.m_128350_("StopThreshold", this.stopThreshold);
        tag.m_128350_("Scceleration", this.acceleration);
        tag.m_128405_("EngineLevel", this.engineLevel);
        tag.m_128405_("EngineDurability", this.engineDurability);
        tag.m_128405_("MaxEngineDurability", this.maxEngineDurability);
        tag.m_128405_("EngineSoundTime", this.engineSoundTime);
        if (this.engineSound != null) {
            tag.m_128359_("EngineSound", this.engineSound.m_11660_().toString());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        String soundLocation;
        ResourceLocation soundRL;
        if (nbt.m_128441_("EngineItem")) {
            this.engineItem = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("EngineItem"));
            this.setPropertiesFromEngine(this.engineItem);
        }
        this.power = nbt.m_128459_("Power");
        this.flightSpeed = nbt.m_128457_("FlightSpeed");
        this.friction = nbt.m_128457_("Friction");
        this.stopThreshold = nbt.m_128457_("StopThreshold");
        this.acceleration = nbt.m_128457_("Scceleration");
        this.engineLevel = nbt.m_128451_("EngineLevel");
        this.engineDurability = nbt.m_128451_("EngineDurability");
        this.maxEngineDurability = nbt.m_128451_("MaxEngineDurability");
        this.engineSoundTime = nbt.m_128451_("EngineSoundTime");
        if (nbt.m_128441_("EngineSound") && (soundRL = ResourceLocation.m_135820_((String)(soundLocation = nbt.m_128461_("EngineSound")))) != null) {
            this.engineSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundRL);
        }
    }

    private void setPropertiesFromEngine(ItemStack engineStack) {
        Item item = engineStack.m_41720_();
        if (item instanceof Engine) {
            Engine engineItem = (Engine)item;
            this.power = engineItem.getPower();
            this.flightSpeed = engineItem.getFlightSpeed();
            this.friction = engineItem.getFriction();
            this.stopThreshold = engineItem.getStopThreshold();
            this.acceleration = engineItem.getAcceleration();
            this.engineLevel = engineItem.getEngineLevel();
            this.engineDurability = engineItem.getEngineDurability();
            this.engineSoundTime = engineItem.getEngineSoundTime();
            this.engineSound = engineItem.getEngineSound();
        } else {
            this.power = 30.0;
            this.flightSpeed = 1.0f;
            this.friction = 0.93f;
            this.stopThreshold = 0.005f;
            this.acceleration = 0.3f;
            this.engineLevel = 1;
            this.engineDurability = 2564;
            this.maxEngineDurability = 2564;
            this.engineSoundTime = 0;
            this.engineSound = null;
        }
    }
}

