/*
 * Decompiled with CFR 0.152.
 */
package com.kfhzs.allthingsflying.enchantment;

import com.kfhzs.allthingsflying.enchantment.ModEnchantments;
import com.kfhzs.allthingsflying.recipe.EngineHelper;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.Level;

public class EngineMendingEnchantment
extends Enchantment {
    public static final EnchantmentCategory HAS_ENGINE = EnchantmentCategory.create((String)"has_engine", item -> true);

    public EngineMendingEnchantment() {
        super(Enchantment.Rarity.RARE, HAS_ENGINE, new EquipmentSlot[]{EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND});
    }

    public int m_6183_(int level) {
        return 1 + (level - 1) * 10;
    }

    public int m_6175_(int level) {
        return super.m_6183_(level) + 5;
    }

    public int m_44702_() {
        return super.m_44702_();
    }

    public int m_6586_() {
        return 1;
    }

    public boolean m_6081_(ItemStack stack) {
        return EngineHelper.hasEngine(stack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.m_6081_(stack);
    }

    public static boolean shouldRepairEngine(Player player, ItemStack itemStack) {
        if (player == null || itemStack.m_41619_()) {
            return false;
        }
        return itemStack.getEnchantmentLevel((Enchantment)ModEnchantments.ENGINE_MENDING.get()) > 0;
    }

    public static boolean tryRepairEngine(Player player, ItemStack itemStack, Level level) {
        int maxDurability;
        if (!EngineMendingEnchantment.shouldRepairEngine(player, itemStack)) {
            return false;
        }
        if (!EngineHelper.hasEngine(itemStack)) {
            return false;
        }
        int currentDurability = EngineHelper.getEngineDurability(itemStack);
        if (currentDurability >= (maxDurability = EngineHelper.getMaxEngineDurability(itemStack))) {
            return false;
        }
        if (player.f_36079_ <= 0) {
            return false;
        }
        int repairAmount = Math.min(5, maxDurability - currentDurability);
        int experienceCost = Math.min(repairAmount, player.f_36079_);
        if (experienceCost <= 0) {
            return false;
        }
        int newDurability = currentDurability + experienceCost;
        EngineHelper.setEngineDurability(itemStack, Math.min(newDurability, maxDurability));
        player.m_6756_(-experienceCost);
        return true;
    }
}

