/*
 * Decompiled with CFR 0.152.
 */
package com.kfhzs.allthingsflying.entity;

import com.kfhzs.allthingsflying.enchantment.EngineMendingEnchantment;
import com.kfhzs.allthingsflying.items.ItemsRegister;
import com.kfhzs.allthingsflying.network.AerocrafAscendingPacket;
import com.kfhzs.allthingsflying.network.AerocrafSprintingPacket;
import com.kfhzs.allthingsflying.network.NetworkHandler;
import com.kfhzs.allthingsflying.particle.ModParticles;
import com.kfhzs.allthingsflying.recipe.EngineHelper;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AerocrafEntity
extends Entity
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected static final EntityDataAccessor<ItemStack> ITEM_STACK = SynchedEntityData.m_135353_(AerocrafEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Integer> DATA_ID_HURT = SynchedEntityData.m_135353_(AerocrafEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_HURTDIR = SynchedEntityData.m_135353_(AerocrafEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_ID_DAMAGE = SynchedEntityData.m_135353_(AerocrafEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<String> DATA_ID_PLAYER_ACTION = SynchedEntityData.m_135353_(AerocrafEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Optional<UUID>> DATA_OWNERUUID_ID = SynchedEntityData.m_135353_(AerocrafEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Boolean> DATA_SPRINTING = SynchedEntityData.m_135353_(AerocrafEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Float> DATA_MAX_SPEED = SynchedEntityData.m_135353_(AerocrafEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> DATA_ASCENDING = SynchedEntityData.m_135353_(AerocrafEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState animationState = new AnimationState();
    private int collisionCooldown = 0;
    protected int actionsTick = 10;
    private float defaultXRot = 0.0f;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    protected float playerSpeed = 0.0f;
    private SoundEvent currentEngineSound;
    private int soundTime;

    public AerocrafEntity(EntityType<?> aSuper, Level level) {
        super(aSuper, level);
    }

    protected float m_6380_(Pose pose, EntityDimensions dimensions) {
        return dimensions.f_20378_;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ID_HURT, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_HURTDIR, (Object)1);
        this.f_19804_.m_135372_(DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_OWNERUUID_ID, Optional.empty());
        this.f_19804_.m_135372_(DATA_SPRINTING, (Object)false);
        this.f_19804_.m_135372_(DATA_ASCENDING, (Object)false);
    }

    protected void m_7840_(double p_38307_, boolean p_38308_, BlockState blockState, BlockPos pos) {
        if (this.m_20096_()) {
            this.m_183634_();
        }
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public void m_8119_() {
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        if (this.m_20069_() && !this.m_9236_().f_46443_) {
            ItemStack stack = this.m_142340_();
            if (stack != null && !stack.m_41619_()) {
                this.m_19983_(stack);
                this.m_146870_();
                this.m_146850_(GameEvent.f_223707_);
            }
            return;
        }
        super.m_8119_();
        Level level = this.m_9236_();
        ItemStack stack = this.getItemStack();
        if (!level.f_46443_ && this.collisionCooldown > 0) {
            --this.collisionCooldown;
        }
        SoundEvent engineSound = EngineHelper.getEngineSound(stack);
        int engineSoundTime = EngineHelper.getEngineSoundTime(stack);
        Entity entity = this.m_146895_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.checkCollisionDamage();
            if ((double)this.playerSpeed > 0.1) {
                boolean isSprinting;
                if (level.f_46443_ && (isSprinting = Minecraft.m_91087_().f_91066_.f_92091_.m_90857_())) {
                    NetworkHandler.sendToServer(new AerocrafSprintingPacket(this.m_19879_(), isSprinting));
                }
                if (!EngineHelper.getEngineItem(stack).m_150930_((Item)ItemsRegister.THERMAL_ENGINE.get()) && !EngineHelper.getEngineItem(stack).m_150930_((Item)ItemsRegister.DRONE_ENGINE.get())) {
                    if (engineSound != null && this.soundTime <= 0) {
                        this.soundTime = engineSoundTime;
                        level.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), engineSound, SoundSource.PLAYERS, 1.5f, 1.0f);
                        this.currentEngineSound = engineSound;
                    }
                    --this.soundTime;
                }
            } else {
                if (this.f_19797_ % 20 == 0 && !stack.m_41619_()) {
                    EngineMendingEnchantment.tryRepairEngine(player, stack, this.m_9236_());
                }
                if (!EngineHelper.getEngineItem(stack).m_150930_((Item)ItemsRegister.THERMAL_ENGINE.get()) && !EngineHelper.getEngineItem(stack).m_150930_((Item)ItemsRegister.DRONE_ENGINE.get())) {
                    this.stopEngineSound();
                }
            }
            if (level.f_46443_) {
                boolean isJump = Minecraft.m_91087_().f_91066_.f_92089_.m_90857_();
                NetworkHandler.sendToServer(new AerocrafAscendingPacket(this.m_19879_(), isJump));
            }
            if (this.isAscending()) {
                Vec3 currentMotion = this.m_20184_();
                this.m_20334_(currentMotion.f_82479_, 0.5, currentMotion.f_82481_);
            }
            if (this.m_20142_() && this.f_19797_ % 20 == 0 && !level.f_46443_) {
                ItemStack itemStack = this.getItemStack();
                int engineDurability = EngineHelper.getEngineDurability(itemStack);
                int engineLevel = EngineHelper.getEngineLevel(itemStack);
                EngineHelper.setEngineDurability(itemStack, engineDurability - engineLevel * 2);
            }
        }
        if (EngineHelper.getEngineItem(this.getItemStack()).m_150930_((Item)ItemsRegister.THERMAL_ENGINE.get()) || EngineHelper.getEngineItem(this.getItemStack()).m_150930_((Item)ItemsRegister.DRONE_ENGINE.get())) {
            if (engineSound != null && this.soundTime <= 0) {
                this.soundTime = engineSoundTime;
                level.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), engineSound, SoundSource.PLAYERS, 1.5f, 1.0f);
                this.currentEngineSound = engineSound;
            }
            --this.soundTime;
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20101_();
        List list = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82377_((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelector.m_20421_((Entity)this));
        if (!list.isEmpty()) {
            boolean flag = !this.m_9236_().f_46443_ && !(this.m_6688_() instanceof Player);
            for (int j = 0; j < list.size(); ++j) {
                Entity entity2 = (Entity)list.get(j);
                if (entity2.m_20363_((Entity)this)) continue;
                boolean b = this.hasEnoughSpaceFor(entity2);
                if (flag && this.m_20197_().size() < this.getMaxPassengers() && !entity2.m_20159_() && b && entity2 instanceof LivingEntity && !(entity2 instanceof WaterAnimal) && !(entity2 instanceof Player)) {
                    entity2.m_20329_((Entity)this);
                    continue;
                }
                this.m_7334_(entity2);
            }
        }
    }

    private void stopEngineSound() {
        if (this.currentEngineSound != null) {
            Minecraft.m_91087_().m_91106_().m_120386_(this.currentEngineSound.m_11660_(), SoundSource.PLAYERS);
            this.currentEngineSound = null;
        }
    }

    public void spawnThermalEngineParticles(AerocrafEntity entity, double speed, double lerpXZ, double lerpY) {
        if (entity.m_9236_().f_46443_) {
            Vec3 lookVec = entity.m_20154_();
            double spawnX = entity.m_20185_() - lookVec.f_82479_ * lerpXZ;
            double spawnY = entity.m_20186_() + lerpY * 1.5;
            double spawnZ = entity.m_20189_() - lookVec.f_82481_ * lerpXZ;
            for (int i = 0; i < 3; ++i) {
                double baseSpeed = speed + Math.random() * 0.3;
                double spreadX = (Math.random() - 0.5) * 0.1;
                double spreadY = (Math.random() - 0.5) * 0.1;
                double spreadZ = (Math.random() - 0.5) * 0.1;
                entity.m_9236_().m_7106_((ParticleOptions)ModParticles.THERMAL_ENGINE_SMOKE.get(), spawnX + (Math.random() - 0.5) * 0.3, spawnY + (Math.random() - 0.5) * 0.3, spawnZ + (Math.random() - 0.5) * 0.3, -lookVec.f_82479_ * baseSpeed + spreadX, -lookVec.f_82480_ * baseSpeed * 0.3 + spreadY + 0.02, -lookVec.f_82481_ * baseSpeed + spreadZ);
            }
        }
    }

    public void spawnCloudEngineParticles(AerocrafEntity entity, double speed, double lerpXZ, double lerpY) {
        if (entity.m_9236_().f_46443_) {
            Vec3 lookVec = entity.m_20154_();
            double spawnX = entity.m_20185_() - lookVec.f_82479_ * lerpXZ;
            double spawnY = entity.m_20186_() + lerpY - lookVec.f_82480_ * 1.5;
            double spawnZ = entity.m_20189_() - lookVec.f_82481_ * lerpXZ;
            for (int i = 0; i < 5; ++i) {
                double baseSpeed = speed * 0.3 + Math.random() * 0.3;
                double spreadX = (Math.random() - 0.5) * 0.1;
                double spreadY = (Math.random() - 0.5) * 0.1;
                double spreadZ = (Math.random() - 0.5) * 0.1;
                entity.m_9236_().m_7106_((ParticleOptions)ModParticles.CLOUD_ENGINE_SMOKE.get(), spawnX + (Math.random() - 0.5) * 0.3, spawnY + (Math.random() - 0.5) * 0.3, spawnZ + (Math.random() - 0.5) * 0.3, -lookVec.f_82479_ * baseSpeed + spreadX, -lookVec.f_82480_ * baseSpeed * 0.3 + spreadY + 0.02, -lookVec.f_82481_ * baseSpeed + spreadZ);
            }
        }
    }

    protected void checkCollisionDamage() {
        if (this.collisionCooldown > 0) {
            return;
        }
        if ((double)this.playerSpeed < 0.5) {
            return;
        }
        Vec3 lookVec = this.m_20154_().m_82490_(2.0);
        AABB collisionBox = this.m_20191_().m_82369_(lookVec).m_82400_(0.5);
        List entities = this.m_9236_().m_6249_((Entity)this, collisionBox, entity -> entity instanceof LivingEntity && entity != this.m_146895_() && !this.m_20363_((Entity)entity));
        for (Entity entity2 : entities) {
            if (!(entity2 instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity2;
            this.applyCollisionDamage(livingEntity, this.playerSpeed);
            this.collisionCooldown = 10;
        }
    }

    protected void applyCollisionDamage(LivingEntity target, float speed) {
        ItemStack itemStack = this.getItemStack();
        Entity entity = this.m_146895_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!target.m_21224_()) {
                target.m_6469_(this.m_269291_().m_269075_(player), speed * 2.0f);
            }
            if (!this.m_9236_().f_46443_) {
                int engineDurability = EngineHelper.getEngineDurability(itemStack);
                int engineLevel = EngineHelper.getEngineLevel(itemStack);
                EngineHelper.setEngineDurability(itemStack, engineDurability - engineLevel * 4);
            }
            for (Entity entity2 : this.m_20197_()) {
                if (!(entity2 instanceof Player)) continue;
                Player player1 = (Player)entity2;
                if (player.m_150109_().m_36052_(3).m_41619_()) {
                    player1.m_6469_(this.m_269291_().m_269374_((Entity)target), speed * 3.0f);
                    continue;
                }
                player1.m_6469_(this.m_269291_().m_269374_((Entity)target), speed * 2.0f);
            }
        }
        Vec3 knockback = this.m_20154_().m_82490_((double)(speed * 0.5f));
        target.m_5997_(knockback.f_82479_, knockback.f_82480_ * 0.5, knockback.f_82481_);
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12316_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public void m_20351_(Entity passenger) {
        super.m_20351_(passenger);
        if (passenger instanceof Player) {
            ModifierLayer animation;
            Player rider = (Player)passenger;
            if (this.m_9236_().f_46443_ && (animation = (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)((AbstractClientPlayer)rider)).get(Objects.requireNonNull(ResourceLocation.m_214293_((String)"allthingsflying", (String)"animation")))) != null && animation.isActive()) {
                animation.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)5, (Ease)Ease.INOUTSINE), null);
            }
            if (!EngineHelper.getEngineItem(this.getItemStack()).m_150930_((Item)ItemsRegister.THERMAL_ENGINE.get()) && !EngineHelper.getEngineItem(this.getItemStack()).m_150930_((Item)ItemsRegister.DRONE_ENGINE.get())) {
                this.stopEngineSound();
            }
        }
        if (this.m_20197_().isEmpty()) {
            this.m_146926_(this.defaultXRot);
            this.f_19860_ = this.defaultXRot;
        }
    }

    public void m_6453_(double pX, double pY, double pZ, float pYRot, float pXRot, int pLerpSteps, boolean pTeleport) {
        this.lerpX = pX;
        this.lerpY = pY;
        this.lerpZ = pZ;
        this.lerpYRot = pYRot;
        this.lerpXRot = pXRot;
        this.lerpSteps = 10;
    }

    public boolean hasEnoughSpaceFor(Entity entity) {
        return entity.m_20205_() < this.m_20205_();
    }

    protected boolean m_7310_(Entity p_38390_) {
        return this.m_20197_().size() < this.getMaxPassengers();
    }

    protected int getMaxPassengers() {
        return 2;
    }

    protected void clampRotation(Entity entity) {
        entity.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
        entity.f_19859_ += f1 - f;
        entity.m_146922_(entity.m_146908_() + f1 - f);
        entity.m_5616_(entity.m_146908_());
        if (entity == this.m_146895_() && this.m_146895_() instanceof Player) {
            this.m_146922_(entity.m_146908_());
            this.m_146926_(entity.m_146909_() * 0.5f);
            this.f_19860_ = this.m_146909_();
        }
    }

    public void m_7340_(Entity entity) {
        this.clampRotation(entity);
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6469_(@NotNull DamageSource damageSource, float p_38320_) {
        if (this.m_6673_(damageSource) || damageSource.m_276093_(DamageTypes.f_268546_) || damageSource.m_276093_(DamageTypes.f_268631_) || damageSource.m_276093_(DamageTypes.f_268468_)) {
            this.m_20095_();
            return false;
        }
        if (!this.m_9236_().f_46443_ && !this.m_213877_()) {
            if (this.getOwnerUUID() == null || damageSource.m_7639_() == null || damageSource.m_7639_() != null && !this.getOwnerUUID().equals(damageSource.m_7639_().m_20148_())) {
                boolean flag;
                if (this.getOwnerUUID() != null && damageSource.m_7639_() != null) {
                    ServerPlayer player = this.m_9236_().m_7654_().m_6846_().m_11259_(this.f_19820_);
                    player.m_6469_(new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268515_), damageSource.m_7639_()), 10.0f);
                }
                this.setHurtDir(-this.getHurtDir());
                this.setHurtTime(10);
                this.setDamage(this.getDamage() + p_38320_ * 10.0f);
                this.m_5834_();
                this.m_146852_(GameEvent.f_223706_, damageSource.m_7639_());
                boolean bl = flag = damageSource.m_7639_() instanceof Player && ((Player)damageSource.m_7639_()).m_150110_().f_35937_;
                if (flag || this.getDamage() > 40.0f) {
                    if (!flag && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                        this.destroy(damageSource);
                    }
                    this.stopEngineSound();
                    this.m_146870_();
                }
            }
            return true;
        }
        return true;
    }

    public InteractionResult m_7111_(Player player, Vec3 vec3, InteractionHand hand) {
        if (!this.m_9236_().f_46443_) {
            if (player.m_6144_() && this.getOwnerUUID() != null && this.getOwnerUUID().equals(player.m_20148_())) {
                this.retrieveToPlayerInventory(player);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void retrieveToPlayerInventory(Player player) {
        ItemStack stack;
        this.stopEngineSound();
        if (!this.m_9236_().f_46443_ && (stack = this.m_142340_()) != null && !stack.m_41619_()) {
            if (player.m_150109_().m_36054_(stack)) {
                this.m_146870_();
                this.m_146850_(GameEvent.f_223707_);
            } else {
                player.m_36176_(stack, false);
                this.m_146870_();
            }
        }
    }

    protected float getSinglePassengerXOffset() {
        return 0.0f;
    }

    protected void destroy(DamageSource damageSource) {
        this.m_19998_((ItemLike)this.getDropItem());
    }

    public Item getDropItem() {
        return null;
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.getDropItem());
    }

    @Nullable
    public LivingEntity m_6688_() {
        LivingEntity livingentity;
        Entity entity = this.m_146895_();
        LivingEntity livingentity1 = entity instanceof LivingEntity ? (livingentity = (LivingEntity)entity) : null;
        return livingentity1;
    }

    protected void m_7378_(CompoundTag compoundTag) {
        UUID uuid;
        if (compoundTag.m_128403_("Owner")) {
            uuid = compoundTag.m_128342_("Owner");
        } else {
            String s = compoundTag.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)Objects.requireNonNull(this.m_20194_()), (String)s);
        }
        this.f_19804_.m_135381_(ITEM_STACK, (Object)ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("Item")));
        if (uuid != null) {
            this.setOwnerUUID(uuid);
        }
        if (compoundTag.m_128441_("Sprinting")) {
            this.m_6858_(compoundTag.m_128471_("Sprinting"));
        }
        if (compoundTag.m_128441_("FlySpeed")) {
            this.setMaxSpeed(compoundTag.m_128457_("FlySpeed"));
        }
        if (compoundTag.m_128441_("Ascending")) {
            this.setAscending(compoundTag.m_128471_("Ascending"));
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        if (this.getOwnerUUID() != null) {
            pCompound.m_128362_("Owner", this.getOwnerUUID());
        }
        pCompound.m_128365_("Item", (Tag)this.getItemStack().m_41739_(new CompoundTag()));
        pCompound.m_128379_("Sprinting", this.m_20142_());
        pCompound.m_128350_("FlySpeed", this.getMaxSpeed());
        pCompound.m_128379_("Ascending", this.isAscending());
    }

    public ItemStack getItemStack() {
        return (ItemStack)this.f_19804_.m_135370_(ITEM_STACK);
    }

    public void setHurtDir(int p_38363_) {
        this.f_19804_.m_135381_(DATA_ID_HURTDIR, (Object)p_38363_);
    }

    public int getHurtDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURTDIR);
    }

    public void setHurtTime(int p_38355_) {
        this.f_19804_.m_135381_(DATA_ID_HURT, (Object)p_38355_);
    }

    public int getHurtTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURT);
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DATA_ID_DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_ID_DAMAGE)).floatValue();
    }

    public String getDataIdPlayerAction() {
        return (String)this.f_19804_.m_135370_(DATA_ID_PLAYER_ACTION);
    }

    public void setDataIdPlayerAction(String dataIdPlayerAction) {
        this.f_19804_.m_135381_(DATA_ID_PLAYER_ACTION, (Object)dataIdPlayerAction);
    }

    public void setMaxSpeed(float maxSpeed) {
        this.f_19804_.m_135381_(DATA_MAX_SPEED, (Object)Float.valueOf(maxSpeed));
    }

    public float getMaxSpeed() {
        return ((Float)this.f_19804_.m_135370_(DATA_MAX_SPEED)).floatValue();
    }

    public void setAscending(boolean maxSpeed) {
        this.f_19804_.m_135381_(DATA_ASCENDING, (Object)maxSpeed);
    }

    public boolean isAscending() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ASCENDING);
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNERUUID_ID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.f_19804_.m_135381_(DATA_OWNERUUID_ID, Optional.ofNullable(pUuid));
    }

    public void m_6858_(boolean sprinting) {
        this.f_19804_.m_135381_(DATA_SPRINTING, (Object)sprinting);
    }

    public boolean m_20142_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SPRINTING) != false && EngineHelper.getEngineDurability(this.getItemStack()) > 0;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "idle", 0, state -> {
            if (this.m_20197_().isEmpty()) {
                state.setAndContinue(DefaultAnimations.IDLE);
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        })});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "fly", 0, state -> {
            if (!this.m_20197_().isEmpty()) {
                state.setAndContinue(DefaultAnimations.IDLE);
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

