/*
 * Decompiled with CFR 0.152.
 */
package com.kfhzs.allthingsflying.entity.aerocraft.drone;

import com.kfhzs.allthingsflying.entity.AerocrafEntity;
import com.kfhzs.allthingsflying.entity.EntityRegister;
import com.kfhzs.allthingsflying.items.ItemsRegister;
import com.kfhzs.allthingsflying.recipe.EngineHelper;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;

public class DroneEntity
extends AerocrafEntity {
    private float friction;
    private float stopThreshold;
    private float acceleration;
    private static final String[] ACTIONS = new String[]{"zuoxia2", "tangxia", "zhanli", "zhanli2", "zhanli3"};

    public DroneEntity(EntityType<?> aSuper, Level level) {
        super(aSuper, level);
        this.m_20242_(true);
        this.f_19850_ = true;
        this.m_20242_(true);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public DroneEntity(Level level, double p_38294_, double p_38295_, double p_38296_, ItemStack stack) {
        this((EntityType)EntityRegister.DRONE.get(), level);
        this.f_19804_.m_135381_(ITEM_STACK, (Object)stack.m_41777_().m_41620_(1));
        this.f_19854_ = p_38294_;
        this.f_19855_ = p_38295_;
        this.f_19856_ = p_38296_;
        this.m_6210_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ITEM_STACK, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_ID_PLAYER_ACTION, (Object)ACTIONS[RandomSource.m_216327_().m_188503_(ACTIONS.length)]);
        this.f_19804_.m_135372_(DATA_MAX_SPEED, (Object)Float.valueOf(0.0f));
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (ITEM_STACK.equals(key)) {
            this.m_6210_();
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 20 == 0) {
            this.updatePhysicsFromItem();
        }
        if (EngineHelper.getEngineItem(this.getItemStack()).m_150930_((Item)ItemsRegister.CLOUD_ENGINE.get()) && (double)this.playerSpeed > 0.2 && !this.m_20069_()) {
            this.spawnCloudEngineParticles(this, 0.15, 1.0, 0.3);
        }
        this.animationState.m_246184_(true, this.f_19797_);
        Entity entity = this.m_146895_();
        if (entity instanceof Player) {
            ModifierLayer animation;
            Player rider = (Player)entity;
            ItemStack mainHandItem = rider.m_21205_();
            ItemStack offhandItem = rider.m_21206_();
            if (this.m_9236_().f_46443_ && (animation = (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)((AbstractClientPlayer)rider)).get(Objects.requireNonNull(ResourceLocation.m_214293_((String)"allthingsflying", (String)"animation")))) != null) {
                String actionName = this.getDataIdPlayerAction();
                KeyframeAnimation keyframeAnimation = PlayerAnimationRegistry.getAnimation((ResourceLocation)Objects.requireNonNull(ResourceLocation.m_214293_((String)"allthingsflying", (String)actionName)));
                KeyframeAnimation keyframeAnimation1 = PlayerAnimationRegistry.getAnimation((ResourceLocation)Objects.requireNonNull(ResourceLocation.m_214293_((String)"allthingsflying", (String)(actionName + "_swinging"))));
                KeyframeAnimation keyframeAnimation2 = PlayerAnimationRegistry.getAnimation((ResourceLocation)Objects.requireNonNull(ResourceLocation.m_214293_((String)"allthingsflying", (String)(actionName + "_main_hand"))));
                KeyframeAnimation keyframeAnimation3 = PlayerAnimationRegistry.getAnimation((ResourceLocation)Objects.requireNonNull(ResourceLocation.m_214293_((String)"allthingsflying", (String)(actionName + "_off_hand"))));
                KeyframeAnimation keyframeAnimation4 = PlayerAnimationRegistry.getAnimation((ResourceLocation)Objects.requireNonNull(ResourceLocation.m_214293_((String)"allthingsflying", (String)(actionName + "_main_and_off_hand"))));
                if (keyframeAnimation != null) {
                    IAnimation iAnimation = animation.getAnimation();
                    if (iAnimation instanceof KeyframeAnimationPlayer) {
                        KeyframeAnimationPlayer currentPlayer = (KeyframeAnimationPlayer)iAnimation;
                        if (rider.f_20911_) {
                            if (keyframeAnimation1 != null && !currentPlayer.getData().equals((Object)keyframeAnimation1)) {
                                animation.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)5, (Ease)Ease.INOUTSINE), (IAnimation)new KeyframeAnimationPlayer(keyframeAnimation1));
                            }
                        } else if (!mainHandItem.m_41619_() && !offhandItem.m_41619_()) {
                            if (keyframeAnimation4 != null) {
                                if (!currentPlayer.getData().equals((Object)keyframeAnimation4)) {
                                    animation.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)5, (Ease)Ease.INOUTSINE), (IAnimation)new KeyframeAnimationPlayer(keyframeAnimation4));
                                }
                            } else if (!currentPlayer.getData().equals((Object)keyframeAnimation)) {
                                animation.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)5, (Ease)Ease.INOUTSINE), (IAnimation)new KeyframeAnimationPlayer(keyframeAnimation));
                            }
                        } else if (!mainHandItem.m_41619_()) {
                            if (keyframeAnimation2 != null) {
                                if (!currentPlayer.getData().equals((Object)keyframeAnimation2)) {
                                    animation.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)5, (Ease)Ease.INOUTSINE), (IAnimation)new KeyframeAnimationPlayer(keyframeAnimation2));
                                }
                            } else if (!currentPlayer.getData().equals((Object)keyframeAnimation)) {
                                animation.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)5, (Ease)Ease.INOUTSINE), (IAnimation)new KeyframeAnimationPlayer(keyframeAnimation));
                            }
                        } else if (!offhandItem.m_41619_()) {
                            if (keyframeAnimation3 != null) {
                                if (!currentPlayer.getData().equals((Object)keyframeAnimation3)) {
                                    animation.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)5, (Ease)Ease.INOUTSINE), (IAnimation)new KeyframeAnimationPlayer(keyframeAnimation3));
                                }
                            } else if (!currentPlayer.getData().equals((Object)keyframeAnimation)) {
                                animation.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)5, (Ease)Ease.INOUTSINE), (IAnimation)new KeyframeAnimationPlayer(keyframeAnimation));
                            }
                        } else if (!currentPlayer.getData().equals((Object)keyframeAnimation)) {
                            animation.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)5, (Ease)Ease.INOUTSINE), (IAnimation)new KeyframeAnimationPlayer(keyframeAnimation));
                        }
                    } else {
                        animation.setAnimation((IAnimation)new KeyframeAnimationPlayer(keyframeAnimation));
                    }
                }
            }
            this.m_146922_(rider.m_146908_());
            this.m_146926_(rider.m_146909_() * 0.5f);
            this.f_19860_ = this.m_146909_();
            float currentMaxSpeed = this.getMaxSpeed();
            float currentMaxReverseSpeed = currentMaxSpeed * 0.5f;
            if (!rider.m_7500_()) {
                if (rider.f_20902_ > 0.0f) {
                    float baseSpeed = this.playerSpeed + this.acceleration;
                    float targetSpeed = this.m_20142_() ? baseSpeed * 1.5f : baseSpeed;
                    float maxSpeed = this.m_20142_() ? currentMaxSpeed * 1.5f : currentMaxSpeed;
                    this.playerSpeed = Mth.m_14036_((float)targetSpeed, (float)0.0f, (float)maxSpeed);
                } else if (rider.f_20902_ < 0.0f) {
                    this.playerSpeed = Mth.m_14036_((float)(this.playerSpeed - this.acceleration), (float)(-currentMaxReverseSpeed), (float)0.0f);
                    this.m_6858_(false);
                } else {
                    this.m_6858_(false);
                    this.playerSpeed *= this.friction;
                    if (Math.abs(this.playerSpeed) < this.stopThreshold) {
                        this.playerSpeed = 0.0f;
                    }
                }
            } else if (rider.f_20902_ > 0.0f) {
                float baseSpeed = this.playerSpeed + this.acceleration;
                float targetSpeed = this.m_20142_() ? baseSpeed * 1.5f : baseSpeed;
                float maxSpeed = this.m_20142_() ? currentMaxSpeed * 1.5f : currentMaxSpeed;
                this.playerSpeed = Mth.m_14036_((float)targetSpeed, (float)0.0f, (float)maxSpeed);
            } else if (rider.f_20902_ < 0.0f) {
                this.m_6858_(false);
                this.playerSpeed = Mth.m_14036_((float)(this.playerSpeed - this.acceleration), (float)(-currentMaxReverseSpeed), (float)0.0f);
            } else {
                this.m_6858_(false);
                this.playerSpeed *= this.friction;
                if (Math.abs(this.playerSpeed) < this.stopThreshold) {
                    this.playerSpeed = 0.0f;
                }
            }
            boolean left = Minecraft.m_91087_().f_91066_.f_92086_.m_90857_();
            boolean right = Minecraft.m_91087_().f_91066_.f_92088_.m_90857_();
            if ((right || left) && !this.m_9236_().f_46443_) {
                if (this.actionsTick > 0) {
                    --this.actionsTick;
                }
                if (rider.f_20900_ != 0.0f && this.actionsTick == 0) {
                    String newAction = this.getString(rider);
                    this.setDataIdPlayerAction(newAction);
                    this.actionsTick = 10;
                }
            }
            float yRotRad = -this.m_146908_() * ((float)Math.PI / 180);
            float xRotRad = this.m_146909_() * ((float)Math.PI / 180);
            Vec3 movement = new Vec3((double)(Mth.m_14031_((float)yRotRad) * this.playerSpeed), (double)(-Mth.m_14031_((float)xRotRad) * this.playerSpeed), (double)(Mth.m_14089_((float)yRotRad) * this.playerSpeed));
            this.m_20256_(movement);
        } else {
            this.playerSpeed = 0.0f;
            this.m_6858_(false);
            this.m_20256_(Vec3.f_82478_);
        }
    }

    private void updatePhysicsFromItem() {
        ItemStack stack = this.getItemStack();
        if (!stack.m_41619_()) {
            this.setMaxSpeed(Math.max(EngineHelper.getFlightSpeed(stack), 0.1f));
            this.friction = Math.max(EngineHelper.getFriction(stack), 0.8f);
            this.stopThreshold = Math.max(EngineHelper.getStopThreshold(stack), 0.001f);
            this.acceleration = Math.max(EngineHelper.getAcceleration(stack), 0.1f);
        }
    }

    @NotNull
    private String getString(Player rider) {
        String currentAction = this.getDataIdPlayerAction();
        String newAction = rider.f_20900_ > 0.0f ? (currentAction.equals(ACTIONS[0]) ? ACTIONS[ACTIONS.length - 1] : ACTIONS[this.getActionIndex(currentAction) - 1]) : (currentAction.equals(ACTIONS[ACTIONS.length - 1]) ? ACTIONS[0] : ACTIONS[this.getActionIndex(currentAction) + 1]);
        return newAction;
    }

    private int getActionIndex(String action) {
        for (int i = 0; i < ACTIONS.length; ++i) {
            if (!ACTIONS[i].equals(action)) continue;
            return i;
        }
        return 0;
    }

    public double m_6048_() {
        if (!(this.m_146895_() instanceof Player)) {
            return 0.3f;
        }
        if (((String)this.f_19804_.m_135370_(DATA_ID_PLAYER_ACTION)).equals(ACTIONS[0]) || ((String)this.f_19804_.m_135370_(DATA_ID_PLAYER_ACTION)).equals(ACTIONS[1])) {
            return 0.4f;
        }
        return 1.0;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_36341_()) {
            return InteractionResult.PASS;
        }
        if (!this.m_9236_().f_46443_) {
            if (player.m_20329_((Entity)this)) {
                String action = ACTIONS[RandomSource.m_216327_().m_188503_(ACTIONS.length)];
                this.setDataIdPlayerAction(action);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected int getMaxPassengers() {
        return 1;
    }

    @Override
    protected void destroy(DamageSource damageSource) {
        super.destroy(damageSource);
    }

    @Override
    public ItemStack m_142340_() {
        return this.getItemStack();
    }

    @Override
    public Item getDropItem() {
        return this.getItemStack().m_41777_().m_41720_();
    }

    public boolean isFlying() {
        return this.playerSpeed > 0.0f && !this.m_20069_();
    }

    public float getPlayerSpeed() {
        return this.playerSpeed;
    }
}

