/*
 * Decompiled with CFR 0.152.
 */
package com.kfhzs.allthingsflying.entity.aerocraft.sword;

import com.kfhzs.allthingsflying.entity.aerocraft.sword.FlyingSwordEntity;
import com.kfhzs.allthingsflying.entity.item.model.AerocraftItemAeroEngineModel;
import com.kfhzs.allthingsflying.entity.item.model.AerocraftItemDroneEngineMod;
import com.kfhzs.allthingsflying.entity.item.model.AerocraftItemMagicEngineMod;
import com.kfhzs.allthingsflying.entity.item.model.AerocraftItemThermalEngineMod;
import com.kfhzs.allthingsflying.entity.rendertype.CustomBlendRenderType;
import com.kfhzs.allthingsflying.items.ItemsRegister;
import com.kfhzs.allthingsflying.recipe.EngineHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

@OnlyIn(value=Dist.CLIENT)
public class FlyingSwordEntityRender
extends GeoEntityRenderer<FlyingSwordEntity> {
    private final AerocraftItemAeroEngineModel<FlyingSwordEntity> aeroEngineModel;
    private final AerocraftItemThermalEngineMod<FlyingSwordEntity> thermalEngineModel;
    private final AerocraftItemMagicEngineMod<FlyingSwordEntity> magicEngineModel;
    private final AerocraftItemDroneEngineMod<FlyingSwordEntity> droneEngineModel;
    private static final ResourceLocation[] AERO_ENGINE_TEXTURES = FlyingSwordEntityRender.createTextureArray("aero_engine", 16);
    private static final ResourceLocation[] THERMAL_ENGINE_TEXTURES = FlyingSwordEntityRender.createTextureArray("thermal_engine", 20);
    private static final ResourceLocation[] MAGIC_ENGINE_TEXTURES = FlyingSwordEntityRender.createTextureArray("magic_engine", 20);
    private static final ResourceLocation[] DRONE_ENGINE_TEXTURES = FlyingSwordEntityRender.createTextureArray("drone_engine", 20);
    private static final float FRAME_DURATION = 0.05f;
    private static final boolean LOOP_ANIMATION = true;

    private static ResourceLocation[] createTextureArray(String engineName, int frameCount) {
        ResourceLocation[] textures = new ResourceLocation[frameCount];
        for (int i = 0; i < frameCount; ++i) {
            textures[i] = ResourceLocation.fromNamespaceAndPath((String)"allthingsflying", (String)("textures/entity/" + engineName + "/" + engineName + "_" + (i + 1) + ".png"));
        }
        return textures;
    }

    public FlyingSwordEntityRender(EntityRendererProvider.Context context) {
        super(context, (GeoModel)new DefaultedEntityGeoModel(ResourceLocation.m_214293_((String)"allthingsflying", (String)"flying_sword")));
        this.aeroEngineModel = new AerocraftItemAeroEngineModel(context.m_174023_(AerocraftItemAeroEngineModel.LAYER_LOCATION));
        this.thermalEngineModel = new AerocraftItemThermalEngineMod(context.m_174023_(AerocraftItemThermalEngineMod.LAYER_LOCATION));
        this.magicEngineModel = new AerocraftItemMagicEngineMod(context.m_174023_(AerocraftItemMagicEngineMod.LAYER_LOCATION));
        this.droneEngineModel = new AerocraftItemDroneEngineMod(context.m_174023_(AerocraftItemDroneEngineMod.LAYER_LOCATION));
    }

    public void render(FlyingSwordEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        float lerpYRot = Mth.m_14179_((float)partialTick, (float)entity.f_19859_, (float)entity.m_146908_());
        float lerpXRot = Mth.m_14179_((float)partialTick, (float)entity.f_19860_, (float)entity.m_146909_());
        poseStack.m_252781_(Axis.f_252436_.m_252977_(360.0f - lerpYRot));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(lerpXRot));
        super.m_7392_((Entity)entity, entityYaw, partialTick, poseStack, buffer, packedLight);
        if (EngineHelper.getEngineItem(entity.getItemStack()).m_150930_((Item)ItemsRegister.AERO_ENGINE.get())) {
            this.renderAeroEngineModelEffect(entity, partialTick, poseStack, buffer, packedLight, lerpYRot, lerpXRot);
        } else if (EngineHelper.getEngineItem(entity.getItemStack()).m_150930_((Item)ItemsRegister.THERMAL_ENGINE.get())) {
            this.renderThermalEngineModelEffect(entity, partialTick, poseStack, buffer, packedLight, lerpYRot, lerpXRot);
        } else if (EngineHelper.getEngineItem(entity.getItemStack()).m_150930_((Item)ItemsRegister.MAGIC_ENGINE.get())) {
            this.renderMagicEngineEffect(entity, partialTick, poseStack, buffer, packedLight, lerpYRot, lerpXRot);
        } else if (EngineHelper.getEngineItem(entity.getItemStack()).m_150930_((Item)ItemsRegister.DRONE_ENGINE.get())) {
            this.renderDroneEngineEffect(entity, partialTick, poseStack, buffer, packedLight, lerpYRot, lerpXRot);
        }
        poseStack.m_85849_();
    }

    private void renderAeroEngineModelEffect(FlyingSwordEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, float lerpYRot, float lerpXRot) {
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        poseStack.m_252880_(0.0f, 0.0f, -1.5f);
        poseStack.m_85841_(0.25f, 0.25f, 1.0f);
        int currentFrame = this.getCurrentFrameIndex(entity, partialTicks, AERO_ENGINE_TEXTURES.length);
        ResourceLocation currentTexture = this.getFrameTexture(currentFrame, entity.getItemStack());
        this.aeroEngineModel.m_6973_(entity, 0.0f, 0.0f, (float)entity.f_19797_ + partialTicks, lerpYRot, lerpXRot);
        float alpha = this.calculateAlphaSmooth(entity);
        this.aeroEngineModel.m_7695_(poseStack, buffer.m_6299_(CustomBlendRenderType.wind(currentTexture)), packedLight, OverlayTexture.f_118083_, 0.67f, 0.94f, 0.93f, alpha);
        poseStack.m_85849_();
    }

    private void renderThermalEngineModelEffect(FlyingSwordEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, float lerpYRot, float lerpXRot) {
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        poseStack.m_252880_(0.0f, -0.1f, 1.2f);
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        int currentFrame = this.getCurrentFrameIndex(entity, partialTicks, THERMAL_ENGINE_TEXTURES.length);
        ResourceLocation currentTexture = this.getFrameTexture(currentFrame, entity.getItemStack());
        this.thermalEngineModel.m_6973_(entity, 0.0f, 0.0f, (float)entity.f_19797_ + partialTicks, lerpYRot, lerpXRot);
        this.thermalEngineModel.m_7695_(poseStack, buffer.m_6299_(CustomBlendRenderType.wind(currentTexture)), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.5f);
        poseStack.m_85849_();
    }

    private void renderMagicEngineEffect(FlyingSwordEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, float lerpYRot, float lerpXRot) {
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        poseStack.m_252880_(0.0f, -1.2f, 2.2f);
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
        int currentFrame = this.getCurrentFrameIndex(entity, partialTicks, MAGIC_ENGINE_TEXTURES.length);
        ResourceLocation currentTexture = this.getFrameTexture(currentFrame, entity.getItemStack());
        this.magicEngineModel.m_6973_(entity, 0.0f, 0.0f, (float)entity.f_19797_ + partialTicks, lerpYRot, lerpXRot);
        float alpha = this.calculateAlphaSmooth(entity);
        this.magicEngineModel.m_7695_(poseStack, buffer.m_6299_(CustomBlendRenderType.wind(currentTexture)), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha);
        poseStack.m_85849_();
    }

    private void renderDroneEngineEffect(FlyingSwordEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, float lerpYRot, float lerpXRot) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, -1.0f, 0.0f);
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        int currentFrame = this.getCurrentFrameIndex(entity, partialTicks, DRONE_ENGINE_TEXTURES.length);
        ResourceLocation currentTexture = this.getFrameTexture(currentFrame, entity.getItemStack());
        this.droneEngineModel.m_6973_(entity, 0.0f, 0.0f, (float)entity.f_19797_ + partialTicks, lerpYRot, lerpXRot);
        this.droneEngineModel.m_7695_(poseStack, buffer.m_6299_(CustomBlendRenderType.wind(currentTexture)), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.7f);
        poseStack.m_85849_();
    }

    private float calculateAlphaSmooth(FlyingSwordEntity animatable) {
        float currentSpeed = Math.abs(animatable.getPlayerSpeed());
        float maxSpeed = animatable.getMaxSpeed();
        float speedRatio = Mth.m_14036_((float)(currentSpeed / maxSpeed), (float)0.0f, (float)0.7f);
        return speedRatio * speedRatio;
    }

    private int getCurrentFrameIndex(FlyingSwordEntity animatable, float partialTick, int totalFrames) {
        float totalTime = ((float)animatable.f_19797_ + partialTick) * 0.05f;
        float animationTime = totalTime % ((float)totalFrames * 0.05f);
        return Mth.m_14143_((float)(animationTime / 0.05f)) % totalFrames;
    }

    private ResourceLocation getFrameTexture(int frameIndex, ItemStack stack) {
        if (EngineHelper.getEngineItem(stack).m_150930_((Item)ItemsRegister.AERO_ENGINE.get())) {
            if (frameIndex >= 0 && frameIndex < AERO_ENGINE_TEXTURES.length) {
                return AERO_ENGINE_TEXTURES[frameIndex];
            }
        } else if (EngineHelper.getEngineItem(stack).m_150930_((Item)ItemsRegister.THERMAL_ENGINE.get())) {
            if (frameIndex >= 0 && frameIndex < THERMAL_ENGINE_TEXTURES.length) {
                return THERMAL_ENGINE_TEXTURES[frameIndex];
            }
        } else if (EngineHelper.getEngineItem(stack).m_150930_((Item)ItemsRegister.MAGIC_ENGINE.get())) {
            if (frameIndex >= 0 && frameIndex < MAGIC_ENGINE_TEXTURES.length) {
                return MAGIC_ENGINE_TEXTURES[frameIndex];
            }
        } else if (EngineHelper.getEngineItem(stack).m_150930_((Item)ItemsRegister.DRONE_ENGINE.get()) && frameIndex >= 0 && frameIndex < DRONE_ENGINE_TEXTURES.length) {
            return DRONE_ENGINE_TEXTURES[frameIndex];
        }
        return AERO_ENGINE_TEXTURES[0];
    }
}

