/*
 * Decompiled with CFR 0.152.
 */
package com.kfhzs.allthingsflying.entity.item;

import com.kfhzs.allthingsflying.entity.item.AerocraftItemEntity;
import com.kfhzs.allthingsflying.entity.item.model.AerocraftBedItemDroneEngineMod;
import com.kfhzs.allthingsflying.entity.item.model.AerocraftBlockItemAeroEngineModel;
import com.kfhzs.allthingsflying.entity.item.model.AerocraftItemAeroEngineModel;
import com.kfhzs.allthingsflying.entity.item.model.AerocraftItemDroneEngineMod;
import com.kfhzs.allthingsflying.entity.item.model.AerocraftItemMagicEngineMod;
import com.kfhzs.allthingsflying.entity.item.model.AerocraftItemThermalEngineMod;
import com.kfhzs.allthingsflying.entity.rendertype.CustomBlendRenderType;
import com.kfhzs.allthingsflying.items.ItemsRegister;
import com.kfhzs.allthingsflying.recipe.EngineHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BedItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class AerocraftItemRenderer
extends EntityRenderer<AerocraftItemEntity> {
    private final ItemRenderer itemRenderer;
    private final AerocraftItemAeroEngineModel<AerocraftItemEntity> aeroEngineModel;
    private final AerocraftBlockItemAeroEngineModel<AerocraftItemEntity> blockAeroEngineModel;
    private final AerocraftItemThermalEngineMod<AerocraftItemEntity> thermalEngineModel;
    private final AerocraftItemMagicEngineMod<AerocraftItemEntity> magicEngineModel;
    private final AerocraftItemDroneEngineMod<AerocraftItemEntity> droneEngineModel;
    private final AerocraftBedItemDroneEngineMod<AerocraftItemEntity> droneEngineBedModel;
    private static final ResourceLocation[] AERO_ENGINE_TEXTURES = AerocraftItemRenderer.createTextureArray("aero_engine", 16);
    private static final ResourceLocation[] THERMAL_ENGINE_TEXTURES = AerocraftItemRenderer.createTextureArray("thermal_engine", 20);
    private static final ResourceLocation[] MAGIC_ENGINE_TEXTURES = AerocraftItemRenderer.createTextureArray("magic_engine", 20);
    private static final ResourceLocation[] DRONE_ENGINE_TEXTURES = AerocraftItemRenderer.createTextureArray("drone_engine", 20);
    private static final float FRAME_DURATION = 0.05f;
    private static final boolean LOOP_ANIMATION = true;

    private static ResourceLocation[] createTextureArray(String engineName, int frameCount) {
        ResourceLocation[] textures = new ResourceLocation[frameCount];
        for (int i = 0; i < frameCount; ++i) {
            textures[i] = ResourceLocation.fromNamespaceAndPath((String)"allthingsflying", (String)("textures/entity/" + engineName + "/" + engineName + "_" + (i + 1) + ".png"));
        }
        return textures;
    }

    public AerocraftItemRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.m_174025_();
        this.aeroEngineModel = new AerocraftItemAeroEngineModel(context.m_174023_(AerocraftItemAeroEngineModel.LAYER_LOCATION));
        this.blockAeroEngineModel = new AerocraftBlockItemAeroEngineModel(context.m_174023_(AerocraftBlockItemAeroEngineModel.LAYER_LOCATION));
        this.thermalEngineModel = new AerocraftItemThermalEngineMod(context.m_174023_(AerocraftItemThermalEngineMod.LAYER_LOCATION));
        this.magicEngineModel = new AerocraftItemMagicEngineMod(context.m_174023_(AerocraftItemMagicEngineMod.LAYER_LOCATION));
        this.droneEngineModel = new AerocraftItemDroneEngineMod(context.m_174023_(AerocraftItemDroneEngineMod.LAYER_LOCATION));
        this.droneEngineBedModel = new AerocraftBedItemDroneEngineMod(context.m_174023_(AerocraftBedItemDroneEngineMod.LAYER_LOCATION));
    }

    public void render(AerocraftItemEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        BlockItem blockItem;
        poseStack.m_85836_();
        float lerpYRot = Mth.m_14179_((float)partialTicks, (float)entity.f_19859_, (float)entity.m_146908_());
        float lerpXRot = Mth.m_14179_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_());
        Item item = entity.getItemStack().m_41720_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(360.0f - lerpYRot));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(item instanceof BlockItem && !((blockItem = (BlockItem)item).m_40614_() instanceof BushBlock) && !(blockItem.m_40614_() instanceof SignBlock) && !(blockItem.m_40614_() instanceof LadderBlock) && !(blockItem.m_40614_() instanceof DoorBlock) ? 0.0f : 90.0f + lerpXRot));
        poseStack.m_85841_(1.5f, 1.5f, 1.5f);
        poseStack.m_252880_(0.0f, 0.0f, -0.1f);
        if (item instanceof TieredItem || item instanceof Vanishable) {
            if (item instanceof TridentItem) {
                poseStack.m_252880_(0.5f, 1.5f, 0.5f);
            } else {
                poseStack.m_252781_(Axis.f_252403_.m_252977_(item instanceof Equipable ? 0.0f : 45.0f));
            }
        } else if (item instanceof BlockItem && !((blockItem = (BlockItem)item).m_40614_() instanceof SignBlock) && !(blockItem.m_40614_() instanceof DoorBlock)) {
            if (blockItem.m_40614_() instanceof SkullBlock && !item.m_7968_().m_150930_(Blocks.f_50320_.m_5456_())) {
                poseStack.m_85841_(2.0f, 2.0f, 2.0f);
                poseStack.m_252880_(0.0f, 0.5f, 0.05f);
            } else if (item.m_7968_().m_150930_(Blocks.f_50320_.m_5456_())) {
                poseStack.m_85841_(1.1f, 1.1f, 1.1f);
                poseStack.m_252880_(0.0f, 0.6f, 0.05f);
            } else if (blockItem.m_40614_() instanceof TrapDoorBlock) {
                poseStack.m_252880_(0.0f, 1.32f, 0.1f);
            } else if (blockItem.m_40614_() instanceof BedBlock) {
                poseStack.m_252880_(0.0f, 0.5f, 0.6f);
            } else if (blockItem.m_40614_() instanceof LadderBlock || blockItem.m_40614_() instanceof BushBlock) {
                poseStack.m_252880_(0.0f, 0.0f, 0.08f);
            } else {
                poseStack.m_252880_(0.0f, 0.5f, 0.1f);
            }
        }
        this.itemRenderer.m_269128_(entity.getItemStack(), ItemDisplayContext.NONE, packedLight, OverlayTexture.f_118083_, poseStack, buffer, entity.m_9236_(), entity.m_19879_());
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, yaw, partialTicks, poseStack, buffer, packedLight);
        if (EngineHelper.getEngineItem(entity.getItemStack()).m_150930_((Item)ItemsRegister.AERO_ENGINE.get())) {
            if (this.isSpecialBlockItem(item)) {
                this.renderAeroEngineBlockItemModelEffect(entity, partialTicks, poseStack, buffer, packedLight, lerpYRot, lerpXRot);
            } else {
                this.renderAeroEngineModelEffect(entity, partialTicks, poseStack, buffer, packedLight, lerpYRot, lerpXRot);
            }
        } else if (EngineHelper.getEngineItem(entity.getItemStack()).m_150930_((Item)ItemsRegister.THERMAL_ENGINE.get())) {
            if (this.isSpecialBlockItem(item)) {
                this.renderThermalEngineBlockItemModelEffect(entity, partialTicks, poseStack, buffer, packedLight, lerpYRot, lerpXRot);
            } else {
                this.renderThermalEngineModelEffect(entity, partialTicks, poseStack, buffer, packedLight, lerpYRot, lerpXRot);
            }
        } else if (EngineHelper.getEngineItem(entity.getItemStack()).m_150930_((Item)ItemsRegister.MAGIC_ENGINE.get())) {
            if (this.isSpecialBlockItem(item)) {
                this.renderMagicEngineBlockItemModelEffect(entity, partialTicks, poseStack, buffer, packedLight, lerpYRot, lerpXRot);
            } else {
                this.renderMagicEngineEffect(entity, partialTicks, poseStack, buffer, packedLight, lerpYRot, lerpXRot);
            }
        } else if (EngineHelper.getEngineItem(entity.getItemStack()).m_150930_((Item)ItemsRegister.DRONE_ENGINE.get())) {
            this.renderDroneEngineEffect(entity, partialTicks, poseStack, buffer, packedLight, lerpYRot, lerpXRot);
        }
    }

    private void renderAeroEngineModelEffect(AerocraftItemEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, float lerpYRot, float lerpXRot) {
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - lerpYRot));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-lerpXRot * 0.5f));
        poseStack.m_252880_(0.0f, 0.0f, 0.0f);
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        poseStack.m_252880_(0.0f, -0.8f, -1.3f);
        int currentFrame = this.getCurrentFrameIndex(entity, partialTicks, AERO_ENGINE_TEXTURES.length);
        ResourceLocation currentTexture = this.getFrameTexture(currentFrame, entity.getItemStack());
        this.aeroEngineModel.m_6973_(entity, 0.0f, 0.0f, (float)entity.f_19797_ + partialTicks, lerpYRot, lerpXRot);
        float alpha = this.calculateAlphaSmooth(entity);
        this.aeroEngineModel.m_7695_(poseStack, buffer.m_6299_(CustomBlendRenderType.wind(currentTexture)), packedLight, OverlayTexture.f_118083_, 0.67f, 0.94f, 0.93f, alpha);
        poseStack.m_85849_();
    }

    private void renderAeroEngineBlockItemModelEffect(AerocraftItemEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, float lerpYRot, float lerpXRot) {
        poseStack.m_85836_();
        Item item = entity.getItemStack().m_41720_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - lerpYRot));
        poseStack.m_252880_(0.0f, 0.0f, 0.0f);
        poseStack.m_85841_(0.375f, 0.375f, 0.375f);
        if (item instanceof BedItem) {
            poseStack.m_252880_(0.0f, 0.65f, -3.0f);
        } else {
            poseStack.m_252880_(0.0f, 1.3f, -1.3f);
        }
        int currentFrame = this.getCurrentFrameIndex(entity, partialTicks, AERO_ENGINE_TEXTURES.length);
        ResourceLocation currentTexture = this.getFrameTexture(currentFrame, entity.getItemStack());
        this.blockAeroEngineModel.m_6973_(entity, 0.0f, 0.0f, (float)entity.f_19797_ + partialTicks, lerpYRot, lerpXRot);
        float alpha = this.calculateAlphaSmooth(entity);
        this.blockAeroEngineModel.m_7695_(poseStack, buffer.m_6299_(CustomBlendRenderType.wind(currentTexture)), packedLight, OverlayTexture.f_118083_, 0.67f, 0.94f, 0.93f, alpha);
        poseStack.m_85849_();
    }

    private void renderThermalEngineModelEffect(AerocraftItemEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, float lerpYRot, float lerpXRot) {
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - lerpYRot));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-lerpXRot * 0.5f));
        poseStack.m_252880_(0.0f, 0.0f, 0.0f);
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        poseStack.m_252880_(0.0f, -0.2f, 1.5f);
        int currentFrame = this.getCurrentFrameIndex(entity, partialTicks, THERMAL_ENGINE_TEXTURES.length);
        ResourceLocation currentTexture = this.getFrameTexture(currentFrame, entity.getItemStack());
        this.thermalEngineModel.m_6973_(entity, 0.0f, 0.0f, (float)entity.f_19797_ + partialTicks, lerpYRot, lerpXRot);
        this.thermalEngineModel.m_7695_(poseStack, buffer.m_6299_(CustomBlendRenderType.wind(currentTexture)), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.5f);
        poseStack.m_85849_();
    }

    private void renderThermalEngineBlockItemModelEffect(AerocraftItemEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, float lerpYRot, float lerpXRot) {
        poseStack.m_85836_();
        Item item = entity.getItemStack().m_41720_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - lerpYRot));
        poseStack.m_252880_(0.0f, 0.0f, 0.0f);
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        if (item instanceof BedItem) {
            poseStack.m_252880_(0.0f, 0.8f, 3.0f);
        } else {
            poseStack.m_252880_(0.0f, 0.8f, 1.5f);
        }
        int currentFrame = this.getCurrentFrameIndex(entity, partialTicks, THERMAL_ENGINE_TEXTURES.length);
        ResourceLocation currentTexture = this.getFrameTexture(currentFrame, entity.getItemStack());
        this.thermalEngineModel.m_6973_(entity, 0.0f, 0.0f, (float)entity.f_19797_ + partialTicks, lerpYRot, lerpXRot);
        this.thermalEngineModel.m_7695_(poseStack, buffer.m_6299_(CustomBlendRenderType.wind(currentTexture)), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.5f);
        poseStack.m_85849_();
    }

    private void renderMagicEngineEffect(AerocraftItemEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, float lerpYRot, float lerpXRot) {
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - lerpYRot));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-lerpXRot * 0.5f));
        poseStack.m_252880_(0.0f, 0.0f, 0.0f);
        poseStack.m_85841_(0.7f, 0.7f, 0.7f);
        poseStack.m_252880_(0.0f, -1.2f, 1.5f);
        int currentFrame = this.getCurrentFrameIndex(entity, partialTicks, MAGIC_ENGINE_TEXTURES.length);
        ResourceLocation currentTexture = this.getFrameTexture(currentFrame, entity.getItemStack());
        this.magicEngineModel.m_6973_(entity, 0.0f, 0.0f, (float)entity.f_19797_ + partialTicks, lerpYRot, lerpXRot);
        float alpha = this.calculateAlphaSmooth(entity);
        this.magicEngineModel.m_7695_(poseStack, buffer.m_6299_(CustomBlendRenderType.wind(currentTexture)), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha);
        poseStack.m_85849_();
    }

    private void renderMagicEngineBlockItemModelEffect(AerocraftItemEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, float lerpYRot, float lerpXRot) {
        poseStack.m_85836_();
        Item item = entity.getItemStack().m_41720_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - lerpYRot));
        poseStack.m_252880_(0.0f, 0.0f, 0.0f);
        poseStack.m_85841_(0.7f, 0.7f, 0.7f);
        if (item instanceof BedItem) {
            poseStack.m_252880_(0.0f, -0.8f, 3.0f);
        } else {
            poseStack.m_252880_(0.0f, -1.2f, 1.5f);
        }
        int currentFrame = this.getCurrentFrameIndex(entity, partialTicks, MAGIC_ENGINE_TEXTURES.length);
        ResourceLocation currentTexture = this.getFrameTexture(currentFrame, entity.getItemStack());
        this.magicEngineModel.m_6973_(entity, 0.0f, 0.0f, (float)entity.f_19797_ + partialTicks, lerpYRot, lerpXRot);
        float alpha = this.calculateAlphaSmooth(entity);
        this.magicEngineModel.m_7695_(poseStack, buffer.m_6299_(CustomBlendRenderType.wind(currentTexture)), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha);
        poseStack.m_85849_();
    }

    private void renderDroneEngineEffect(AerocraftItemEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, float lerpYRot, float lerpXRot) {
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - lerpYRot));
        poseStack.m_252880_(0.0f, 0.0f, 0.0f);
        poseStack.m_85841_(0.6f, 0.6f, 0.6f);
        poseStack.m_252880_(0.0f, -1.5f, 0.0f);
        int currentFrame = this.getCurrentFrameIndex(entity, partialTicks, MAGIC_ENGINE_TEXTURES.length);
        ResourceLocation currentTexture = this.getFrameTexture(currentFrame, entity.getItemStack());
        Item item = entity.getItemStack().m_41720_();
        if (item instanceof BedItem) {
            this.droneEngineBedModel.m_6973_(entity, 0.0f, 0.0f, (float)entity.f_19797_ + partialTicks, lerpYRot, lerpXRot);
            this.droneEngineBedModel.m_7695_(poseStack, buffer.m_6299_(CustomBlendRenderType.wind(currentTexture)), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.7f);
        } else {
            this.droneEngineModel.m_6973_(entity, 0.0f, 0.0f, (float)entity.f_19797_ + partialTicks, lerpYRot, lerpXRot);
            this.droneEngineModel.m_7695_(poseStack, buffer.m_6299_(CustomBlendRenderType.wind(currentTexture)), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.7f);
        }
        poseStack.m_85849_();
    }

    private boolean isSpecialBlockItem(Item item) {
        BlockItem blockItem;
        return item instanceof BlockItem && !((blockItem = (BlockItem)item).m_40614_() instanceof BushBlock) && !(blockItem.m_40614_() instanceof SignBlock) && !(blockItem.m_40614_() instanceof LadderBlock) && !(blockItem.m_40614_() instanceof DoorBlock) && !(blockItem.m_40614_() instanceof CarpetBlock) && !(blockItem.m_40614_() instanceof SnowLayerBlock);
    }

    private float calculateAlphaSmooth(AerocraftItemEntity animatable) {
        float currentSpeed = Math.abs(animatable.getPlayerSpeed());
        float maxSpeed = animatable.getMaxSpeed();
        float speedRatio = Mth.m_14036_((float)(currentSpeed / maxSpeed), (float)0.0f, (float)0.7f);
        return speedRatio * speedRatio;
    }

    private int getCurrentFrameIndex(AerocraftItemEntity animatable, float partialTick, int totalFrames) {
        float totalTime = ((float)animatable.f_19797_ + partialTick) * 0.05f;
        float animationTime = totalTime % ((float)totalFrames * 0.05f);
        return Mth.m_14143_((float)(animationTime / 0.05f)) % totalFrames;
    }

    private ResourceLocation getFrameTexture(int frameIndex, ItemStack stack) {
        if (EngineHelper.getEngineItem(stack).m_150930_((Item)ItemsRegister.AERO_ENGINE.get())) {
            if (frameIndex >= 0 && frameIndex < AERO_ENGINE_TEXTURES.length) {
                return AERO_ENGINE_TEXTURES[frameIndex];
            }
        } else if (EngineHelper.getEngineItem(stack).m_150930_((Item)ItemsRegister.THERMAL_ENGINE.get())) {
            if (frameIndex >= 0 && frameIndex < THERMAL_ENGINE_TEXTURES.length) {
                return THERMAL_ENGINE_TEXTURES[frameIndex];
            }
        } else if (EngineHelper.getEngineItem(stack).m_150930_((Item)ItemsRegister.MAGIC_ENGINE.get())) {
            if (frameIndex >= 0 && frameIndex < MAGIC_ENGINE_TEXTURES.length) {
                return MAGIC_ENGINE_TEXTURES[frameIndex];
            }
        } else if (EngineHelper.getEngineItem(stack).m_150930_((Item)ItemsRegister.DRONE_ENGINE.get()) && frameIndex >= 0 && frameIndex < DRONE_ENGINE_TEXTURES.length) {
            return DRONE_ENGINE_TEXTURES[frameIndex];
        }
        return AERO_ENGINE_TEXTURES[0];
    }

    @NotNull
    public ResourceLocation getTextureLocation(AerocraftItemEntity entity) {
        return TextureAtlas.f_118259_;
    }
}

