/*
 * Decompiled with CFR 0.152.
 */
package com.kfhzs.allthingsflying.items;

import com.kfhzs.allthingsflying.items.ItemsRegister;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class FlightGiftPackage
extends Item {
    private static final List<Supplier<Item>> ENGINE_ITEMS = List.of(ItemsRegister.DRONE, ItemsRegister.ROCKET_PC1, ItemsRegister.MAGIC_BROOM, ItemsRegister.FLYING_SWORD);
    private static final Map<Item, Component> ENGINE_NAMES = Map.of((Item)ItemsRegister.DRONE.get(), ((Item)ItemsRegister.DRONE.get()).m_7968_().m_41611_(), (Item)ItemsRegister.ROCKET_PC1.get(), ((Item)ItemsRegister.ROCKET_PC1.get()).m_7968_().m_41611_(), (Item)ItemsRegister.MAGIC_BROOM.get(), ((Item)ItemsRegister.MAGIC_BROOM.get()).m_7968_().m_41611_(), (Item)ItemsRegister.FLYING_SWORD.get(), ((Item)ItemsRegister.FLYING_SWORD.get()).m_7968_().m_41611_());

    public FlightGiftPackage() {
        super(new Item.Properties().m_41487_(16).m_41497_(Rarity.EPIC));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_) {
            Item randomEngine = this.getRandomEngine(level.f_46441_);
            int amount = this.getRandomAmount(level.f_46441_);
            this.giveRandomFlightItems(player, randomEngine, amount);
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
            Component engineName = ENGINE_NAMES.getOrDefault(randomEngine, (Component)Component.m_237115_((String)("message.allthingsflying." + this + ".engineName.message")));
            player.m_5661_((Component)Component.m_237110_((String)("message.allthingsflying." + this + ".prompt.message"), (Object[])new Object[]{engineName, amount}), true);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
    }

    private Item getRandomEngine(RandomSource random) {
        int index = random.m_188503_(ENGINE_ITEMS.size());
        return ENGINE_ITEMS.get(index).get();
    }

    private int getRandomAmount(RandomSource random) {
        if (random.m_188501_() < 0.99f) {
            return 1;
        }
        return 1 + random.m_188503_(2);
    }

    private void giveRandomFlightItems(Player player, Item randomEngine, int engineAmount) {
        this.giveItemToPlayer(player, new ItemStack((ItemLike)randomEngine, engineAmount));
    }

    private void giveItemToPlayer(Player player, ItemStack stack) {
        if (!player.m_150109_().m_36054_(stack)) {
            player.m_36176_(stack, false);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)("tooltip.allthingsflying." + this + ".tooltip")));
    }
}

