/*
 * Decompiled with CFR 0.152.
 */
package com.kfhzs.allthingsflying.recipe;

import com.kfhzs.allthingsflying.capability.ModCapabilities;
import com.kfhzs.allthingsflying.items.Engine;
import com.kfhzs.allthingsflying.items.ItemsRegister;
import com.kfhzs.allthingsflying.recipe.EngineHelper;
import com.kfhzs.allthingsflying.recipe.ModRecipeTypes;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class AerocraftRecipe
extends CustomRecipe {
    public AerocraftRecipe(ResourceLocation resourceLocation, CraftingBookCategory craftingBookCategory) {
        super(resourceLocation, craftingBookCategory);
    }

    public boolean matches(CraftingContainer container, @NotNull Level level) {
        int itemCount = 0;
        boolean hasEngine = false;
        boolean hasOtherItem = false;
        boolean hasUpgradeCore = false;
        boolean hasAerocraftItem = false;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            ++itemCount;
            if (this.isEngine(stack)) {
                hasEngine = true;
                continue;
            }
            if (this.isUpgradeCore(stack)) {
                hasUpgradeCore = true;
                continue;
            }
            if (this.hasEngine(stack)) {
                hasAerocraftItem = true;
                continue;
            }
            hasOtherItem = true;
        }
        boolean makeAerocraft = itemCount == 2 && hasEngine && hasOtherItem && !hasAerocraftItem && !hasUpgradeCore;
        boolean upgradeEngine = itemCount == 2 && hasUpgradeCore && hasAerocraftItem && !hasEngine && !hasOtherItem;
        return makeAerocraft || upgradeEngine;
    }

    @NotNull
    public ItemStack assemble(CraftingContainer container, @NotNull RegistryAccess registryAccess) {
        if (this.isUpgradeRecipe(container)) {
            return this.assembleUpgrade(container);
        }
        return this.assembleAerocraft(container);
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.UNIVERSAL_FLYING_SERIALIZER.get();
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        NonNullList remaining = NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack item = container.m_8020_(i);
            if (item.hasCraftingRemainingItem()) {
                remaining.set(i, (Object)item.getCraftingRemainingItem());
                continue;
            }
            if (item.m_41619_()) continue;
            remaining.set(i, (Object)ItemStack.f_41583_);
        }
        return remaining;
    }

    private ItemStack assembleAerocraft(CraftingContainer container) {
        ItemStack engine = ItemStack.f_41583_;
        ItemStack material = ItemStack.f_41583_;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (this.isEngine(stack)) {
                engine = stack;
                continue;
            }
            material = stack;
        }
        if (!(engine.m_41619_() || material.m_41619_() || this.hasEngine(material))) {
            ItemStack flyingItem = new ItemStack((ItemLike)material.m_41720_(), 1);
            if (material.m_41782_() && material.m_41783_() != null) {
                flyingItem.m_41751_(material.m_41783_().m_6426_());
            }
            ItemStack finalEngine = engine;
            int initialLevel = EngineHelper.getEngineLevel(finalEngine);
            flyingItem.getCapability(ModCapabilities.ENGINE_CAPABILITY).ifPresent(engineCap -> engineCap.setEngineItem(finalEngine));
            String baseName = material.m_41786_().getString();
            String displayName = baseName + " \u00a76" + finalEngine.m_41611_().getString() + " \u00a7eLv." + initialLevel;
            flyingItem.m_41714_((Component)Component.m_237113_((String)displayName));
            return flyingItem;
        }
        return ItemStack.f_41583_;
    }

    private ItemStack assembleUpgrade(CraftingContainer container) {
        ItemStack aerocraftItem = ItemStack.f_41583_;
        ItemStack upgradeCore = ItemStack.f_41583_;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (this.hasEngine(stack)) {
                aerocraftItem = stack;
                continue;
            }
            if (!this.isUpgradeCore(stack)) continue;
            upgradeCore = stack;
        }
        if (!aerocraftItem.m_41619_() && !upgradeCore.m_41619_()) {
            ItemStack upgradedItem = aerocraftItem.m_41777_();
            ItemStack currentEngine = EngineHelper.getEngineItem(aerocraftItem);
            if (currentEngine.m_41619_()) {
                return ItemStack.f_41583_;
            }
            int currentLevel = EngineHelper.getEngineLevel(aerocraftItem);
            if (!this.isValidUpgradeCore(upgradeCore, currentLevel)) {
                return ItemStack.f_41583_;
            }
            int newLevel = currentLevel + 1;
            upgradedItem.getCapability(ModCapabilities.ENGINE_CAPABILITY).ifPresent(engineCap -> engineCap.setEngineLevel(newLevel));
            Component originalName = aerocraftItem.m_41786_();
            String nameString = originalName.getString();
            String newName = nameString.replaceAll("Lv\\.\\d+", "Lv." + newLevel);
            upgradedItem.m_41714_((Component)Component.m_237113_((String)newName));
            return upgradedItem;
        }
        return ItemStack.f_41583_;
    }

    private boolean isUpgradeRecipe(CraftingContainer container) {
        boolean hasUpgradeCore = false;
        boolean hasAerocraftItem = false;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (this.isUpgradeCore(stack)) {
                hasUpgradeCore = true;
                continue;
            }
            if (!this.hasEngine(stack)) continue;
            hasAerocraftItem = true;
        }
        return hasUpgradeCore && hasAerocraftItem;
    }

    private boolean isEngine(ItemStack stack) {
        Item item = stack.m_41720_();
        return item instanceof Engine;
    }

    private boolean isValidUpgradeCore(ItemStack upgradeCore, int currentLevel) {
        if (currentLevel >= 1 && currentLevel < 7) {
            return upgradeCore.m_150930_((Item)ItemsRegister.UPGRADE_CORE.get());
        }
        if (currentLevel >= 7) {
            return upgradeCore.m_150930_((Item)ItemsRegister.HEAVY_UPGRADE_CORE.get());
        }
        return false;
    }

    private boolean isUpgradeCore(ItemStack stack) {
        return stack.m_150930_((Item)ItemsRegister.UPGRADE_CORE.get()) || stack.m_150930_((Item)ItemsRegister.HEAVY_UPGRADE_CORE.get());
    }

    private boolean hasEngine(ItemStack stack) {
        return EngineHelper.hasEngine(stack);
    }
}

