/*
 * Decompiled with CFR 0.152.
 */
package com.kfhzs.allthingsflying.recipe;

import com.kfhzs.allthingsflying.capability.IEngineCapability;
import com.kfhzs.allthingsflying.capability.ModCapabilities;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;

public class EngineHelper {
    public static boolean hasEngine(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (stack.getCapability(ModCapabilities.ENGINE_CAPABILITY).isPresent()) {
            return stack.getCapability(ModCapabilities.ENGINE_CAPABILITY).map(IEngineCapability::hasEngine).orElse(false);
        }
        return false;
    }

    public static int getEngineDurability(ItemStack stack) {
        if (!EngineHelper.hasEngine(stack)) {
            return 2564;
        }
        return stack.getCapability(ModCapabilities.ENGINE_CAPABILITY).map(IEngineCapability::getEngineDurability).orElse(2564);
    }

    public static int getMaxEngineDurability(ItemStack stack) {
        if (!EngineHelper.hasEngine(stack)) {
            return 2564;
        }
        return stack.getCapability(ModCapabilities.ENGINE_CAPABILITY).map(IEngineCapability::getMaxEngineDurability).orElse(2564);
    }

    public static void setEngineDurability(ItemStack stack, int amount) {
        stack.getCapability(ModCapabilities.ENGINE_CAPABILITY).ifPresent(cap -> cap.setEngineDurability(amount));
    }

    public static double getPower(ItemStack stack) {
        if (!EngineHelper.hasEngine(stack)) {
            return 0.0;
        }
        return stack.getCapability(ModCapabilities.ENGINE_CAPABILITY).map(IEngineCapability::getPower).orElse(0.0);
    }

    public static float getFlightSpeed(ItemStack stack) {
        if (!EngineHelper.hasEngine(stack)) {
            return 0.1f;
        }
        return stack.getCapability(ModCapabilities.ENGINE_CAPABILITY).map(IEngineCapability::getFlightSpeed).orElse(Float.valueOf(0.1f)).floatValue();
    }

    public static float getFriction(ItemStack stack) {
        if (!EngineHelper.hasEngine(stack)) {
            return 0.1f;
        }
        return stack.getCapability(ModCapabilities.ENGINE_CAPABILITY).map(IEngineCapability::getFriction).orElse(Float.valueOf(0.1f)).floatValue();
    }

    public static float getStopThreshold(ItemStack stack) {
        if (!EngineHelper.hasEngine(stack)) {
            return 0.1f;
        }
        return stack.getCapability(ModCapabilities.ENGINE_CAPABILITY).map(IEngineCapability::getStopThreshold).orElse(Float.valueOf(0.1f)).floatValue();
    }

    public static float getAcceleration(ItemStack stack) {
        if (!EngineHelper.hasEngine(stack)) {
            return 0.1f;
        }
        return stack.getCapability(ModCapabilities.ENGINE_CAPABILITY).map(IEngineCapability::getAcceleration).orElse(Float.valueOf(0.1f)).floatValue();
    }

    public static ItemStack getEngineItem(ItemStack stack) {
        if (!EngineHelper.hasEngine(stack)) {
            return ItemStack.f_41583_;
        }
        return stack.getCapability(ModCapabilities.ENGINE_CAPABILITY).map(IEngineCapability::getEngineItem).orElse(null);
    }

    public static int getEngineLevel(ItemStack stack) {
        if (!EngineHelper.hasEngine(stack)) {
            return 1;
        }
        return stack.getCapability(ModCapabilities.ENGINE_CAPABILITY).map(IEngineCapability::getEngineLevel).orElse(1);
    }

    public static int getEngineSoundTime(ItemStack stack) {
        if (!EngineHelper.hasEngine(stack)) {
            return 0;
        }
        return stack.getCapability(ModCapabilities.ENGINE_CAPABILITY).map(IEngineCapability::getEngineSoundTime).orElse(0);
    }

    public static SoundEvent getEngineSound(ItemStack stack) {
        if (!EngineHelper.hasEngine(stack)) {
            return null;
        }
        return stack.getCapability(ModCapabilities.ENGINE_CAPABILITY).map(IEngineCapability::getEngineSound).orElse(null);
    }
}

