/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.chargedmobs.mixin;

import com.yyz.chargedmobs.ChargedHelper;
import com.yyz.chargedmobs.ChargedMobs;
import com.yyz.chargedmobs.api.ChargedEntity;
import com.yyz.chargedmobs.config.ModConfig;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements ChargedEntity {
    @Unique
    private static final EntityDataAccessor<Boolean> chargedmobs_$CHARGED = SynchedEntityData.defineId(LivingEntityMixin.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    @Unique
    LivingEntity chargedmobs_$entity = (LivingEntity)this;

    public LivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Inject(method={"defineSynchedData(Lnet/minecraft/network/syncher/SynchedEntityData$Builder;)V"}, at={@At(value="TAIL")})
    private void injectInitDataTracker(SynchedEntityData.Builder builder, CallbackInfo ci) {
        builder.define(chargedmobs_$CHARGED, (Object)false);
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private void injectWriteCustomDataToNbt(CompoundTag nbt, CallbackInfo ci) {
        if (((Boolean)this.entityData.get(chargedmobs_$CHARGED)).booleanValue()) {
            nbt.putBoolean("powered", true);
        }
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private void injectReadCustomDataToNbt(CompoundTag nbt, CallbackInfo ci) {
        this.entityData.set(chargedmobs_$CHARGED, (Object)nbt.getBooleanOr("powered", false));
    }

    @Override
    public boolean chargedMobs_1_21_4$isCharged() {
        return (Boolean)this.entityData.get(chargedmobs_$CHARGED) != false && ChargedMobs.enabledCharged(this.getType());
    }

    public void thunderHit(ServerLevel world, LightningBolt lightning) {
        ModConfig config = ChargedMobs.getConfig();
        ResourceLocation id = BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.getType());
        String key = id.toString();
        if (!(ChargedMobs.getConfig().healthAdd.containsKey(key) || ChargedMobs.getConfig().healthMul.containsKey(key) || ChargedMobs.getConfig().immunityLightning.contains(key))) {
            super.thunderHit(world, lightning);
        }
        if (this.chargedmobs_$entity.tickCount < 20) {
            return;
        }
        if (!ChargedMobs.enabledCharged(this.getType())) {
            return;
        }
        if (this.chargedMobs_1_21_4$isCharged()) {
            return;
        }
        ChargedHelper.applyAttributeModifiers(this.chargedmobs_$entity, config, key);
        this.entityData.set(chargedmobs_$CHARGED, (Object)true);
    }
}

