/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.chargedmobs.mixin;

import com.yyz.chargedmobs.ChargedHelper;
import com.yyz.chargedmobs.ChargedMobs;
import com.yyz.chargedmobs.api.ChargedEntity;
import com.yyz.chargedmobs.config.ModConfig;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements ChargedEntity {
    @Unique
    private static final EntityDataAccessor<Boolean> CHARGED = SynchedEntityData.m_135353_(LivingEntityMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Unique
    LivingEntity entity = (LivingEntity)this;

    public LivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void injectInitDataTracker(CallbackInfo ci) {
        this.f_19804_.m_135372_(CHARGED, (Object)false);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void injectWriteCustomDataToNbt(CompoundTag nbt, CallbackInfo ci) {
        if (((Boolean)this.f_19804_.m_135370_(CHARGED)).booleanValue()) {
            nbt.m_128379_("powered", true);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void injectReadCustomDataToNbt(CompoundTag nbt, CallbackInfo ci) {
        this.f_19804_.m_135381_(CHARGED, (Object)nbt.m_128471_("powered"));
    }

    @Override
    public boolean chargedMobs_1_21_4$isCharged() {
        return (Boolean)this.f_19804_.m_135370_(CHARGED) != false && ChargedMobs.enabledCharged(this.m_6095_());
    }

    public void m_8038_(ServerLevel world, LightningBolt lightning) {
        super.m_8038_(world, lightning);
        if (this.entity.f_19797_ < 20) {
            return;
        }
        if (!ChargedMobs.enabledCharged(this.m_6095_())) {
            return;
        }
        if (this.chargedMobs_1_21_4$isCharged()) {
            return;
        }
        ModConfig config = ChargedMobs.getConfig();
        ResourceLocation id = BuiltInRegistries.f_256780_.m_7981_((Object)this.m_6095_());
        String key = id.toString();
        ChargedHelper.applyAttributeModifiers(this.entity, config, key);
        this.f_19804_.m_135381_(CHARGED, (Object)true);
    }
}

