/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.chargedmobs.client.render.entity.feature;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yyz.chargedmobs.api.ChargedEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ChargedFeatureRenderer
extends RenderLayer<LivingEntity, EntityModel<LivingEntity>> {
    private final EntityModel<LivingEntity> model;
    private static final ResourceLocation SKIN = ResourceLocation.parse((String)"textures/entity/creeper/creeper_armor.png");

    public ChargedFeatureRenderer(RenderLayerParent<LivingEntity, EntityModel<LivingEntity>> context) {
        super(context);
        this.model = context.getModel();
    }

    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, LivingEntity entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        if (((ChargedEntity)entity).chargedMobs_1_21_4$isCharged()) {
            float f = (float)entity.tickCount + tickDelta;
            EntityModel<LivingEntity> entityModel = this.getEnergySwirlModel();
            entityModel.prepareMobModel((Entity)entity, limbAngle, limbDistance, tickDelta);
            this.getParentModel().copyPropertiesTo(entityModel);
            VertexConsumer vertexConsumer = vertexConsumers.getBuffer(RenderType.energySwirl((ResourceLocation)this.getEnergySwirlTexture(), (float)(this.getEnergySwirlX(f) % 1.0f), (float)(f * 0.01f % 1.0f)));
            entityModel.setupAnim((Entity)entity, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
            entityModel.renderToBuffer(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY, -8355712);
        }
    }

    protected float getEnergySwirlX(float partialAge) {
        return partialAge * 0.01f;
    }

    protected ResourceLocation getEnergySwirlTexture() {
        return SKIN;
    }

    protected EntityModel<LivingEntity> getEnergySwirlModel() {
        return this.model;
    }
}

