/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.chargedmobs.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public boolean autoGenerate = true;
    public boolean NaturallyCharged = true;
    public boolean NaturallyChargedNeedRain = true;
    public double ChargedChange = 0.05;
    public Map<String, Double> damageMul = new HashMap<String, Double>();
    public Map<String, Double> damageAdd = new HashMap<String, Double>();
    public Map<String, Double> armorMul = new HashMap<String, Double>();
    public Map<String, Double> armorAdd = new HashMap<String, Double>();
    public Map<String, Double> toughnessMul = new HashMap<String, Double>();
    public Map<String, Double> toughnessAdd = new HashMap<String, Double>();
    public Map<String, Double> knockbackMul = new HashMap<String, Double>();
    public Map<String, Double> knockbackAdd = new HashMap<String, Double>();
    public Map<String, Double> knockbackResistanceMul = new HashMap<String, Double>();
    public Map<String, Double> knockbackResistanceAdd = new HashMap<String, Double>();
    public Map<String, Double> followRangeMul = new HashMap<String, Double>();
    public Map<String, Double> followRangeAdd = new HashMap<String, Double>();
    public Map<String, Double> healthMul = new HashMap<String, Double>();
    public Map<String, Double> healthAdd = new HashMap<String, Double>();
    public Map<String, Double> moveSpeedMul = new HashMap<String, Double>();
    public Map<String, Double> moveSpeedAdd = new HashMap<String, Double>();
    public Map<String, Double> flyingSpeedMul = new HashMap<String, Double>();
    public Map<String, Double> flyingSpeedAdd = new HashMap<String, Double>();
    public Map<String, Double> spawnReinforcementsMul = new HashMap<String, Double>();
    public Map<String, Double> spawnReinforcementsAdd = new HashMap<String, Double>();
    public Map<String, Double> absorptionMul = new HashMap<String, Double>();
    public Map<String, Double> absorptionAdd = new HashMap<String, Double>();
    public Map<String, Double> fallDamageMultiplierMul = new HashMap<String, Double>();
    public Map<String, Double> fallDamageMultiplierAdd = new HashMap<String, Double>();
    public Map<String, Double> scaleMul = new HashMap<String, Double>();
    public Map<String, Double> scaleAdd = new HashMap<String, Double>();
    public Map<String, Double> jumpStrengthMul = new HashMap<String, Double>();
    public Map<String, Double> jumpStrengthAdd = new HashMap<String, Double>();
    public Map<String, Double> safeFallDistanceMul = new HashMap<String, Double>();
    public Map<String, Double> safeFallDistanceAdd = new HashMap<String, Double>();
    public Map<String, Double> stepHeightMul = new HashMap<String, Double>();
    public Map<String, Double> stepHeightAdd = new HashMap<String, Double>();
    public Map<String, Double> explosionKnockbackResistanceMul = new HashMap<String, Double>();
    public Map<String, Double> explosionKnockbackResistanceAdd = new HashMap<String, Double>();
    public Map<String, Double> burningTimeMul = new HashMap<String, Double>();
    public Map<String, Double> burningTimeAdd = new HashMap<String, Double>();
    public Map<String, Double> movementEfficiencyMul = new HashMap<String, Double>();
    public Map<String, Double> movementEfficiencyAdd = new HashMap<String, Double>();
    public Map<String, Double> oxygenBonusMul = new HashMap<String, Double>();
    public Map<String, Double> oxygenBonusAdd = new HashMap<String, Double>();
    public Map<String, Double> waterMovementEfficiencyMul = new HashMap<String, Double>();
    public Map<String, Double> waterMovementEfficiencyAdd = new HashMap<String, Double>();
    public Set<String> immunityLightning = Set.of("minecraft:slime", "minecraft:spider");
    public Set<String> randomAttribute = Set.of("armorAdd", "healthAdd", "healthMul", "followRangeAdd", "followRangeMul", "knockbackResistanceAdd");
    public Set<String> banMobs = Set.of("minecraft:wither_skeleton", "minecraft:creeper", "minecraft:guardian", "minecraft:elder_guardian", "minecraft:warden", "minecraft:silverfish", "minecraft:breeze", "minecraft:phantom", "minecraft:vex", "minecraft:hoglin", "minecraft:zoglin", "minecraft:piglin_brute", "minecraft:ghast", "minecraft:blaze", "minecraft:magma_cube", "minecraft:endermite", "minecraft:shulker", "minecraft:creaking");

    public ModConfig() {
        this.armorAdd.put("minecraft:zombie", 4.0);
        this.armorAdd.put("minecraft:drowned", 4.0);
        this.armorAdd.put("minecraft:husk", 4.0);
        this.armorAdd.put("minecraft:zombie_villager", 4.0);
        this.moveSpeedAdd.put("minecraft:skeleton", 0.1);
        this.moveSpeedAdd.put("minecraft:stray", 0.1);
        this.moveSpeedAdd.put("minecraft:bogged", 0.1);
        this.healthAdd.put("minecraft:slime", 6.0);
        this.healthAdd.put("minecraft:spider", 6.0);
        this.damageAdd.put("minecraft:enderman", 4.0);
        this.followRangeAdd.put("minecraft:pillager", 12.0);
        this.followRangeAdd.put("minecraft:evoker", 12.0);
        this.followRangeAdd.put("minecraft:vindicator", 12.0);
        this.knockbackAdd.put("minecraft:ravager", 1.5);
        this.knockbackResistanceAdd.put("minecraft:witch", 0.5);
    }

    public static ModConfig loadConfig(File file) {
        ModConfig config;
        block19: {
            if (file.exists() && file.isFile()) {
                try (FileInputStream fileInputStream = new FileInputStream(file);
                     InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
                     BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                    config = (ModConfig)GSON.fromJson((Reader)bufferedReader, ModConfig.class);
                    break block19;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to load config", e);
                }
            }
            config = new ModConfig();
        }
        if (config.autoGenerate) {
            config.syncWithRegisteredEntities();
        }
        config.saveConfig(file);
        return config;
    }

    public void saveConfig(File config) {
        try (FileOutputStream stream = new FileOutputStream(config);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load config", e);
        }
    }

    public void syncWithRegisteredEntities() {
        DefaultedRegistry registry = BuiltInRegistries.ENTITY_TYPE;
        HashMap<String, MapConfigEntry> attributeConfigs = new HashMap<String, MapConfigEntry>();
        attributeConfigs.put("damageMul", new MapConfigEntry(this.damageMul, 0.5));
        attributeConfigs.put("damageAdd", new MapConfigEntry(this.damageAdd, 4.0));
        attributeConfigs.put("armorMul", new MapConfigEntry(this.armorMul, 0.5));
        attributeConfigs.put("armorAdd", new MapConfigEntry(this.armorAdd, 4.0));
        attributeConfigs.put("toughnessMul", new MapConfigEntry(this.toughnessMul, 0.5));
        attributeConfigs.put("toughnessAdd", new MapConfigEntry(this.toughnessAdd, 5.0));
        attributeConfigs.put("knockbackMul", new MapConfigEntry(this.knockbackMul, 0.5));
        attributeConfigs.put("knockbackAdd", new MapConfigEntry(this.knockbackAdd, 1.5));
        attributeConfigs.put("knockbackResistanceMul", new MapConfigEntry(this.knockbackResistanceMul, 0.5));
        attributeConfigs.put("knockbackResistanceAdd", new MapConfigEntry(this.knockbackResistanceAdd, 0.3));
        attributeConfigs.put("followRangeMul", new MapConfigEntry(this.followRangeMul, 0.5));
        attributeConfigs.put("followRangeAdd", new MapConfigEntry(this.followRangeAdd, 16.0));
        attributeConfigs.put("healthMul", new MapConfigEntry(this.healthMul, 0.5));
        attributeConfigs.put("healthAdd", new MapConfigEntry(this.healthAdd, 7.0));
        attributeConfigs.put("moveSpeedMul", new MapConfigEntry(this.moveSpeedMul, 0.3));
        attributeConfigs.put("moveSpeedAdd", new MapConfigEntry(this.moveSpeedAdd, 0.1));
        attributeConfigs.put("flyingSpeedMul", new MapConfigEntry(this.flyingSpeedMul, 0.5));
        attributeConfigs.put("flyingSpeedAdd", new MapConfigEntry(this.flyingSpeedAdd, 0.1));
        attributeConfigs.put("spawnReinforcementsMul", new MapConfigEntry(this.spawnReinforcementsMul, 0.5));
        attributeConfigs.put("spawnReinforcementsAdd", new MapConfigEntry(this.spawnReinforcementsAdd, 0.1));
        attributeConfigs.put("absorptionMul", new MapConfigEntry(this.absorptionMul, 0.5));
        attributeConfigs.put("absorptionAdd", new MapConfigEntry(this.absorptionAdd, 2.0));
        attributeConfigs.put("fallDamageMultiplierMul", new MapConfigEntry(this.fallDamageMultiplierMul, 0.5));
        attributeConfigs.put("fallDamageMultiplierAdd", new MapConfigEntry(this.fallDamageMultiplierAdd, 0.1));
        attributeConfigs.put("scaleMul", new MapConfigEntry(this.scaleMul, 0.5));
        attributeConfigs.put("scaleAdd", new MapConfigEntry(this.scaleAdd, 0.2));
        attributeConfigs.put("jumpStrengthMul", new MapConfigEntry(this.jumpStrengthMul, 0.5));
        attributeConfigs.put("jumpStrengthAdd", new MapConfigEntry(this.jumpStrengthAdd, 0.2));
        attributeConfigs.put("safeFallDistanceMul", new MapConfigEntry(this.safeFallDistanceMul, 0.5));
        attributeConfigs.put("safeFallDistanceAdd", new MapConfigEntry(this.safeFallDistanceAdd, 2.0));
        attributeConfigs.put("stepHeightMul", new MapConfigEntry(this.stepHeightMul, 0.5));
        attributeConfigs.put("stepHeightAdd", new MapConfigEntry(this.stepHeightAdd, 1.0));
        attributeConfigs.put("explosionKnockbackResistanceMul", new MapConfigEntry(this.explosionKnockbackResistanceMul, 0.5));
        attributeConfigs.put("explosionKnockbackResistanceAdd", new MapConfigEntry(this.explosionKnockbackResistanceAdd, 0.3));
        attributeConfigs.put("burningTimeMul", new MapConfigEntry(this.burningTimeMul, 0.5));
        attributeConfigs.put("burningTimeAdd", new MapConfigEntry(this.burningTimeAdd, 10.0));
        attributeConfigs.put("movementEfficiencyMul", new MapConfigEntry(this.movementEfficiencyMul, 0.5));
        attributeConfigs.put("movementEfficiencyAdd", new MapConfigEntry(this.movementEfficiencyAdd, 0.1));
        attributeConfigs.put("oxygenBonusMul", new MapConfigEntry(this.oxygenBonusMul, 0.5));
        attributeConfigs.put("oxygenBonusAdd", new MapConfigEntry(this.oxygenBonusAdd, 10.0));
        attributeConfigs.put("waterMovementEfficiencyMul", new MapConfigEntry(this.waterMovementEfficiencyMul, 0.5));
        attributeConfigs.put("waterMovementEfficiencyAdd", new MapConfigEntry(this.waterMovementEfficiencyAdd, 0.3));
        ArrayList<MapConfigEntry> dynamicRandomList = new ArrayList<MapConfigEntry>();
        for (String attr : this.randomAttribute) {
            MapConfigEntry entry = (MapConfigEntry)attributeConfigs.get(attr);
            if (entry == null) continue;
            dynamicRandomList.add(entry);
        }
        if (dynamicRandomList.isEmpty()) {
            return;
        }
        List<MapConfigEntry> allEntries = Arrays.asList(new MapConfigEntry(this.damageMul, 0.0), new MapConfigEntry(this.damageAdd, 0.0), new MapConfigEntry(this.armorMul, 0.0), new MapConfigEntry(this.armorAdd, 0.0), new MapConfigEntry(this.toughnessMul, 0.0), new MapConfigEntry(this.toughnessAdd, 0.0), new MapConfigEntry(this.knockbackMul, 0.0), new MapConfigEntry(this.knockbackAdd, 0.0), new MapConfigEntry(this.knockbackResistanceMul, 0.0), new MapConfigEntry(this.knockbackResistanceAdd, 0.0), new MapConfigEntry(this.followRangeMul, 0.0), new MapConfigEntry(this.followRangeAdd, 0.0), new MapConfigEntry(this.healthMul, 0.0), new MapConfigEntry(this.healthAdd, 0.0), new MapConfigEntry(this.moveSpeedMul, 0.0), new MapConfigEntry(this.moveSpeedAdd, 0.0), new MapConfigEntry(this.flyingSpeedMul, 0.0), new MapConfigEntry(this.flyingSpeedAdd, 0.0), new MapConfigEntry(this.spawnReinforcementsMul, 0.0), new MapConfigEntry(this.spawnReinforcementsAdd, 0.0), new MapConfigEntry(this.absorptionMul, 0.0), new MapConfigEntry(this.absorptionAdd, 0.0), new MapConfigEntry(this.fallDamageMultiplierMul, 0.0), new MapConfigEntry(this.fallDamageMultiplierAdd, 0.0), new MapConfigEntry(this.scaleMul, 0.0), new MapConfigEntry(this.scaleAdd, 0.0), new MapConfigEntry(this.jumpStrengthMul, 0.0), new MapConfigEntry(this.jumpStrengthAdd, 0.0), new MapConfigEntry(this.safeFallDistanceMul, 0.0), new MapConfigEntry(this.safeFallDistanceAdd, 0.0), new MapConfigEntry(this.stepHeightMul, 0.0), new MapConfigEntry(this.stepHeightAdd, 0.0), new MapConfigEntry(this.explosionKnockbackResistanceMul, 0.0), new MapConfigEntry(this.explosionKnockbackResistanceAdd, 0.0), new MapConfigEntry(this.burningTimeMul, 0.0), new MapConfigEntry(this.burningTimeAdd, 0.0), new MapConfigEntry(this.movementEfficiencyMul, 0.0), new MapConfigEntry(this.movementEfficiencyAdd, 0.0), new MapConfigEntry(this.oxygenBonusMul, 0.0), new MapConfigEntry(this.oxygenBonusAdd, 0.0), new MapConfigEntry(this.waterMovementEfficiencyMul, 0.0), new MapConfigEntry(this.waterMovementEfficiencyAdd, 0.0));
        Random random = new Random();
        registry.stream().filter(arg_0 -> this.lambda$syncWithRegisteredEntities$0((Registry)registry, arg_0)).forEach(arg_0 -> ModConfig.lambda$syncWithRegisteredEntities$2((Registry)registry, allEntries, dynamicRandomList, random, arg_0));
    }

    private static /* synthetic */ void lambda$syncWithRegisteredEntities$2(Registry registry, List allEntries, List dynamicRandomList, Random random, EntityType entityType) {
        ResourceLocation id = registry.getKey((Object)entityType);
        String key = id.toString();
        boolean existsInAny = allEntries.stream().anyMatch(entry -> entry.map.containsKey(key));
        if (!existsInAny) {
            MapConfigEntry selected = (MapConfigEntry)dynamicRandomList.get(random.nextInt(dynamicRandomList.size()));
            selected.map.put(key, selected.defaultValue);
        }
    }

    private /* synthetic */ boolean lambda$syncWithRegisteredEntities$0(Registry registry, EntityType entityType) {
        return !entityType.getCategory().isFriendly() && !this.banMobs.contains(registry.getKey((Object)entityType).toString());
    }

    private record MapConfigEntry(Map<String, Double> map, double defaultValue) {
    }
}

