/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.chargedmobs.mixin;

import com.yyz.chargedmobs.ChargedHelper;
import com.yyz.chargedmobs.ChargedMobs;
import com.yyz.chargedmobs.config.ModConfig;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerLevel.class})
public class ServerWordMixin {
    @Inject(method={"addFreshEntity(Lnet/minecraft/world/entity/Entity;)Z"}, at={@At(value="TAIL")})
    private void injectInitDataTracker(Entity entity, CallbackInfoReturnable<Boolean> cir) {
        if (entity instanceof LivingEntity) {
            LivingEntity entity1 = (LivingEntity)entity;
            if (!ChargedMobs.getConfig().NaturallyCharged) {
                return;
            }
            if (ChargedMobs.getConfig().NaturallyChargedNeedRain && !entity1.level().isRaining()) {
                return;
            }
            boolean powered = entity1.getRandom().nextDouble() < ChargedMobs.getConfig().ChargedChange;
            CompoundTag nbt = entity1.saveWithoutId(new CompoundTag());
            nbt.putBoolean("powered", powered);
            entity1.load(nbt);
            ModConfig config = ChargedMobs.getConfig();
            ResourceLocation id = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity1.getType());
            String key = id.toString();
            if (powered) {
                ChargedHelper.applyAttributeModifiers(entity1, config, key);
            }
        }
    }
}

