/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.chargedmobs.client.render.entity.feature;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yyz.chargedmobs.api.ChargedEntityRenderState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ChargedFeatureRenderer
extends RenderLayer<LivingEntityRenderState, EntityModel<LivingEntityRenderState>> {
    private final EntityModel<LivingEntityRenderState> model;
    private static final ResourceLocation SKIN = ResourceLocation.parse((String)"textures/entity/creeper/creeper_armor.png");

    public ChargedFeatureRenderer(RenderLayerParent<LivingEntityRenderState, EntityModel<LivingEntityRenderState>> context) {
        super(context);
        this.model = context.getModel();
    }

    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, LivingEntityRenderState state, float limbAngle, float limbDistance) {
        if (this.shouldRender(state)) {
            float f = state.ageInTicks;
            EntityModel<LivingEntityRenderState> entityModel = this.getEnergySwirlModel();
            VertexConsumer vertexConsumer = vertexConsumers.getBuffer(RenderType.energySwirl((ResourceLocation)this.getEnergySwirlTexture(), (float)(this.getEnergySwirlX(f) % 1.0f), (float)(f * 0.01f % 1.0f)));
            entityModel.setupAnim((EntityRenderState)state);
            entityModel.renderToBuffer(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY, -8355712);
        }
    }

    protected boolean shouldRender(LivingEntityRenderState state) {
        return ((ChargedEntityRenderState)state).chargedMobs_1_21_4$getCharged();
    }

    protected float getEnergySwirlX(float partialAge) {
        return partialAge * 0.01f;
    }

    protected ResourceLocation getEnergySwirlTexture() {
        return SKIN;
    }

    protected EntityModel<LivingEntityRenderState> getEnergySwirlModel() {
        return this.model;
    }
}

