/*
 * Decompiled with CFR 0.152.
 */
package no.vestlandetmc.shadowtrace.client;

import lombok.Generated;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_2338;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import no.vestlandetmc.shadowtrace.client.gui.SummaryScreen;
import no.vestlandetmc.shadowtrace.client.handlers.Block;
import no.vestlandetmc.shadowtrace.client.handlers.BlockColorManager;
import no.vestlandetmc.shadowtrace.client.handlers.DataManager;
import no.vestlandetmc.shadowtrace.client.network.ReceiveBlockData;
import no.vestlandetmc.shadowtrace.client.renders.DrawBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class ShadowtraceClient
implements ClientModInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"shadowtrace");
    private class_304 keyBinding;
    private class_638 lastWorld = null;

    public void onInitializeClient() {
        BlockColorManager.load();
        WorldRenderEvents.LAST.register(context -> {
            class_4587 matrixStack = context.matrixStack();
            class_310 client = class_310.method_1551();
            DrawBox.initialize(matrixStack, client);
        });
        PayloadTypeRegistry.playS2C().register(ReceiveBlockData.ID, ReceiveBlockData.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(ReceiveBlockData.ID, (payload, context) -> context.client().execute(() -> {
            DataManager.clearBlocks();
            for (String data : payload.data()) {
                Block block;
                String[] blockData = data.split(":");
                String world = this.getDisplayWorldName(blockData[0]);
                int locX = Integer.parseInt(blockData[1]);
                int locY = Integer.parseInt(blockData[2]);
                int locZ = Integer.parseInt(blockData[3]);
                String name = blockData[4];
                long timestamp = Long.parseLong(blockData[5]);
                int color = BlockColorManager.getColor(name);
                class_2338 blockPos = new class_2338(locX, locY, locZ);
                if (DataManager.hasBlock(name)) {
                    block = DataManager.getBlock(name);
                    block.addBlockPos(blockPos, timestamp);
                    continue;
                }
                block = new Block(world, name, color);
                block.addBlockPos(blockPos, timestamp);
                DataManager.addBlock(name, block);
            }
        }));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client != null && client.field_1687 != null && this.lastWorld != client.field_1687) {
                DataManager.clearBlocks();
                this.lastWorld = client.field_1687;
            }
        });
        this.keyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("shadowtrace.keybind", class_3675.class_307.field_1668, 71, "ShadowTrace"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (this.keyBinding.method_1436()) {
                class_310.method_1551().method_1507((class_437)new SummaryScreen());
            }
        });
    }

    private String getDisplayWorldName(String id) {
        return switch (id) {
            case "world_nether" -> "Nether";
            case "world_the_end" -> "The End";
            case "world" -> "Overworld";
            default -> id;
        };
    }

    @Generated
    public static Logger getLOGGER() {
        return LOGGER;
    }
}

