/*
 * Decompiled with CFR 0.152.
 */
package no.vestlandetmc.shadowtrace.client.gui;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import no.vestlandetmc.shadowtrace.client.handlers.Block;
import no.vestlandetmc.shadowtrace.client.handlers.DataManager;

@Environment(value=EnvType.CLIENT)
public class BlockScreen
extends class_437 {
    private static final int ROW_HEIGHT = 20;
    private final String blockName;
    private final class_437 parent;
    private final HashMap<class_2338, class_4185> buttonWidgets = new HashMap();
    private LinkedHashMap<class_2338, Long> sortedList;
    private int scrollOffset = 0;

    public BlockScreen(String blockName, class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"shadowtrace.screen.blockdata.title"));
        this.blockName = blockName;
        this.parent = parent;
    }

    public void method_25426() {
        super.method_25426();
        Block block = DataManager.getBlock(this.blockName);
        if (block == null) {
            return;
        }
        this.sortedList = block.getBlockPositions().entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).collect(LinkedHashMap::new, (map, entry) -> map.put((class_2338)entry.getKey(), (Long)entry.getValue()), HashMap::putAll);
        this.buttonWidgets.clear();
        for (class_2338 blockPos : block.getBlockPositions().keySet()) {
            if (blockPos == null || blockPos.equals((Object)class_2338.field_10980)) continue;
            class_4185 buttonWidget = class_4185.method_46430((class_2561)class_2561.method_43471((String)"shadowtrace.screen.blockdata.teleport"), btn -> this.teleport(blockPos)).method_46434(-100, -100, 60, 18).method_46431();
            this.buttonWidgets.put(blockPos, buttonWidget);
            this.method_37063((class_364)buttonWidget);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int centerX = this.field_22789 / 2;
        int tableWidth = 580;
        int startX = centerX - 290;
        int startY = 20;
        int colorWhite = -1;
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"shadowtrace.screen.blockdata.time"), startX, 20, -1, true);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"shadowtrace.screen.blockdata.coordinate"), startX + 130, 20, -1, true);
        int yOffset = 20;
        Objects.requireNonNull(this.field_22793);
        int textHeight = 9;
        int verticalPadding = (yOffset - textHeight) / 2;
        int i = 0;
        Block block = DataManager.getBlock(this.blockName);
        if (block == null) {
            return;
        }
        for (Map.Entry<class_2338, Long> entry : this.sortedList.entrySet()) {
            int y = 20 + (i + 1) * yOffset + this.scrollOffset;
            class_2338 blockPos = entry.getKey();
            if (y > 20 && y < this.field_22790 - 20) {
                boolean isHovered;
                class_5250 coordinate = class_2561.method_43469((String)"shadowtrace.screen.blockdata.world", (Object[])new Object[]{block.getWorld(), blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()});
                String time = this.convertTimestamp(entry.getValue());
                boolean bl = isHovered = mouseX >= startX - 2 && mouseX <= startX + 580 && mouseY >= y - verticalPadding && mouseY <= y + yOffset - verticalPadding;
                int rowColor = isHovered ? -2139983247 : (i % 2 == 0 ? -2143009724 : -2141891243);
                context.method_25294(startX - 2, y - verticalPadding, startX + 580, y + yOffset - verticalPadding, rowColor);
                context.method_25303(this.field_22793, time, startX, y, -1);
                context.method_27535(this.field_22793, (class_2561)coordinate, startX + 130, y, -1);
                class_4185 buttonWidget = this.buttonWidgets.get(blockPos);
                if (buttonWidget != null) {
                    buttonWidget.method_48229(startX + 580 - 62, y - 4);
                }
            } else {
                class_4185 buttonWidget = this.buttonWidgets.get(blockPos);
                if (buttonWidget != null) {
                    buttonWidget.method_48229(-100, -100);
                }
            }
            ++i;
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int scrollValue = (int)(verticalAmount * 20.0);
        int maxScroll = Math.max(0, (this.sortedList.size() + 1) * 20 - (this.field_22790 - 40));
        if (this.scrollOffset + scrollValue <= 0 && Math.abs(this.scrollOffset + scrollValue) <= maxScroll) {
            this.scrollOffset += scrollValue;
        }
        return true;
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public String convertTimestamp(long timestamp) {
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime dateTime = Instant.ofEpochSecond(timestamp).atZone(zoneId);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss");
        return dateTime.format(formatter);
    }

    public void teleport(class_2338 blockPos) {
        class_310 client = class_310.method_1551();
        if (client != null && client.field_1724 != null) {
            String teleportCommand = "shadowtrace teleport " + blockPos.method_10263() + " " + blockPos.method_10264() + " " + blockPos.method_10260();
            client.field_1724.field_3944.method_45730(teleportCommand);
        }
    }
}

