/*
 * Decompiled with CFR 0.152.
 */
package no.vestlandetmc.shadowtrace.client.handlers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class BlockColorManager {
    private static final File configFile = new File("config/shadowtrace/block_colors.json");
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<String, Integer> blockColors = new HashMap<String, Integer>();
    private static final int DEFAULT_COLOR = -65281;
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockColorManager.class);

    public static void load() {
        if (!configFile.exists()) {
            BlockColorManager.createDefaultConfig();
        }
        try (FileReader reader = new FileReader(configFile);){
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            Map raw = (Map)gson.fromJson((Reader)reader, type);
            blockColors.clear();
            for (Map.Entry entry : raw.entrySet()) {
                String name = ((String)entry.getKey()).toLowerCase();
                String hex = ((String)entry.getValue()).replace("#", "");
                try {
                    int color = (int)Long.parseLong(hex, 16) | 0xFF000000;
                    blockColors.put(name, color);
                }
                catch (NumberFormatException e) {
                    System.err.println("Invalid color for " + name + ": " + hex);
                }
            }
            LOGGER.info("Loaded {} block colors", (Object)blockColors.size());
        }
        catch (Exception e) {
            LOGGER.error("Failed to load block_colors.json: {}", (Object)e.getMessage());
        }
    }

    private static void createDefaultConfig() {
        try {
            File folder = configFile.getParentFile();
            if (!folder.exists()) {
                folder.mkdirs();
            }
            HashMap<String, String> defaults = new HashMap<String, String>();
            defaults.put("coal_ore", "#000000");
            defaults.put("copper_ore", "#bc633d");
            defaults.put("diamond_ore", "#00f2ff");
            defaults.put("gold_ore", "#ffaa00");
            defaults.put("lapis_ore", "#002bff");
            defaults.put("emerald_ore", "#00cd12");
            defaults.put("iron_ore", "#e9c0a4");
            defaults.put("redstone_ore", "#ff0000");
            defaults.put("deepslate_coal_ore", "#000000");
            defaults.put("deepslate_copper_ore", "#bc633d");
            defaults.put("deepslate_diamond_ore", "#00f2ff");
            defaults.put("deepslate_gold_ore", "#ffaa00");
            defaults.put("deepslate_lapis_ore", "#002bff");
            defaults.put("deepslate_emerald_ore", "#00cd12");
            defaults.put("deepslate_iron_ore", "#e9c0a4");
            defaults.put("deepslate_redstone_ore", "#ff0000");
            defaults.put("ancient_debris", "#851b00");
            defaults.put("nether_gold_ore", "#ffaa00");
            defaults.put("spawner", "#9900ff");
            String json = gson.toJson(defaults);
            Files.writeString(configFile.toPath(), (CharSequence)json, new OpenOption[0]);
            LOGGER.info("Created default block_colors.json");
        }
        catch (IOException e) {
            LOGGER.error("Failed to create block_colors.json: {}", (Object)e.getMessage());
        }
    }

    public static int getColor(String blockName) {
        if (blockName == null) {
            return -65281;
        }
        return blockColors.getOrDefault(blockName.toLowerCase(), -65281);
    }
}

