#version 130

uniform sampler2D DiffuseSampler;
uniform sampler2D ParticlesDepthSampler;
uniform sampler2D TranslucentSampler;

in vec2 texCoord;
in vec2 oneTexel;
uniform mat4 ProjMat;
uniform vec2 InSize;
uniform vec2 OutSize;
uniform vec2 ScreenSize;
out vec4 fragColor;

uniform sampler2D BrightnessLimitMask;
float brightnessLimit = 0.6;

bool isSky(float depth) {
    return depth > 0.9999;
}

void main(){
    vec2 uv1 = texCoord.xy / InSize.xy;
    float valor = 1.0 - length(uv1);

    float linewidth =  valor/600.;
    vec2 uv = texCoord;
    vec2 uv_b = vec2(uv.x, uv.y + linewidth);
    vec2 uv_l = vec2(uv.x + linewidth, uv.y);
    vec2 uv_r = vec2(uv.x - linewidth, uv.y);
    vec2 uv_u = vec2(uv.x, uv.y - linewidth);

    vec4 center = texture(DiffuseSampler, texCoord.st);

    float near = 0.04;
    float far = 9;

    float d1 = texture(ParticlesDepthSampler, uv).x;
    float d2 = texture(ParticlesDepthSampler, uv_b).x;
    float d3 = texture(ParticlesDepthSampler, uv_u).x;
    float d4 = texture(ParticlesDepthSampler, uv_l).x;
    float d5 = texture(ParticlesDepthSampler, uv_r).x;

    if(isSky(d1) || isSky(d2) || isSky(d3) || isSky(d4) || isSky(d5)) {
        fragColor = center;
        return;
    }

    float linearD1 = 1-2.0 * near * far / (far + near - (2.0 * d1 - 1.0) * (far - near)) / far;
    float linearD2 = 1-2.0 * near * far / (far + near - (2.0 * d2 - 1.0) * (far - near)) / far;
    float linearD3 = 1-2.0 * near * far / (far + near - (2.0 * d3 - 1.0) * (far - near)) / far;
    float linearD4 = 1-2.0 * near * far / (far + near - (2.0 * d4 - 1.0) * (far - near)) / far;
    float linearD5 = 1-2.0 * near * far / (far + near - (2.0 * d5 - 1.0) * (far - near)) / far;

    vec4 translucentSample = texture(TranslucentSampler, uv);
    float translucent = (translucentSample.r + translucentSample.g + translucentSample.b)/3;
    translucent = translucent*10*0.5;

    float factor = 1;

    float difference = (linearD1 - linearD2-translucent)*factor;
    float difference1 = (linearD1 - linearD3-translucent)*factor;
    float difference2 = (linearD1 - linearD4-translucent)*factor;
    float difference3 = (linearD1 - linearD5-translucent)*factor;

    float alldif = (difference + difference1 + difference2 + difference3);

    vec4 limitMask = texture(BrightnessLimitMask, texCoord);
    float attenuation = 1.0 - min(limitMask.r, brightnessLimit);
        
    fragColor = vec4(center.rgb + center.rgb*clamp(alldif*20., 0., 1.)*linearD1, center.a);
}