#version 130

uniform sampler2D DiffuseSampler;
uniform sampler2D ParticlesDepthSampler;
uniform sampler2D TranslucentSampler;

in vec2 texCoord;
in vec2 oneTexel;
uniform mat4 ProjMat;
uniform vec2 InSize;
uniform vec2 OutSize;
uniform vec2 ScreenSize;
out vec4 fragColor;

uniform sampler2D BrightnessLimitMask;
float brightnessLimit = 0.6;

bool isSky(float depth) {
    return depth > 0.9999;
}

float toLinearDepth(float depth) {
    float near = 0.04;
    float far = 9.0;
    return 1-2.0 * near * far / (far + near - (2.0 * depth - 1.0) * (far - near)) / far;
}

float getLuminance(vec3 color) {
    return dot(color, vec3(0.299, 0.587, 0.114));
}

void main(){
    vec2 uv1 = texCoord.xy / InSize.xy;
    float valor = 1.0 - length(uv1);

    float linewidth =  valor/600.;
    vec2 uv = texCoord;
    vec2 uv_b = vec2(uv.x, uv.y + linewidth);
    vec2 uv_l = vec2(uv.x + linewidth, uv.y);
    vec2 uv_r = vec2(uv.x - linewidth, uv.y);
    vec2 uv_u = vec2(uv.x, uv.y - linewidth);

    vec4 center = texture(DiffuseSampler, texCoord.st);

    float d1 = texture(ParticlesDepthSampler, uv).x;
    float d2 = texture(ParticlesDepthSampler, uv_b).x;
    float d3 = texture(ParticlesDepthSampler, uv_u).x;
    float d4 = texture(ParticlesDepthSampler, uv_l).x;
    float d5 = texture(ParticlesDepthSampler, uv_r).x;

    if(isSky(d1) || isSky(d2) || isSky(d3) || isSky(d4) || isSky(d5)) {
        fragColor = center;
        return;
    }

    float linearD1 = toLinearDepth(d1);
    float linearD2 = toLinearDepth(d2);
    float linearD3 = toLinearDepth(d3);
    float linearD4 = toLinearDepth(d4);
    float linearD5 = toLinearDepth(d5);

    vec4 translucentSample = texture(TranslucentSampler, uv);
    float translucent = (translucentSample.r + translucentSample.g + translucentSample.b)/3;
    translucent = translucent*10*0.5;

    float factor = 1;

    float difference = (linearD1 - linearD2-translucent)*factor;
    float difference1 = (linearD1 - linearD3-translucent)*factor;
    float difference2 = (linearD1 - linearD4-translucent)*factor;
    float difference3 = (linearD1 - linearD5-translucent)*factor;

    float alldif = (difference + difference1 + difference2 + difference3);

    float fogStart = 0.99;
    float fogEnd = 0.99;
  
    float fogFactor = smoothstep(fogStart, fogEnd, linearD1);
    
    float outlineStrength = 1.0 - fogFactor;

    vec4 limitMask = texture(BrightnessLimitMask, texCoord);
    float attenuation = 1.0 - min(limitMask.r, brightnessLimit);
    
    float centerBrightness = getLuminance(center.rgb);
    
    float darknessMultiplier = 0.3 + (1.0 - centerBrightness) * 0.4;
    vec3 outlineColor = center.rgb * darknessMultiplier;
    
    float outlineIntensity = clamp(alldif * 20. * outlineStrength, 0., 1.) * linearD1;
    
    if (centerBrightness < 0.2) {
        outlineIntensity *= centerBrightness * 3.0;
    }
    
    fragColor = vec4(center.rgb + outlineColor * outlineIntensity, center.a);
}