#version 150

in vec4 vertexColor;

uniform vec4 ColorModulator;

out vec4 fragColor;

vec3 decreaseSaturation(vec3 color, float factor) {
    float gray = dot(color, vec3(0.299, 0.587, 0.114)); 
    return mix(vec3(gray), color, 1.0 - factor);
}

void main() {
    vec4 color = vertexColor;

    if (color.a == 0.0) {
        discard;
    }

    color.rgb *= 5.5;

    color.rgb = decreaseSaturation(color.rgb, 0.2);

    fragColor = color * ColorModulator;
}

