/*
 * Decompiled with CFR 0.152.
 */
package net.qiuflms.enchantingsystemrework.loot_table.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.minecraft.class_106;
import net.minecraft.class_109;
import net.minecraft.class_117;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_219;
import net.minecraft.class_39;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.qiuflms.enchantingsystemrework.item.ModItems;
import net.qiuflms.enchantingsystemrework.loot_function.custom.ItemEnchant;
import net.qiuflms.enchantingsystemrework.loot_function.custom.MendingEnchantment;
import net.qiuflms.enchantingsystemrework.loot_function.custom.SimpleScrollEnchant;
import net.qiuflms.enchantingsystemrework.mixin.EnchantRandomlyAccessor;
import net.qiuflms.enchantingsystemrework.mixin.ItemEntryAccessor;
import net.qiuflms.enchantingsystemrework.mixin.LeafEntryAccessor;
import net.qiuflms.enchantingsystemrework.mixin.LootPoolAccessor;
import net.qiuflms.enchantingsystemrework.mixin.LootTableAccessor;

public class LootTableHelper {
    private static final List<class_5321<class_1887>> STRUCTURE_ENCHANTS = List.of(class_1893.field_23071, class_1893.field_38223, class_1893.field_50159);

    public static void registerLootTable() {
        LootTableEvents.REPLACE.register((key, original, source, registries) -> {
            if (key.equals(class_39.field_50196)) {
                return original;
            }
            List<class_55> originalPools = ((LootTableAccessor)original).getPools();
            for (class_55 pool : originalPools) {
                for (int i = 0; i < pool.field_953.toArray().length; ++i) {
                    ArrayList<class_79> entriesList;
                    if (!(pool.field_953.get(i) instanceof class_77)) continue;
                    class_1792 item = (class_1792)((ItemEntryAccessor)pool.field_953.get(i)).getItem().comp_349();
                    if (!LootTableHelper.isEnchantable(((LeafEntryAccessor)pool.field_953.get(i)).getFunctions())) continue;
                    if (item == class_1802.field_8529) {
                        entriesList = new ArrayList<class_79>(pool.field_953);
                        if (((LeafEntryAccessor)pool.field_953.get(i)).getWeight() < 5) {
                            entriesList.remove(i);
                        } else {
                            class_79 newBookEntry = LootTableHelper.createBookEntry(pool, i);
                            entriesList.set(i, newBookEntry);
                        }
                        class_79 newScrollEntry = LootTableHelper.createScrollEntry(pool, i);
                        entriesList.add(newScrollEntry);
                        ((LootPoolAccessor)pool).setEntries(entriesList);
                        continue;
                    }
                    if (!item.method_7854().method_7923()) continue;
                    entriesList = new ArrayList(pool.field_953);
                    class_79 newItem = LootTableHelper.createEnchantableItemEntry(pool, i, item);
                    entriesList.set(i, newItem);
                    ((LootPoolAccessor)pool).setEntries(entriesList);
                }
            }
            if (class_39.field_274.equals(key)) {
                class_55.class_56 newPool = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)ModItems.ENCHANTED_SCROLL).method_437(5).method_438(MendingEnchantment::new)).method_351((class_79.class_80)class_77.method_411((class_1935)class_1802.field_8529).method_437(1).method_438(MendingEnchantment::new)).method_356(class_219.method_932((float)0.2f));
                LootTableHelper.addPool(original, newPool.method_355());
            }
            return original;
        });
    }

    private static void addPool(class_52 table, class_55 pool) {
        LootTableAccessor accessor = (LootTableAccessor)table;
        ArrayList<class_55> mutablePools = new ArrayList<class_55>(accessor.getPools());
        mutablePools.add(pool);
        accessor.setPools(mutablePools);
    }

    private static class_79 createScrollEntry(class_55 pool, int index) {
        return class_77.method_411((class_1935)ModItems.ENCHANTED_SCROLL).method_437(((LeafEntryAccessor)pool.field_953.get(index)).getWeight()).method_438(SimpleScrollEnchant::new).method_419();
    }

    private static class_79 createBookEntry(class_55 pool, int index) {
        return class_77.method_411((class_1935)class_1802.field_8529).method_437(((LeafEntryAccessor)pool.field_953.get(index)).getWeight() % 5).method_438(SimpleScrollEnchant::new).method_419();
    }

    private static class_79 createEnchantableItemEntry(class_55 pool, int index, class_1792 item) {
        return class_77.method_411((class_1935)item).method_437(((LeafEntryAccessor)pool.field_953.get(index)).getWeight()).method_438(ItemEnchant::new).method_419();
    }

    private static boolean isEnchantable(List<class_117> functions) {
        for (class_117 func : functions) {
            if (func instanceof class_109) {
                return !LootTableHelper.isStructureBound((class_109)func);
            }
            if (!(func instanceof class_106)) continue;
            return true;
        }
        return false;
    }

    private static boolean isStructureBound(class_109 func) {
        Optional<class_6885<class_1887>> options = ((EnchantRandomlyAccessor)func).getOptions();
        if (options.isEmpty()) {
            return true;
        }
        class_6885<class_1887> allowedEnchants = options.get();
        for (class_6880 entry : allowedEnchants) {
            for (class_5321<class_1887> forbiddenKey : STRUCTURE_ENCHANTS) {
                if (!entry.method_40225(forbiddenKey)) continue;
                return true;
            }
        }
        return false;
    }
}

