/*
 * Decompiled with CFR 0.152.
 */
package net.qiuflms.enchantingsystemrework.screen.custom;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2359;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9636;
import net.qiuflms.enchantingsystemrework.EnchantingSystemRework;
import net.qiuflms.enchantingsystemrework.block.ModBlocks;
import net.qiuflms.enchantingsystemrework.block.custom.CustomEnchantingTable;
import net.qiuflms.enchantingsystemrework.item.ModItems;
import net.qiuflms.enchantingsystemrework.screen.ModScreenHandlers;
import net.qiuflms.enchantingsystemrework.util.EnchantmentEntry;
import net.qiuflms.enchantingsystemrework.util.EnchantmentsHelper;

public class CustomEnchantingTableScreenHandler
extends class_1703 {
    static final class_2960 EMPTY_LAPIS_LAZULI_SLOT_TEXTURE = class_2960.method_60656((String)"container/slot/lapis_lazuli");
    static final class_2960 EMPTY_SCROLL_SLOT = class_2960.method_60655((String)"enchantingsystemrework", (String)"container/slot/icon_scroll");
    private final class_1657 player;
    private final class_3914 context;
    private final class_5819 random = class_5819.method_43047();
    private final class_3915 seed = class_3915.method_17403();
    public final int[] enchantmentPower = new int[3];
    public final int[] enchantmentId = new int[]{-1, -1, -1};
    public final int[] enchantmentLevel = new int[]{-1, -1, -1};
    private final class_1263 inventory = new class_1277(3){

        public void method_5431() {
            super.method_5431();
            CustomEnchantingTableScreenHandler.this.method_7609((class_1263)this);
        }
    };

    public CustomEnchantingTableScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, class_3914.field_17304);
    }

    public CustomEnchantingTableScreenHandler(int syncId, class_1661 playerInventory, class_3914 context) {
        super(ModScreenHandlers.CUSTOM_ENCHANTING_TABLE_SCREEN_HANDLER, syncId);
        this.context = context;
        this.player = playerInventory.field_7546;
        this.method_7621(new class_1735(this, this.inventory, 0, 11, 36){

            public int method_7675() {
                return 1;
            }
        });
        this.method_7621(new class_1735(this, this.inventory, 1, 35, 47){

            public boolean method_7680(class_1799 stack) {
                return stack.method_31574(class_1802.field_8759);
            }

            public class_2960 method_7679() {
                return EMPTY_LAPIS_LAZULI_SLOT_TEXTURE;
            }
        });
        this.method_7621(new class_1735(this, this.inventory, 2, 35, 23){

            public int method_7675() {
                return 1;
            }

            public boolean method_7680(class_1799 stack) {
                return stack.method_31574(ModItems.ENCHANTED_SCROLL);
            }

            public class_2960 method_7679() {
                return EMPTY_SCROLL_SLOT;
            }
        });
        this.method_61624((class_1263)playerInventory, 8, 84);
        this.method_17362(class_3915.method_17406((int[])this.enchantmentPower, (int)0));
        this.method_17362(class_3915.method_17406((int[])this.enchantmentPower, (int)1));
        this.method_17362(class_3915.method_17406((int[])this.enchantmentPower, (int)2));
        this.method_17362(this.seed).method_17404(playerInventory.field_7546.method_7278());
        this.method_17362(class_3915.method_17406((int[])this.enchantmentId, (int)0));
        this.method_17362(class_3915.method_17406((int[])this.enchantmentId, (int)1));
        this.method_17362(class_3915.method_17406((int[])this.enchantmentId, (int)2));
        this.method_17362(class_3915.method_17406((int[])this.enchantmentLevel, (int)0));
        this.method_17362(class_3915.method_17406((int[])this.enchantmentLevel, (int)1));
        this.method_17362(class_3915.method_17406((int[])this.enchantmentLevel, (int)2));
    }

    private boolean canBeEnchanted() {
        class_1799 targetItem = this.inventory.method_5438(0);
        class_1799 scrollStack = this.inventory.method_5438(2);
        if (targetItem.method_7960()) {
            return false;
        }
        if (targetItem.method_7909() == class_1802.field_8529) {
            return false;
        }
        if (scrollStack.method_7960() || !scrollStack.method_31574(ModItems.ENCHANTED_SCROLL)) {
            return true;
        }
        class_9304 scrollEnchants = (class_9304)scrollStack.method_58694(class_9334.field_49643);
        if (scrollEnchants == null || scrollEnchants.method_57543()) {
            return true;
        }
        Iterator iterator = scrollEnchants.method_57539().iterator();
        if (iterator.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
            class_1887 enchantment = (class_1887)((class_6880)entry.getKey()).comp_349();
            return enchantment.method_8192(targetItem) || targetItem.method_31574(class_1802.field_8529);
        }
        return true;
    }

    public void method_7609(class_1263 inventory) {
        if (inventory == this.inventory) {
            class_1799 itemStack = inventory.method_5438(0);
            if (!itemStack.method_7960() && itemStack.method_7923()) {
                this.context.method_17393((world, pos) -> {
                    int j;
                    class_2359 indexedIterable = world.method_30349().method_30530(class_7924.field_41265).method_40295();
                    int ix = 0;
                    for (class_2338 blockPos : CustomEnchantingTable.POWER_PROVIDER_OFFSETS) {
                        if (!CustomEnchantingTable.canAccessPowerProvider(world, pos, blockPos)) continue;
                        ++ix;
                    }
                    this.random.method_43052((long)this.seed.method_17407());
                    for (j = 0; j < 3; ++j) {
                        this.enchantmentPower[j] = class_1890.method_8227((class_5819)this.random, (int)j, (int)ix, (class_1799)itemStack);
                        this.enchantmentId[j] = -1;
                        this.enchantmentLevel[j] = -1;
                        if (this.enchantmentPower[j] >= j + 1) continue;
                        this.enchantmentPower[j] = 0;
                    }
                    if (!this.canBeEnchanted()) {
                        for (j = 0; j < 3; ++j) {
                            this.enchantmentPower[j] = 0;
                        }
                    }
                    for (int jx = 0; jx < 3; ++jx) {
                        List<class_1889> list;
                        if (this.enchantmentPower[jx] <= 0 || (list = this.generateEnchantments(itemStack, jx + 1, (class_5321<class_1937>)world.method_27983(), this.player.method_7292())) == null || list.isEmpty()) continue;
                        class_1889 enchantmentLevelEntry = list.get(this.random.method_43048(list.size()));
                        this.enchantmentId[jx] = indexedIterable.method_10206((Object)enchantmentLevelEntry.comp_3486());
                        this.enchantmentLevel[jx] = enchantmentLevelEntry.comp_3487();
                    }
                    this.method_7623();
                });
            } else {
                for (int i = 0; i < 3; ++i) {
                    this.enchantmentPower[i] = 0;
                    this.enchantmentId[i] = -1;
                    this.enchantmentLevel[i] = -1;
                }
            }
        }
    }

    private List<class_1889> generateEnchantments(class_1799 stack, int slot, class_5321<class_1937> world, double luck) {
        class_9304 scrollEnchants;
        int levelRequirement = this.enchantmentPower[slot - 1];
        EnchantingSystemRework.LOGGER.info("Power: {}", (Object)Arrays.toString(this.enchantmentPower));
        if (slot == 3 && levelRequirement < 30) {
            this.enchantmentPower[2] = 0;
            return List.of();
        }
        if (slot == 2 && levelRequirement < 9) {
            this.enchantmentPower[1] = 0;
            return List.of();
        }
        this.random.method_43052((long)this.seed.method_17407() + (long)slot);
        ArrayList<class_1889> enchantments = new ArrayList<class_1889>();
        List<EnchantmentEntry> generatedEnchantments = EnchantmentsHelper.generateMultipleEnchantmentsWeightedWithoutCurses(world, this.random, stack, List.of(Float.valueOf(1.0f), Float.valueOf(0.5f), Float.valueOf(0.25f)), luck);
        if (generatedEnchantments.isEmpty()) {
            return List.of();
        }
        List<Integer> levels = EnchantmentsHelper.generateTableLevelEnchantments(world, this.random, generatedEnchantments, slot, luck);
        class_1799 scrollStack = this.inventory.method_5438(2);
        if (!scrollStack.method_7960() && scrollStack.method_31574(ModItems.ENCHANTED_SCROLL) && (scrollEnchants = (class_9304)scrollStack.method_58694(class_9334.field_49643)) != null) {
            for (Object2IntMap.Entry entry : scrollEnchants.method_57539()) {
                class_1889 scrollEntry = new class_1889((class_6880)entry.getKey(), entry.getIntValue());
                if (!((class_1887)scrollEntry.comp_3486().comp_349()).method_8192(this.inventory.method_5438(0))) {
                    return List.of();
                }
                for (int i = 0; i < generatedEnchantments.size(); ++i) {
                    if (generatedEnchantments.get(i).getEntry() != scrollEntry.comp_3486()) continue;
                    levels.set(i, scrollEntry.comp_3487());
                }
            }
        }
        for (int i = 0; i < generatedEnchantments.size(); ++i) {
            enchantments.add(new class_1889(generatedEnchantments.get(i).getEntry(), levels.get(i).intValue()));
        }
        return enchantments;
    }

    private List<class_1889> generateEnchantments(class_5455 registryManager, class_1799 stack, int slot, int level, class_5321<class_1937> world) {
        class_9304 scrollEnchants;
        class_1799 scrollStack;
        this.random.method_43052((long)this.seed.method_17407() + (long)slot);
        Optional optional = registryManager.method_30530(class_7924.field_41265).method_46733(class_9636.field_51547);
        if (optional.isEmpty()) {
            return List.of();
        }
        List<class_1889> list = EnchantmentsHelper.generateCustomEnchantments(this.random, stack, level, EnchantmentsHelper.removeCurses(EnchantmentsHelper.getWorldEnchantments(world)), (class_5321<class_1937>)class_1937.field_25179);
        if (stack.method_31574(class_1802.field_8529) && list.size() > 1) {
            list.remove(this.random.method_43048(list.size()));
        }
        if (!(scrollStack = this.inventory.method_5438(2)).method_7960() && scrollStack.method_31574(ModItems.ENCHANTED_SCROLL) && (scrollEnchants = (class_9304)scrollStack.method_58694(class_9334.field_49643)) != null) {
            for (Object2IntMap.Entry entry : scrollEnchants.method_57539()) {
                class_1889 scrollEntry = new class_1889((class_6880)entry.getKey(), entry.getIntValue());
                if (!((class_1887)scrollEntry.comp_3486().comp_349()).method_8192(this.inventory.method_5438(0))) {
                    return List.of();
                }
                list.removeIf(randomEntry -> {
                    if (randomEntry.comp_3486() == scrollEntry.comp_3486()) {
                        return true;
                    }
                    boolean isCompatible = class_1887.method_60033((class_6880)scrollEntry.comp_3486(), (class_6880)randomEntry.comp_3486());
                    return !isCompatible;
                });
                list.addFirst(scrollEntry);
            }
        }
        return list;
    }

    public int getLapisCount() {
        class_1799 itemStack = this.inventory.method_5438(1);
        return itemStack.method_7960() ? 0 : itemStack.method_7947();
    }

    public int getSeed() {
        return this.seed.method_17407();
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.context.method_17393((world, pos) -> this.method_7607(player, this.inventory));
    }

    public boolean method_7597(class_1657 player) {
        return CustomEnchantingTableScreenHandler.method_17695((class_3914)this.context, (class_1657)player, (class_2248)ModBlocks.CUSTOM_ENCHANTING_TABLE);
    }

    public boolean method_7604(class_1657 player, int id) {
        if (id >= 0 && id < this.enchantmentPower.length) {
            class_1799 itemStack = this.inventory.method_5438(0);
            class_1799 itemStack2 = this.inventory.method_5438(1);
            class_1799 itemStack3 = this.inventory.method_5438(2);
            int i = id + 1;
            if ((itemStack2.method_7960() || itemStack2.method_7947() < i) && !player.method_56992()) {
                return false;
            }
            if (this.enchantmentPower[id] <= 0 || itemStack.method_7960() || (player.field_7520 < i || player.field_7520 < this.enchantmentPower[id]) && !player.method_56992()) {
                return false;
            }
            this.context.method_17393((world, pos) -> {
                class_1799 itemStack4 = itemStack;
                List<class_1889> list = this.generateEnchantments(itemStack, i, (class_5321<class_1937>)world.method_27983(), player.method_7292());
                if (!list.isEmpty()) {
                    player.method_7286(itemStack, i);
                    if (itemStack.method_31574(class_1802.field_8529)) {
                        itemStack4 = itemStack.method_60503((class_1935)class_1802.field_8598);
                        this.inventory.method_5447(0, itemStack4);
                    }
                    for (class_1889 enchantmentLevelEntry : list) {
                        itemStack4.method_7978(enchantmentLevelEntry.comp_3486(), enchantmentLevelEntry.comp_3487());
                    }
                    itemStack2.method_57008(i, (class_1309)player);
                    if (itemStack2.method_7960()) {
                        this.inventory.method_5447(1, class_1799.field_8037);
                    }
                    itemStack3.method_57008(1, (class_1309)player);
                    if (itemStack3.method_7960()) {
                        this.inventory.method_5447(2, class_1799.field_8037);
                    }
                    player.method_7281(class_3468.field_15420);
                    if (player instanceof class_3222) {
                        class_174.field_1181.method_8870((class_3222)player, itemStack4, i);
                    }
                    this.inventory.method_5431();
                    this.seed.method_17404(player.method_7278());
                    this.method_7609(this.inventory);
                    world.method_8396(null, pos, class_3417.field_15119, class_3419.field_15245, 1.0f, world.field_9229.method_43057() * 0.1f + 0.9f);
                }
            });
            return true;
        }
        class_156.method_33559((String)(player.method_74861() + " pressed invalid button id: " + id));
        return false;
    }

    public class_1799 method_7601(class_1657 player, int slot) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot2 = (class_1735)this.field_7761.get(slot);
        if (slot2.method_7681()) {
            class_1799 itemStack2 = slot2.method_7677();
            itemStack = itemStack2.method_7972();
            if (slot == 0 || slot == 1 || slot == 2) {
                if (!this.method_7616(itemStack2, 3, 39, true)) {
                    return class_1799.field_8037;
                }
            } else if (itemStack2.method_31574(class_1802.field_8759)) {
                if (!this.method_7616(itemStack2, 1, 2, true)) {
                    return class_1799.field_8037;
                }
            } else if (itemStack2.method_31574(ModItems.ENCHANTED_SCROLL)) {
                if (!this.method_7616(itemStack2, 2, 3, true)) {
                    return class_1799.field_8037;
                }
            } else {
                if (((class_1735)this.field_7761.get(0)).method_7681() || !((class_1735)this.field_7761.get(0)).method_7680(itemStack2)) {
                    return class_1799.field_8037;
                }
                class_1799 oneItem = itemStack2.method_46651(1);
                itemStack2.method_7934(1);
                ((class_1735)this.field_7761.get(0)).method_53512(oneItem);
            }
            if (itemStack2.method_7960()) {
                slot2.method_53512(class_1799.field_8037);
            } else {
                slot2.method_7668();
            }
            if (itemStack2.method_7947() == itemStack.method_7947()) {
                return class_1799.field_8037;
            }
            slot2.method_7667(player, itemStack2);
        }
        return itemStack;
    }
}

