/*
 * Decompiled with CFR 0.152.
 */
package net.qiuflms.enchantingsystemrework.util;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9636;
import net.minecraft.class_9889;
import net.minecraft.server.MinecraftServer;
import net.qiuflms.enchantingsystemrework.EnchantingSystemRework;
import net.qiuflms.enchantingsystemrework.util.EnchantmentEntry;
import net.qiuflms.enchantingsystemrework.util.EnchantmentLevel;

public class EnchantmentsHelper {
    private static MinecraftServer server;
    private static List<EnchantmentEntry> ENCHANTMENTS;

    public static void onServerStarted(MinecraftServer server) {
        EnchantmentsHelper.server = server;
        ENCHANTMENTS = List.of(EnchantmentsHelper.createPairLockedToWorld((class_5321<class_1887>)class_1893.field_9128, (class_5321<class_1937>)class_1937.field_25179, Rarity.UNCOMMON), EnchantmentsHelper.createPairLockedToWorld((class_5321<class_1887>)class_1893.field_9105, (class_5321<class_1937>)class_1937.field_25179, Rarity.UNCOMMON), EnchantmentsHelper.createPairLockedToWorld((class_5321<class_1887>)class_1893.field_9122, (class_5321<class_1937>)class_1937.field_25179, Rarity.UNCOMMON), EnchantmentsHelper.createPairLockedToWorld((class_5321<class_1887>)class_1893.field_9127, (class_5321<class_1937>)class_1937.field_25179, Rarity.UNCOMMON), EnchantmentsHelper.createPairLockedToWorld((class_5321<class_1887>)class_1893.field_9117, (class_5321<class_1937>)class_1937.field_25179, Rarity.RARE), EnchantmentsHelper.createPairLockedToWorld((class_5321<class_1887>)class_1893.field_9106, (class_5321<class_1937>)class_1937.field_25179, Rarity.RARE), EnchantmentsHelper.createPairLockedToWorld((class_5321<class_1887>)class_1893.field_9120, (class_5321<class_1937>)class_1937.field_25179, Rarity.RARE), EnchantmentsHelper.createPairLockedToWorld((class_5321<class_1887>)class_1893.field_9104, (class_5321<class_1937>)class_1937.field_25179, Rarity.RARE), EnchantmentsHelper.createPairLockedToWorld((class_5321<class_1887>)class_1893.field_9114, (class_5321<class_1937>)class_1937.field_25179, Rarity.RARE), EnchantmentsHelper.createPairLockedToWorld((class_5321<class_1887>)class_1893.field_9100, (class_5321<class_1937>)class_1937.field_25179, Rarity.RARE), EnchantmentsHelper.createPairLockedToWorld((class_5321<class_1887>)class_1893.field_9124, (class_5321<class_1937>)class_1937.field_25180, Rarity.UNCOMMON), EnchantmentsHelper.createPairLockedToWorld((class_5321<class_1887>)class_1893.field_9126, (class_5321<class_1937>)class_1937.field_25180, Rarity.UNCOMMON), EnchantmentsHelper.createPairLockedToWorld((class_5321<class_1887>)class_1893.field_9101, (class_5321<class_1937>)class_1937.field_25181, Rarity.RARE), EnchantmentsHelper.createPair((class_5321<class_1887>)class_1893.field_9109, Rarity.RARE), EnchantmentsHelper.createPair((class_5321<class_1887>)class_1893.field_9113, Rarity.RARE), EnchantmentsHelper.createPair((class_5321<class_1887>)class_1893.field_9119, Rarity.UNCOMMON), EnchantmentsHelper.createPair((class_5321<class_1887>)class_1893.field_9107, Rarity.COMMON), EnchantmentsHelper.createPair((class_5321<class_1887>)class_1893.field_9129, Rarity.COMMON), EnchantmentsHelper.createPair((class_5321<class_1887>)class_1893.field_9096, Rarity.COMMON), EnchantmentsHelper.createPair((class_5321<class_1887>)class_1893.field_9095, Rarity.COMMON), EnchantmentsHelper.createPair((class_5321<class_1887>)class_1893.field_9111, Rarity.COMMON), EnchantmentsHelper.createPair((class_5321<class_1887>)class_1893.field_9097, Rarity.COMMON), EnchantmentsHelper.createPair((class_5321<class_1887>)class_1893.field_9112, Rarity.COMMON), EnchantmentsHelper.createPair((class_5321<class_1887>)class_1893.field_50158, Rarity.UNCOMMON), EnchantmentsHelper.createPair((class_5321<class_1887>)class_1893.field_50157, Rarity.UNCOMMON), EnchantmentsHelper.createPair((class_5321<class_1887>)class_1893.field_9131, Rarity.UNCOMMON), EnchantmentsHelper.createPair((class_5321<class_1887>)class_1893.field_9110, Rarity.UNIQUE), EnchantmentsHelper.createPair((class_5321<class_1887>)class_1893.field_9121, Rarity.COMMON), EnchantmentsHelper.createPair((class_5321<class_1887>)class_1893.field_9118, Rarity.COMMON), EnchantmentsHelper.createPair((class_5321<class_1887>)class_1893.field_9123, Rarity.COMMON), EnchantmentsHelper.createPair((class_5321<class_1887>)class_1893.field_9115, Rarity.COMMON), EnchantmentsHelper.createPair((class_5321<class_1887>)class_1893.field_9125, Rarity.UNCOMMON), EnchantmentsHelper.createPair((class_5321<class_1887>)class_1893.field_9108, Rarity.COMMON), EnchantmentsHelper.createPair((class_5321<class_1887>)class_1893.field_9132, Rarity.UNCOMMON), EnchantmentsHelper.createPair((class_5321<class_1887>)class_1893.field_9103, Rarity.UNCOMMON), EnchantmentsHelper.createPair((class_5321<class_1887>)class_1893.field_9116, Rarity.UNCOMMON), EnchantmentsHelper.createPair((class_5321<class_1887>)class_1893.field_9098, Rarity.UNCOMMON), EnchantmentsHelper.createPair((class_5321<class_1887>)class_1893.field_9130, Rarity.UNIQUE), EnchantmentsHelper.createPair((class_5321<class_1887>)class_1893.field_9099, Rarity.RARE));
    }

    public static MinecraftServer getWorld() {
        return server;
    }

    private static EnchantmentLevel calculateBasicEnchantmentLevels(class_5321<class_1887> enchantmentRegistryKey) {
        class_1887 enchantment = (class_1887)EnchantmentEntry.getEntry(enchantmentRegistryKey).comp_349();
        if (enchantment.method_8183() == 1) {
            return new EnchantmentLevel(1, 1, 1);
        }
        if (enchantment.method_8183() == 2) {
            return new EnchantmentLevel(1, 1, 2);
        }
        return new EnchantmentLevel(enchantment.method_8183() - 2, enchantment.method_8183() - 1, enchantment.method_8183());
    }

    private static EnchantmentEntry createPair(class_5321<class_1887> enchantmentRegistryKey, Rarity rarity) {
        return new EnchantmentEntry(enchantmentRegistryKey, EnchantmentsHelper.calculateBasicEnchantmentLevels(enchantmentRegistryKey), rarity);
    }

    private static EnchantmentEntry createPairLockedToWorld(class_5321<class_1887> enchantmentRegistryKey, class_5321<class_1937> world, Rarity rarity) {
        if (world == class_1937.field_25179) {
            return new EnchantmentEntry(enchantmentRegistryKey, ((class_1887)EnchantmentEntry.getEntry(enchantmentRegistryKey).comp_349()).method_8183(), 0, 0, rarity);
        }
        if (world == class_1937.field_25180) {
            return new EnchantmentEntry(enchantmentRegistryKey, 0, ((class_1887)EnchantmentEntry.getEntry(enchantmentRegistryKey).comp_349()).method_8183(), 0, rarity);
        }
        return new EnchantmentEntry(enchantmentRegistryKey, 0, 0, ((class_1887)EnchantmentEntry.getEntry(enchantmentRegistryKey).comp_349()).method_8183(), rarity);
    }

    private static List<EnchantmentEntry> acceptableEnchantments(class_1799 item) {
        ArrayList<EnchantmentEntry> filteredList = new ArrayList<EnchantmentEntry>();
        for (EnchantmentEntry enchantment : ENCHANTMENTS) {
            if (!enchantment.getEnchantment().method_8192(item)) continue;
            filteredList.add(enchantment);
        }
        return filteredList;
    }

    public static EnchantmentEntry generateSingleTradeableEnchantment(class_5321<class_1937> world, class_5819 random) {
        List<EnchantmentEntry> generatedEnchantments = EnchantmentsHelper.getWorldEnchantments(world);
        return EnchantmentsHelper.generateSingleTradeableEnchantment(random, generatedEnchantments);
    }

    private static EnchantmentEntry generateSingleTradeableEnchantment(class_5819 random, List<EnchantmentEntry> enchantments) {
        return EnchantmentsHelper.generateSingleEnchantment(random, EnchantmentsHelper.filterTradeableEnchantments(enchantments));
    }

    public static List<EnchantmentEntry> generateMultipleTradeableEnchantment(class_5321<class_1937> world, class_5819 random, class_1799 item, List<Float> chances) {
        List<EnchantmentEntry> generatedEnchantments = EnchantmentsHelper.getWorldEnchantments(world, item);
        return EnchantmentsHelper.generateMultipleTradeableEnchantment(random, EnchantmentsHelper.filterTradeableEnchantments(generatedEnchantments), chances);
    }

    private static List<EnchantmentEntry> generateMultipleTradeableEnchantment(class_5819 random, List<EnchantmentEntry> enchantments, List<Float> chances) {
        return EnchantmentsHelper.generateMultipleEnchantments(random, enchantments, chances);
    }

    public static List<EnchantmentEntry> filterTradeableEnchantments(List<EnchantmentEntry> enchantments) {
        enchantments.removeIf(enchantment -> !enchantment.getEntry().method_40220(class_9636.field_51545));
        return enchantments;
    }

    public static List<EnchantmentEntry> filterTableEnchantments(List<EnchantmentEntry> enchantments) {
        enchantments.removeIf(enchantment -> !enchantment.getEntry().method_40220(class_9636.field_51547));
        return enchantments;
    }

    public static List<EnchantmentEntry> getWorldEnchantments(class_5321<class_1937> world) {
        ArrayList<EnchantmentEntry> list = new ArrayList<EnchantmentEntry>();
        for (EnchantmentEntry enchantment : ENCHANTMENTS) {
            if (enchantment.getLevel().getDimensionLevel(world) == 0) continue;
            list.add(enchantment);
        }
        return list;
    }

    public static List<EnchantmentEntry> getWorldEnchantments(class_5321<class_1937> world, class_1799 item) {
        ArrayList<EnchantmentEntry> list = new ArrayList<EnchantmentEntry>();
        for (EnchantmentEntry enchantment : EnchantmentsHelper.acceptableEnchantments(item)) {
            if (enchantment.getLevel().getDimensionLevel(world) == 0) continue;
            list.add(enchantment);
        }
        return list;
    }

    public static void applyEnchantmentComponent(class_1799 item, EnchantmentEntry enchantment, int level) {
        class_9304.class_9305 builder = new class_9304.class_9305(class_9304.field_49385);
        builder.method_57550(enchantment.getEntry(), level);
        item.method_57379(class_9334.field_49643, (Object)builder.method_57549());
    }

    public static void applyEnchantment(class_1799 item, EnchantmentEntry enchantment, int level) {
        item.method_7978(enchantment.getEntry(), level);
    }

    public static void applyEnchantment(class_1799 item, List<EnchantmentEntry> enchantments, List<Integer> levels) {
        for (int i = 0; i < enchantments.size(); ++i) {
            EnchantmentsHelper.applyEnchantment(item, enchantments.get(i), levels.get(i));
        }
    }

    private static List<EnchantmentEntry> generateMultipleEnchantments(class_5819 random, List<EnchantmentEntry> enchantments, List<Float> chances) {
        ArrayList<EnchantmentEntry> result = new ArrayList<EnchantmentEntry>();
        block0: for (float chance : chances) {
            if (!(random.method_43057() < chance)) continue;
            for (int i = 0; i < enchantments.size(); ++i) {
                if (EnchantmentsHelper.canBeCombined(result, enchantments.get(i))) {
                    result.add(enchantments.get(i));
                    continue block0;
                }
                enchantments.remove(i);
                --i;
            }
        }
        return result;
    }

    public static List<EnchantmentEntry> generateMultipleEnchantmentsWeighted(class_5321<class_1937> world, class_5819 random, class_1799 item, List<Float> chances, double luck) {
        List<EnchantmentEntry> generatedEnchantments = EnchantmentsHelper.getWorldEnchantments(world, item);
        return EnchantmentsHelper.generateMultipleEnchantmentsWeighted(random, generatedEnchantments, chances, luck);
    }

    public static List<EnchantmentEntry> generateMultipleEnchantmentsWeightedWithoutCurses(class_5321<class_1937> world, class_5819 random, class_1799 item, List<Float> chances, double luck) {
        List<EnchantmentEntry> generatedEnchantments = EnchantmentsHelper.filterTableEnchantments(EnchantmentsHelper.getWorldEnchantments(world, item));
        return EnchantmentsHelper.generateMultipleEnchantmentsWeighted(random, generatedEnchantments, chances, luck);
    }

    private static List<EnchantmentEntry> generateMultipleEnchantmentsWeighted(class_5819 random, List<EnchantmentEntry> enchantments, List<Float> chances, double luck) {
        ArrayList<EnchantmentEntry> result = new ArrayList<EnchantmentEntry>();
        block0: for (float chance : chances) {
            if (!((double)random.method_43057() < (double)chance + luck * (double)0.15f)) continue;
            int value = random.method_43048(EnchantmentsHelper.calculateWeights(enchantments, luck));
            for (int i = 0; i < enchantments.size(); ++i) {
                if ((value -= enchantments.get((int)i).getRarity().value + enchantments.get(i).getRarity().bonus(luck)) > 0) continue;
                result.add(enchantments.get(i));
                EnchantmentsHelper.removeIncompatible(enchantments, enchantments.get(i));
                continue block0;
            }
        }
        return result;
    }

    private static void removeIncompatible(List<EnchantmentEntry> enchantments, EnchantmentEntry enchantment) {
        enchantments.removeIf(entry -> !class_1887.method_60033(entry.getEntry(), enchantment.getEntry()));
    }

    private static EnchantmentEntry generateSingleEnchantment(class_5819 random, List<EnchantmentEntry> enchantments) {
        return enchantments.get(random.method_43048(enchantments.size()));
    }

    public static EnchantmentEntry generateSingleEnchantmentWeighted(class_5321<class_1937> world, class_5819 random, double luck) {
        List<EnchantmentEntry> enchantments = EnchantmentsHelper.getWorldEnchantments(world);
        return EnchantmentsHelper.generateSingleEnchantmentWeighted(random, enchantments, luck);
    }

    private static EnchantmentEntry generateSingleEnchantmentWeighted(class_5819 random, List<EnchantmentEntry> enchantments, double luck) {
        int value = random.method_43048(EnchantmentsHelper.calculateWeights(enchantments, luck));
        for (EnchantmentEntry enchantment : enchantments) {
            if ((value -= enchantment.getRarity().value + enchantment.getRarity().bonus(luck)) > 0) continue;
            return enchantment;
        }
        return enchantments.get(random.method_43048(enchantments.size()));
    }

    public static int generateEnchantmentLevel(class_5321<class_1937> world, class_5819 random, EnchantmentEntry enchantment) {
        return random.method_39332(enchantment.getLevel().getMinLevel(world), enchantment.getLevel().getDimensionLevel(world));
    }

    public static List<Integer> generateEnchantmentLevel(class_5321<class_1937> world, class_5819 random, List<EnchantmentEntry> enchantments) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (EnchantmentEntry enchantment : enchantments) {
            result.add(EnchantmentsHelper.generateEnchantmentLevel(world, random, enchantment));
        }
        return result;
    }

    private static List<Integer> splitIntoThree(int maxLevel, int buttonLevel) {
        List<Integer> source = IntStream.range(1, maxLevel + 1).boxed().toList();
        int size = source.size();
        int split1 = (int)Math.round((double)size / 3.0);
        int split2 = (int)Math.round((double)(2 * size) / 3.0);
        if (source.size() == 1) {
            return List.of(Integer.valueOf(1));
        }
        if (buttonLevel == 1) {
            if (source.size() == 2) {
                return List.of(Integer.valueOf(1));
            }
            return new ArrayList<Integer>(source.subList(0, split1));
        }
        if (buttonLevel == 2) {
            if (source.size() == 2) {
                return List.of(Integer.valueOf(1), Integer.valueOf(2));
            }
            return new ArrayList<Integer>(source.subList(split1, split2));
        }
        if (buttonLevel == 3) {
            if (source.size() == 2) {
                return List.of(Integer.valueOf(2));
            }
            ArrayList<Integer> result = new ArrayList<Integer>(source.subList(split1, split2));
            result.addAll(source.subList(split2, size));
            return result;
        }
        return new ArrayList<Integer>();
    }

    private static int generateEnchantmentLevel(class_5321<class_1937> world, class_5819 random, EnchantmentEntry enchantment, int buttonLevel, double luck) {
        List<Integer> levels = EnchantmentsHelper.splitIntoThree(enchantment.getLevel().getDimensionLevel(world), buttonLevel);
        int totalWeight = 0;
        int size = levels.size();
        for (int i = 0; i < size; ++i) {
            totalWeight += size * (size - i) - i + (int)luck * i;
        }
        int randomValue = random.method_43048(totalWeight) + 1;
        for (int i = 0; i < size; ++i) {
            int weight = size * (size - i) - i + (int)luck * i;
            if (randomValue <= weight) {
                return levels.get(i);
            }
            randomValue -= weight;
        }
        return 0;
    }

    public static List<Integer> generateTableLevelEnchantments(class_5321<class_1937> world, class_5819 random, List<EnchantmentEntry> enchantments, int buttonLevel, double luck) {
        EnchantingSystemRework.LOGGER.info("Generation");
        EnchantingSystemRework.LOGGER.info(String.valueOf(buttonLevel));
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (EnchantmentEntry enchantment : enchantments) {
            result.add(EnchantmentsHelper.generateEnchantmentLevel(world, random, enchantment, buttonLevel, luck));
        }
        EnchantingSystemRework.LOGGER.info(String.valueOf(result.size()));
        return result;
    }

    private static boolean canBeCombined(List<EnchantmentEntry> enchantments, EnchantmentEntry enchantment) {
        for (EnchantmentEntry listedEnchantments : enchantments) {
            if (class_1887.method_60033(listedEnchantments.getEntry(), enchantment.getEntry())) continue;
            return false;
        }
        return true;
    }

    private static int calculateWeights(List<EnchantmentEntry> enchantments, double luck) {
        int weights = 0;
        for (EnchantmentEntry enchantment : enchantments) {
            weights += enchantment.getRarity().value + enchantment.getRarity().bonus(luck);
        }
        return weights;
    }

    public static List<class_1889> generateCustomEnchantments(class_5819 random, class_1799 stack, int buttonLevel, List<EnchantmentEntry> allowedEnchantments, class_5321<class_1937> world) {
        ArrayList<class_1889> result = new ArrayList<class_1889>();
        int enchantability = ((class_9889)stack.method_7909().method_7854().method_58694(class_9334.field_53695)).comp_2938();
        int modifiedLevel = EnchantmentsHelper.calculateModifiedLevel(random, buttonLevel, enchantability);
        if (modifiedLevel <= 0) {
            return result;
        }
        List<class_1889> candidates = EnchantmentsHelper.getCandidates(modifiedLevel, stack, allowedEnchantments, world);
        if (candidates.isEmpty()) {
            return result;
        }
        class_1889 firstEnchant = EnchantmentsHelper.pickWeighted(random, candidates);
        if (firstEnchant != null) {
            result.add(firstEnchant);
            EnchantmentsHelper.removeIncompatible(candidates, firstEnchant);
        }
        while (random.method_43048(50) <= modifiedLevel && !candidates.isEmpty()) {
            modifiedLevel /= 2;
            class_1889 extraEnchant = EnchantmentsHelper.pickWeighted(random, candidates);
            if (extraEnchant == null) continue;
            result.add(extraEnchant);
            EnchantmentsHelper.removeIncompatible(candidates, extraEnchant);
        }
        return result;
    }

    private static int calculateModifiedLevel(class_5819 random, int base, int enchantability) {
        if (enchantability <= 0) {
            return Math.max(1, base);
        }
        int i = enchantability / 4 + 1;
        int j = enchantability / 4 + 1;
        int bonus = random.method_43048(i) + random.method_43048(j);
        int level = base + bonus + 1;
        float f = (random.method_43057() + random.method_43057() - 1.0f) * 0.15f;
        level = class_3532.method_15340((int)Math.round((float)level + (float)level * f), (int)1, (int)Integer.MAX_VALUE);
        return level;
    }

    private static List<class_1889> getCandidates(int power, class_1799 stack, List<EnchantmentEntry> allowed, class_5321<class_1937> world) {
        ArrayList<class_1889> candidates = new ArrayList<class_1889>();
        block0: for (EnchantmentEntry entry : allowed) {
            class_1887 enchantment = entry.getEnchantment();
            if (!enchantment.method_8192(stack) && !stack.method_31574(class_1802.field_8529)) continue;
            for (int i = entry.getLevel().getDimensionLevel(world); i >= 1; --i) {
                int minCost = enchantment.comp_2687().comp_2510().method_58447(i);
                int maxCost = enchantment.comp_2687().comp_2511().method_58447(i);
                if (power < minCost || power > maxCost) continue;
                candidates.add(new class_1889(entry.getEntry(), i));
                continue block0;
            }
        }
        return candidates;
    }

    private static class_1889 pickWeighted(class_5819 random, List<class_1889> list) {
        if (list.isEmpty()) {
            return null;
        }
        int totalWeight = 0;
        for (class_1889 entry : list) {
            totalWeight += ((class_1887)entry.comp_3486().comp_349()).method_58445();
        }
        if (totalWeight <= 0) {
            return null;
        }
        int ticket = random.method_43048(totalWeight);
        for (class_1889 entry : list) {
            if ((ticket -= ((class_1887)entry.comp_3486().comp_349()).method_58445()) >= 0) continue;
            return entry;
        }
        return list.getFirst();
    }

    private static void removeIncompatible(List<class_1889> candidates, class_1889 chosen) {
        candidates.removeIf(entry -> {
            if (entry.comp_3486().equals((Object)chosen.comp_3486())) {
                return true;
            }
            return !class_1887.method_60033((class_6880)entry.comp_3486(), (class_6880)chosen.comp_3486());
        });
    }

    public static List<EnchantmentEntry> removeCurses(List<EnchantmentEntry> list) {
        list.removeIf(entry -> entry.getKey() == class_1893.field_9113 || entry.getKey() == class_1893.field_9109);
        return list;
    }

    public static enum Rarity {
        COMMON(20),
        UNCOMMON(15),
        RARE(12),
        UNIQUE(8);

        public final int value;

        private Rarity(int value) {
            this.value = value;
        }

        public int bonus(double luck) {
            if (luck < 0.0) {
                return this.value;
            }
            if (this == UNIQUE || this == RARE) {
                return (int)(luck * (double)this.value / 2.0);
            }
            return this.value;
        }
    }
}

