/*
 * Decompiled with CFR 0.152.
 */
package org.worldlisttrashcan.WorldLimitEntityCount;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.SlimeSplitEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.worldlisttrashcan.WorldLimitEntityCount.removeEntity;
import org.worldlisttrashcan.WorldListTrashCan;
import org.worldlisttrashcan.message;

public class LimitMain
implements Listener {
    public static Map<String, Integer> worldLimits = new HashMap<String, Integer>();
    public static List<String> BanWorlds = new ArrayList<String>();
    public static boolean WorldLimitFlag = false;
    public static Map<String, int[]> GatherLimits = new HashMap<String, int[]>();
    public static List<String> GatherBanWorlds = new ArrayList<String>();
    public static boolean GatherLimitFlag = false;

    @EventHandler
    public void onEntitySplit(SlimeSplitEvent event) {
        event.getEntity();
        Slime slime = event.getEntity();
        List metadata = slime.getMetadata("isClear");
        if (metadata != null && !metadata.isEmpty()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        int limit;
        LivingEntity entity = event.getEntity();
        if (event.isCancelled()) {
            return;
        }
        if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.SLIME_SPLIT) {
            return;
        }
        EntityType entityType = entity.getType();
        String worldName = event.getLocation().getWorld().getName();
        if (WorldLimitFlag && worldLimits.containsKey(entityType.name().toLowerCase()) && !BanWorlds.contains(worldName)) {
            limit = worldLimits.get(entityType.name().toLowerCase());
            if (LimitMain.getEntityCount(entityType, worldName) >= limit) {
                event.setCancelled(true);
                entity.remove();
                return;
            }
        }
        if (GatherLimitFlag && GatherLimits.containsKey(entityType.name()) && !GatherBanWorlds.contains(worldName)) {
            limit = GatherLimits.get(entityType.name())[0];
            int range = GatherLimits.get(entityType.name())[1];
            int clearCount = GatherLimits.get(entityType.name())[2];
            ArrayList<Entity> entityList = new ArrayList<Entity>();
            ArrayList<Player> PlayerList = new ArrayList<Player>();
            for (Object NearEntity : event.getEntity().getNearbyEntities((double)range, (double)range, (double)range)) {
                if (NearEntity.getType() == entity.getType()) {
                    entityList.add((Entity)NearEntity);
                }
                if (!(NearEntity instanceof Player)) continue;
                PlayerList.add((Player)NearEntity);
            }
            int size = entityList.size();
            if (size > limit - 1) {
                for (Player player : PlayerList) {
                    player.sendMessage(message.find("GatherClearToNearPlayerMessage").replace("%entityType%", entityType + "").replace("%range%", range + "").replace("%size%", size + ""));
                }
                if (clearCount > size) {
                    clearCount = size;
                }
                for (int i = 0; i < clearCount; ++i) {
                    Entity entity1 = (Entity)entityList.get(i);
                    if (entity1 instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)entity1;
                        removeEntity.removeLivingEntity(livingEntity);
                        continue;
                    }
                    entity1.remove();
                }
            }
        }
    }

    public static EntityType getEntityType(String name) {
        for (EntityType type : EntityType.values()) {
            if (!type.name().equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }

    public static String getEntityTypes() {
        StringBuilder sb = new StringBuilder();
        for (EntityType type : EntityType.values()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(type.name());
        }
        return sb.toString();
    }

    public static int getEntityCount(EntityType entityType, String worldName) {
        int count = 0;
        for (Entity entity : Bukkit.getWorld((String)worldName).getEntities()) {
            if (entity.getType() != entityType) continue;
            ++count;
        }
        return count;
    }

    @EventHandler
    public void onClickEntity(PlayerInteractEntityEvent event) {
        Entity entity;
        Player player = event.getPlayer();
        if (WorldListTrashCan.UseEntityBarPlayerList.contains(player) && (entity = event.getRightClicked()).getType() != null) {
            String typename = entity.getName();
            TextComponent clipboardMessage = new TextComponent(message.find("ClickFindEntityType").replace("%EntityType%", typename));
            clipboardMessage.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, typename));
            player.spigot().sendMessage((BaseComponent)clipboardMessage);
            WorldListTrashCan.UseEntityBarPlayerList.remove(player);
        }
    }
}

