/*
 * Decompiled with CFR 0.152.
 */
package org.worldlisttrashcan.shaded.adventure.audience;

import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.worldlisttrashcan.shaded.adventure.audience.Audience;
import org.worldlisttrashcan.shaded.adventure.audience.ForwardingAudience;
import org.worldlisttrashcan.shaded.adventure.resource.ResourcePackCallback;
import org.worldlisttrashcan.shaded.adventure.text.ComponentLike;

public final class Audiences {
    static final Collector<? super Audience, ?, ForwardingAudience> COLLECTOR = Collectors.collectingAndThen(Collectors.toCollection(ArrayList::new), audiences -> Audience.audience(Collections.unmodifiableCollection(audiences)));

    private Audiences() {
    }

    @NotNull
    public static Consumer<? super Audience> sendingMessage(@NotNull ComponentLike message2) {
        return audience -> audience.sendMessage(message2);
    }

    @NotNull
    static ResourcePackCallback unwrapCallback(Audience forwarding, Audience dest, @NotNull ResourcePackCallback cb) {
        if (cb == ResourcePackCallback.noOp()) {
            return cb;
        }
        return (uuid, status, audience) -> cb.packEventReceived(uuid, status, audience == dest ? forwarding : audience);
    }
}

