/*
 * Decompiled with CFR 0.152.
 */
package org.worldlisttrashcan.AutoTrashMain;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;
import org.worldlisttrashcan.AutoTrashMain.FoliaRunable;
import org.worldlisttrashcan.IsVersion;
import org.worldlisttrashcan.WorldListTrashCan;
import org.worldlisttrashcan.message;

public class AutoTrashListener
implements Listener {
    public static int OriginalFeatureClearItemAddGlobalTrashModel;
    public static Boolean NoWorldTrashCanEnterPersonalTrashCan;
    public static Map<Player, Inventory> PlayerToInventory;
    public static Map<Item, Player> ItemToPlayer;
    public static Boolean VersionFlag;

    public Map<Player, Inventory> getPlayerToInventory() {
        return PlayerToInventory;
    }

    public AutoTrashListener() {
        VersionFlag = !IsVersion.compareVersions("1.16.0");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        Inventory inventory = event.getInventory();
        if (!PlayerToInventory.containsValue(inventory)) return;
        ItemStack itemStack = event.getCurrentItem();
        double Coins = WorldListTrashCan.main.getConfig().getDouble("Set.PersonalTrashCan.OriginalFeatureClearItemAddGlobalTrash.Model2.Coins");
        int count = event.getRawSlot();
        if (count >= 0 && count <= 53) {
            if (WorldListTrashCan.main.getConfig().getDouble("Set.PersonalTrashCan.OriginalFeatureClearItemAddGlobalTrash.Model2.Coins") > 0.0) {
                if (itemStack == null || itemStack.getType() == Material.AIR) {
                    event.setCancelled(true);
                    return;
                }
                if (this.UseMoney(player, Coins)) {
                    if (!player.getInventory().addItem(new ItemStack[]{itemStack}).isEmpty()) {
                        player.getWorld().dropItem(player.getLocation(), itemStack);
                    }
                    DecimalFormat decimalFormat = new DecimalFormat("#.#");
                    String formattedValue = decimalFormat.format(Coins);
                    player.sendMessage(message.find("PlayerTrashCanBuySuccessfully").replace("%count%", formattedValue));
                    int clickedSlot = event.getSlot();
                    PlayerToInventory.get(player).clear(clickedSlot);
                    return;
                } else {
                    event.setCancelled(true);
                    player.sendMessage(message.find("PlayerTrashCanBuyFail"));
                }
                return;
            } else {
                event.setCancelled(true);
                if (itemStack == null || itemStack.getType() == Material.AIR) return;
                HashMap integerItemStackHashMap = player.getInventory().addItem(new ItemStack[]{itemStack});
                if (!integerItemStackHashMap.isEmpty()) return;
                itemStack.setAmount(0);
            }
            return;
        } else {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void PlayerDropItemEvent(PlayerDropItemEvent event) {
        final Item item = event.getItemDrop();
        Player player = event.getPlayer();
        if (ItemToPlayer.containsKey(item)) {
            return;
        }
        ItemToPlayer.put(item, player);
        if (IsVersion.IsFoliaServer) {
            FoliaRunable foliaRunable = new FoliaRunable();
            foliaRunable.FoliaTask(event);
        } else {
            new BukkitRunnable(){

                public void run() {
                    if (ItemToPlayer.get(item) != null) {
                        ItemToPlayer.remove(item);
                    }
                }
            }.runTaskLater(WorldListTrashCan.main, (long)WorldListTrashCan.main.getConfig().getInt("Set.PersonalTrashCan.OriginalFeatureClearItemAddGlobalTrash.Delay") * 20L);
        }
    }

    public boolean UseMoney(Player player, double Count) {
        Economy economy = WorldListTrashCan.getEcon();
        if (economy != null) {
            if (Count > 0.0) {
                EconomyResponse response = economy.withdrawPlayer(player.getName(), Count);
                return response.transactionSuccess();
            }
            economy.depositPlayer((OfflinePlayer)player, Count);
            return true;
        }
        message.consoleSay(message.find("VaultError"));
        return true;
    }

    public static Inventory InitPlayerInv(Player player) {
        return Bukkit.createInventory(null, (int)54, (String)message.find("PlayerTrashCan").replace("%Player%", player.getName()));
    }

    @EventHandler
    public void ClearItemEvent(EntityDamageEvent event) {
        Item item;
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Item && (player = ItemToPlayer.get(item = (Item)entity)) != null) {
            ItemToPlayer.remove(item);
            ItemStack itemStack = item.getItemStack();
            if (OriginalFeatureClearItemAddGlobalTrashModel == 1) {
                for (Inventory inventory : WorldListTrashCan.GlobalTrashList) {
                    if (inventory.addItem(new ItemStack[]{itemStack}).isEmpty()) break;
                }
            } else if (OriginalFeatureClearItemAddGlobalTrashModel == 2) {
                Inventory inventory = PlayerToInventory.get(player);
                if (inventory == null) {
                    PlayerToInventory.put(player, AutoTrashListener.InitPlayerInv(player));
                } else if (!inventory.addItem(new ItemStack[]{itemStack}).isEmpty() && WorldListTrashCan.main.getConfig().getBoolean("Set.PersonalTrashCan.OriginalFeatureClearItemAddGlobalTrash.Model2.AutoClear")) {
                    inventory.clear();
                    player.sendMessage(message.find("PlayerTrashCanFilled"));
                    inventory.addItem(new ItemStack[]{itemStack});
                }
            } else if (OriginalFeatureClearItemAddGlobalTrashModel >= 3) {
                return;
            }
            item.remove();
        }
    }

    static {
        PlayerToInventory = new HashMap<Player, Inventory>();
        ItemToPlayer = new HashMap<Item, Player>();
        VersionFlag = false;
    }
}

