/*
 * Decompiled with CFR 0.152.
 */
package org.worldlisttrashcan.Method;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.clip.placeholderapi.PlaceholderAPI;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Enemy;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.worldlisttrashcan.IsVersion;
import org.worldlisttrashcan.WorldListTrashCan;
import org.worldlisttrashcan.message;
import org.worldlisttrashcan.shaded.adventure.text.Component;
import org.worldlisttrashcan.shaded.adventure.text.serializer.plain.PlainTextComponentSerializer;

public class Method {
    private static List<String> monsterTypes = new ArrayList<String>();
    public static Boolean hasEnemyClass;

    public static String getItemStackAllString(ItemStack itemStack, int amount) {
        Material material = itemStack.getType();
        String item = "[material:" + material + " x " + amount + "]";
        ItemMeta meta = itemStack.getItemMeta();
        if (meta != null) {
            Map enchants;
            String customName = "";
            try {
                if (IsVersion.Is1_21_1_20Server) {
                    if (meta.hasDisplayName()) {
                        if (IsVersion.IsPaperServer) {
                            Component displayNameComponent = meta.displayName();
                            if (displayNameComponent != null) {
                                customName = "[name:" + PlainTextComponentSerializer.plainText().serialize(displayNameComponent) + "]";
                            }
                        } else {
                            String displayName = meta.getDisplayName();
                            customName = "[name:" + meta.getDisplayName() + "]";
                        }
                    }
                } else if (meta.hasDisplayName()) {
                    customName = "[name:" + meta.getDisplayName() + "]";
                }
            }
            catch (Exception e) {
                message.consoleSay("&c\u83b7\u53d6\u7269\u54c1\u63cf\u8ff0\u5b57\u7b26\u4e32\u65f6\u51fa\u9519 " + e);
                customName = "[name:errorName]";
            }
            item = item + customName;
            ArrayList<String> loreList = new ArrayList<String>();
            if (IsVersion.Is1_21_1_20Server) {
                Object lore;
                if (meta.hasLore() && (lore = meta.lore()) != null) {
                    Iterator iterator = lore.iterator();
                    while (iterator.hasNext()) {
                        Component line = (Component)iterator.next();
                        loreList.add(PlainTextComponentSerializer.plainText().serialize(line));
                    }
                }
            } else if (meta.hasLore()) {
                for (String lore : meta.getLore()) {
                    loreList.add(lore);
                }
            }
            if (!loreList.isEmpty()) {
                item = item + "[lore:" + ((Object)loreList).toString() + "]";
            }
            ArrayList<String> enchantList = new ArrayList<String>();
            if (IsVersion.Is1_16_1_20Server) {
                enchants = itemStack.getEnchantments();
                for (Map.Entry entry : enchants.entrySet()) {
                    enchantList.add(((Enchantment)entry.getKey()).getKey().getKey() + ":" + entry.getValue());
                }
            } else {
                enchants = meta.getEnchants();
                for (Enchantment enchantment : enchants.keySet()) {
                    int level = (Integer)enchants.get(enchantment);
                    enchantList.add(enchantment.getName() + ":" + level);
                }
            }
            if (!enchantList.isEmpty()) {
                item = item + "[enchant:" + ((Object)enchantList).toString() + "]";
            }
        }
        return item;
    }

    public static String getItemStackAllString(ItemStack itemStack) {
        return Method.getItemStackAllString(itemStack, itemStack.getAmount());
    }

    public static boolean isMonster(Entity entity) {
        String entityType = entity.getType().toString();
        if (monsterTypes.contains(entityType.toLowerCase())) {
            return true;
        }
        if (entity instanceof Monster) {
            return true;
        }
        if (hasEnemyClass.booleanValue()) {
            return entity instanceof Enemy;
        }
        return false;
    }

    public static boolean isClassPresent(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean AutoCheckFoliaServer() {
        if (Method.isClassPresent("io.papermc.paper.threadedregions.scheduler.FoliaRegionScheduler")) {
            message.consoleSay("&a\u68c0\u6d4b\u5230\u670d\u52a1\u5668\u62e5\u6709Folia\u7684API\uff0c\u6b63\u5728\u9002\u7528\u76ee\u524d\u6700\u4f73\u7684\u65b9\u6cd5");
            return true;
        }
        return false;
    }

    public static boolean AutoCheckPaperServer() {
        if (Method.isClassPresent("io.papermc.paper.threadedregions.scheduler.ScheduledTask")) {
            message.consoleSay("&a\u68c0\u6d4b\u5230\u670d\u52a1\u5668\u62e5\u6709Paper\u7684API\uff0c\u6b63\u5728\u9002\u7528\u76ee\u524d\u6700\u4f73\u7684\u65b9\u6cd5");
            return true;
        }
        return false;
    }

    public static boolean AutoCheckEntityMoveEventServer() {
        if (Method.isClassPresent("io.papermc.paper.event.entity.EntityMoveEvent")) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.GREEN + "\u68c0\u6d4b\u5230\u670d\u52a1\u5668\u62e5\u6709Paper\u7684EntityMoveEvent\uff0c\u6b63\u5728\u9002\u7528\u76ee\u524d\u6700\u4f73\u7684\u65b9\u6cd5");
            return true;
        }
        return false;
    }

    public static String papiReplace(String message2, Player player) {
        if (WorldListTrashCan.papi == null) {
            return message2;
        }
        return PlaceholderAPI.setPlaceholders((Player)player, (String)message2);
    }

    static {
        monsterTypes.add("BLAZE");
        monsterTypes.add("GUARDIAN");
        monsterTypes.add("VEX");
        monsterTypes.add("CREEPER");
        monsterTypes.add("ELDER_GUARDIAN");
        monsterTypes.add("ENDERMITE");
        monsterTypes.add("EVOKER");
        monsterTypes.add("WITHER_SKELETON");
        monsterTypes.add("GUARDIAN");
        monsterTypes.add("HOGLIN");
        monsterTypes.add("ZOMBIE_VILLAGER");
        monsterTypes.add("MAGMA_CUBE");
        monsterTypes.add("PHANTOM");
        monsterTypes.add("PIGLIN_BRUTE");
        monsterTypes.add("RAVAGER");
        monsterTypes.add("PIGLIN");
        monsterTypes.add("SHULKER");
        monsterTypes.add("SILVERFISH");
        monsterTypes.add("SKELETON");
        monsterTypes.add("SLIME");
        monsterTypes.add("WANDERING_TRADER");
        monsterTypes.add("VEX");
        monsterTypes.add("VINDICATOR");
        monsterTypes.add("WITHER");
        monsterTypes.add("WITCH");
        monsterTypes.add("WITHER_SKELETON");
        monsterTypes.add("ZOMBIFIED_PIGLIN");
        monsterTypes.add("ZOMBIE");
        monsterTypes.add("ZOMBIE_VILLAGER");
        monsterTypes.add("GOAT");
        monsterTypes.add("DROWNED");
        monsterTypes.add("ENDERMAN");
        monsterTypes.add("SPIDER");
        monsterTypes.add("CAVE_SPIDER");
        monsterTypes.add("ZOMBIFIED_PIGLIN");
        hasEnemyClass = false;
    }
}

