/*
 * Decompiled with CFR 0.152.
 */
package org.worldlisttrashcan.TrashMain;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.worldlisttrashcan.IsVersion;
import org.worldlisttrashcan.message;

public class GlobalTrashGui
implements InventoryHolder {
    public List<Inventory> TrashList = new ArrayList<Inventory>();

    public void setTrashList(List<Inventory> trashList) {
        this.TrashList = trashList;
    }

    public static void ClearContainer(List<Inventory> TrashList) {
        for (Inventory inventory : TrashList) {
            for (int i = 0; i < 45; ++i) {
                inventory.clear(i);
            }
        }
    }

    public GlobalTrashGui(List<Inventory> TrashList, int MaxCount) {
        this.setTrashList(TrashList);
        this.InitGlobalList(TrashList, MaxCount);
    }

    public Inventory getInventory() {
        return this.TrashList.get(0);
    }

    public void InitGlobalList(List<Inventory> TrashList, int MaxCount) {
        if (!TrashList.isEmpty()) {
            TrashList.clear();
        }
        for (int i = 0; i < MaxCount; ++i) {
            Inventory inventory = this.CreateMenuItemMap(i, MaxCount - 1);
            TrashList.add(inventory);
        }
    }

    public ItemStack CreateItem(Material BackGroundMaterial, String strings, String name) {
        ItemStack itemStack = new ItemStack(BackGroundMaterial);
        ArrayList<String> stringList = new ArrayList<String>();
        for (String lore : strings.split(";")) {
            stringList.add(lore);
        }
        ItemMeta BackGroundItemMeta = itemStack.getItemMeta();
        BackGroundItemMeta.setLore(stringList);
        BackGroundItemMeta.setDisplayName(name);
        itemStack.setItemMeta(BackGroundItemMeta);
        return itemStack;
    }

    public Inventory CreateMenuItemMap(int PageCount, int PageMaxCount) {
        ItemStack ShowBorderItemStack;
        Material ShowBorder;
        if (IsVersion.compareVersions("1.13.0")) {
            ShowBorder = Material.matchMaterial((String)"STAINED_GLASS_PANE");
            ShowBorderItemStack = this.CreateItem(ShowBorder, "", "\u00a7\u00a7");
            ShowBorderItemStack.setDurability((short)15);
        } else {
            ShowBorder = Material.matchMaterial((String)"BLACK_STAINED_GLASS_PANE");
            ShowBorderItemStack = this.CreateItem(ShowBorder, "", "\u00a7\u00a7");
        }
        Inventory Menu = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)message.find("TrashMenuTitle"));
        String integerStrings = "x;x;x;x;x;x;x;x;x;x;x;x;x;x;x;x;x;x;x;x;x;x;x;x;x;x;x;x;x;x;x;x;x;x;x;x;x;x;x;x;x;x;x;x;x;y;a;y;y;y;y;y;b;y";
        int i = 0;
        for (String s : integerStrings.split(";")) {
            if (s.equals("a")) {
                if (PageMaxCount == 1) continue;
                if (PageCount != 0) {
                    Menu.setItem(i, this.CreateItem(Material.ARROW, "", message.find("TrashMenuUpPage")));
                } else {
                    Menu.setItem(i, ShowBorderItemStack);
                }
            } else if (s.equals("b")) {
                if (PageMaxCount == 1) continue;
                if (PageCount != PageMaxCount) {
                    Menu.setItem(i, this.CreateItem(Material.ARROW, "", message.find("TrashMenuDownPage")));
                } else {
                    Menu.setItem(i, ShowBorderItemStack);
                }
            } else if (s.equals("y")) {
                Menu.setItem(i, ShowBorderItemStack);
            }
            ++i;
        }
        return Menu;
    }
}

