/*
 * Decompiled with CFR 0.152.
 */
package org.worldlisttrashcan.TrashMain;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;
import org.worldlisttrashcan.IsVersion;
import org.worldlisttrashcan.TrashMain.BanGui;
import org.worldlisttrashcan.TrashMain.RashCanInformation;
import org.worldlisttrashcan.WorldListTrashCan;
import org.worldlisttrashcan.data;
import org.worldlisttrashcan.message;

public class TrashListener
implements Listener {
    public static Set<String> GlobalItemSetString;

    @EventHandler
    public void PlayerPlaceBlock(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (WorldListTrashCan.PlayerToWorld.get(player) != null) {
            if (event.isCancelled()) {
                player.sendMessage(message.find("NotWorldPlaceOrBreakFlag"));
                WorldListTrashCan.PlayerToWorld.remove(player);
            } else {
                player.sendMessage(message.find("HaveFlag"));
                event.setCancelled(true);
                Inventory inventory = new BanGui().getInventory(player);
                player.openInventory(inventory);
                WorldListTrashCan.PlayerToWorld.remove(player);
            }
        }
    }

    @EventHandler
    public void PlayerPlaceBlock(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        if (WorldListTrashCan.PlayerToWorld.get(player) != null) {
            if (event.isCancelled()) {
                player.sendMessage(message.find("NotWorldPlaceOrBreakFlag"));
                WorldListTrashCan.PlayerToWorld.remove(player);
            } else {
                player.sendMessage(message.find("HaveFlag"));
                event.setCancelled(true);
                Inventory inventory = new BanGui().getInventory(player);
                player.openInventory(inventory);
                WorldListTrashCan.PlayerToWorld.remove(player);
            }
        }
    }

    public Location getChestLocation1_12(Location signLocation) {
        Block sign = signLocation.getBlock();
        byte signID = sign.getData();
        if (sign.getType().toString().contains("WALL_SIGN")) {
            switch (signID) {
                case 2: {
                    Location chestLocation = new Location(signLocation.getWorld(), signLocation.getX(), signLocation.getY(), signLocation.getZ() + 1.0);
                    return chestLocation;
                }
                case 3: {
                    Location chestLocation = new Location(signLocation.getWorld(), signLocation.getX(), signLocation.getY(), signLocation.getZ() - 1.0);
                    return chestLocation;
                }
                case 4: {
                    Location chestLocation = new Location(signLocation.getWorld(), signLocation.getX() + 1.0, signLocation.getY(), signLocation.getZ());
                    return chestLocation;
                }
                case 5: {
                    Location chestLocation = new Location(signLocation.getWorld(), signLocation.getX() - 1.0, signLocation.getY(), signLocation.getZ());
                    return chestLocation;
                }
            }
        } else {
            Location chestLocation = new Location(signLocation.getWorld(), signLocation.getX(), signLocation.getY() - 1.0, signLocation.getZ());
            return chestLocation;
        }
        return null;
    }

    public Location getChestLocation1_13(Location signLocation) {
        Block sign = signLocation.getBlock();
        if (sign.getType().toString().contains("WALL_SIGN")) {
            Sign sign1 = (Sign)sign.getState();
            BlockData blockData = sign1.getBlockData();
            if (blockData instanceof Directional) {
                BlockFace facing = ((Directional)blockData).getFacing().getOppositeFace();
                int xOffset = facing.getModX();
                int yOffset = facing.getModY();
                int zOffset = facing.getModZ();
                Block attachedBlock = signLocation.getBlock().getRelative(xOffset, yOffset, zOffset);
                return attachedBlock.getLocation();
            }
        } else {
            Location chestLocation = new Location(signLocation.getWorld(), signLocation.getX(), signLocation.getY() - 1.0, signLocation.getZ());
            return chestLocation;
        }
        return null;
    }

    @EventHandler
    public void onSignChange(SignChangeEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("WorldListTrashCan.Main")) {
            return;
        }
        if (WorldListTrashCan.main.getConfig().getBoolean("Set.Debug")) {
            message.consoleSay("\u544a\u793a\u724c\u5b50ID\u4e3a" + event.getBlock().getData());
            message.consoleSay("\u544a\u793a\u724ctype\u4e3a" + event.getBlock().getType());
        }
        String[] lines = event.getLines();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (!line.contains(WorldListTrashCan.main.getConfig().getString("Set.SighCheckName"))) continue;
            if (IsVersion.IsFoliaServer) {
                player.sendMessage(message.find("BanWorldTrashCanInFoliaServer"));
                continue;
            }
            final Block sign = event.getBlock();
            Location signLocation = sign.getLocation();
            Location chestLocation = IsVersion.compareVersions("1.13.0") ? this.getChestLocation1_12(signLocation) : this.getChestLocation1_13(signLocation);
            if (chestLocation != null && chestLocation.getBlock().getType() == Material.CHEST) {
                World world = signLocation.getWorld();
                if (player.isOp() || !WorldListTrashCan.main.getConfig().getStringList("Set.BanWorldNameList").contains(world.getName())) {
                    int RashMax = data.getConfig().getStringList("WorldData." + world.getName() + ".SignLocation").size();
                    int Count = data.getConfig().getInt("WorldData." + world.getName() + ".RashMaxCount");
                    if (player.isOp() || RashMax < Count || Count == 0 && RashMax < WorldListTrashCan.main.getConfig().getInt("Set.DefaultRashCanMax")) {
                        if (WorldListTrashCan.main.getConfig().getBoolean("Set.Debug")) {
                            message.consoleSay("\u76ee\u524d\u8be5\u4e16\u754c\u5df2\u521b\u5efa\u5783\u573e\u6876\u6570\u91cf\u4e3a\uff1a" + data.getConfig().getStringList("WorldData." + world.getName() + ".SignLocation").size());
                            message.consoleSay("\u914d\u7f6e\u6587\u4ef6\u6700\u5927\u652f\u6301\u5783\u573e\u6876\u6570\u91cf\u4e3a\uff1a" + WorldListTrashCan.main.getConfig().getInt("Set.RashCanMax"));
                        }
                        player.sendMessage(message.find("CreateRashCan").replace("%world%", world.getName()));
                        event.setLine(i, WorldListTrashCan.main.getConfig().getString("Set.SighCheckedName"));
                        final int n = i;
                        if (IsVersion.IsFoliaServer) {
                            player.getScheduler().runDelayed(WorldListTrashCan.main, (Consumer)new Consumer<ScheduledTask>(){

                                @Override
                                public void accept(ScheduledTask scheduledTask) {
                                    Sign sign1 = (Sign)sign.getState();
                                    sign1.setLine(n, WorldListTrashCan.main.getConfig().getString("Set.SighCheckedName"));
                                    sign1.update();
                                }
                            }, () -> message.consoleSay("Error,Player is null"), 2L);
                        } else {
                            new BukkitRunnable(){

                                public void run() {
                                    Sign sign1 = (Sign)sign.getState();
                                    sign1.setLine(n, WorldListTrashCan.main.getConfig().getString("Set.SighCheckedName"));
                                    sign1.update();
                                }
                            }.runTaskLater(WorldListTrashCan.main, 2L);
                        }
                        if (WorldListTrashCan.WorldToLocation.get(world) != null) {
                            Set<Location> locationSet = WorldListTrashCan.WorldToLocation.get(world).getLocationSet();
                            locationSet.add(chestLocation);
                            data.dataPut(world, locationSet);
                            break;
                        }
                        HashSet<Location> locationSet = new HashSet<Location>();
                        locationSet.add(chestLocation);
                        data.dataPut(world, locationSet);
                        break;
                    }
                    if (WorldListTrashCan.main.getConfig().getBoolean("Set.Debug")) {
                        message.consoleSay("RashMax: " + RashMax);
                        message.consoleSay("Count: " + Count);
                        message.consoleSay("Default: " + WorldListTrashCan.main.getConfig().getInt("Set.DefaultRashCanMax"));
                    }
                    player.sendMessage(message.find("ReachRashCanCount"));
                    continue;
                }
                player.sendMessage(message.find("InBanWorldList"));
                continue;
            }
            player.sendMessage(message.find("NotChest"));
        }
    }

    @EventHandler
    public void PlayerBreakSigh(BlockBreakEvent event) {
        Player player = event.getPlayer();
        World world = player.getWorld();
        Block block = event.getBlock();
        Location location = block.getLocation();
        if (block.getState() instanceof Sign) {
            Sign sign = (Sign)block.getState();
            for (String line : sign.getLines()) {
                Location chestLocation;
                if (!line.contains(WorldListTrashCan.main.getConfig().getString("Set.SighCheckedName")) || (chestLocation = IsVersion.compareVersions("1.13.0") ? this.getChestLocation1_12(location) : this.getChestLocation1_13(location)) == null || chestLocation.getBlock().getType() != Material.CHEST || WorldListTrashCan.WorldToLocation.get(world) == null) continue;
                Set<Location> locationSet = WorldListTrashCan.WorldToLocation.get(world).getLocationSet();
                player.sendMessage(message.find("RashBreak").replace("%world%", world.getName()));
                locationSet.remove(chestLocation);
                data.dataPut(world, locationSet);
                break;
            }
        } else if (block.getType() == Material.CHEST && block.getType() == Material.CHEST && WorldListTrashCan.WorldToLocation.get(world) != null && !WorldListTrashCan.WorldToLocation.get(world).getLocationSet().isEmpty() && WorldListTrashCan.WorldToLocation.get(world).getLocationSet().contains(location)) {
            Set<Location> locationSet1 = WorldListTrashCan.WorldToLocation.get(world).getLocationSet();
            locationSet1.remove(location);
            data.dataPut(world, locationSet1);
            player.sendMessage(message.find("RashBreak").replace("%world%", world.getName()));
        }
    }

    @EventHandler
    public void PlayerBanGuiClose(InventoryCloseEvent event) {
        Inventory inventory = event.getInventory();
        Player player = (Player)event.getPlayer();
        World world = player.getWorld();
        if (event.getView().getTitle().equals(message.find("BanChestInventoryName").replace("%world%", player.getWorld().getName()))) {
            HashSet<String> ItemSetString = null;
            if (WorldListTrashCan.WorldToLocation.get(world) != null && !WorldListTrashCan.WorldToLocation.get(world).getBanItemSet().isEmpty()) {
                if (WorldListTrashCan.main.getConfig().getBoolean("Set.Debug")) {
                    player.sendMessage(ChatColor.BLUE + "WorldToLocation.get(world)!=null1\uff1a" + (WorldListTrashCan.WorldToLocation.get(world) != null));
                    player.sendMessage(ChatColor.BLUE + "WorldToLocation.get(world).getBanItemSet().isEmpty()1\uff1a" + WorldListTrashCan.WorldToLocation.get(world).getBanItemSet().isEmpty());
                }
                ItemSetString = WorldListTrashCan.WorldToLocation.get(world).getBanItemSet();
            } else {
                if (WorldListTrashCan.main.getConfig().getBoolean("Set.Debug")) {
                    player.sendMessage(ChatColor.BLUE + "WorldToLocation.get(world)!=null2\uff1a" + (WorldListTrashCan.WorldToLocation.get(world) != null));
                    player.sendMessage(ChatColor.BLUE + "WorldToLocation.get(world).getBanItemSet().isEmpty()2\uff1a" + WorldListTrashCan.WorldToLocation.get(world).getBanItemSet().isEmpty());
                }
                ItemSetString = new HashSet();
            }
            boolean flag = false;
            for (ItemStack itemStack : inventory) {
                String StringItemStack;
                if (itemStack == null) continue;
                if (WorldListTrashCan.main.getConfig().getBoolean("Set.Debug")) {
                    player.sendMessage(ChatColor.BLUE + "\u8be5\u7269\u54c1\u662f\uff1a" + itemStack.getType());
                }
                if (!ItemSetString.contains(StringItemStack = itemStack.getType().toString())) {
                    ItemSetString.add(StringItemStack);
                    player.sendMessage(message.find("BanAddItem").replace("%ItemType%", StringItemStack));
                    if (WorldListTrashCan.main.getConfig().getBoolean("Set.Debug")) {
                        message.consoleSay(ChatColor.BLUE + "\u7269\u54c1: " + itemStack.getItemMeta().getDisplayName());
                    }
                } else {
                    ItemSetString.remove(StringItemStack);
                    player.sendMessage(message.find("BanRemoveItem").replace("%ItemType%", StringItemStack));
                }
                flag = true;
                RashCanInformation rashCanInformation = WorldListTrashCan.WorldToLocation.get(world);
                rashCanInformation.setBanItemSet(ItemSetString);
                WorldListTrashCan.WorldToLocation.put(world, rashCanInformation);
            }
            if (flag) {
                data.dataPut(world.getName(), ItemSetString);
                player.sendMessage(message.find("BanListTitle"));
                for (String itemString : ItemSetString) {
                    player.sendMessage(message.find("BanItemFormat").replace("%Item%", itemString));
                }
            } else {
                player.sendMessage(message.find("BanNull"));
            }
        } else if (event.getView().getTitle().equals(message.find("GlobalBanChestInventoryName").replace("%world%", player.getWorld().getName()))) {
            GlobalItemSetString = new HashSet<String>(WorldListTrashCan.main.getConfig().getStringList("GlobalBanItem"));
            if (WorldListTrashCan.main.getConfig().getBoolean("Set.Debug")) {
                for (String string : GlobalItemSetString) {
                    message.consoleSay("GlobalBan  Item: " + string);
                }
            }
            boolean flag = false;
            for (ItemStack itemStack : inventory) {
                String StringItemStack;
                if (itemStack == null) continue;
                if (WorldListTrashCan.main.getConfig().getBoolean("Set.Debug")) {
                    player.sendMessage(ChatColor.BLUE + "\u8be5\u7269\u54c1\u662f\uff1a" + itemStack.getType());
                }
                if (!GlobalItemSetString.contains(StringItemStack = itemStack.getType().toString())) {
                    GlobalItemSetString.add(StringItemStack);
                    player.sendMessage(message.find("BanAddItem").replace("%ItemType%", StringItemStack));
                    if (WorldListTrashCan.main.getConfig().getBoolean("Set.Debug")) {
                        message.consoleSay(ChatColor.BLUE + "\u7269\u54c1: " + itemStack.getItemMeta().getDisplayName());
                    }
                } else {
                    GlobalItemSetString.remove(StringItemStack);
                    player.sendMessage(message.find("BanRemoveItem").replace("%ItemType%", StringItemStack));
                }
                flag = true;
            }
            if (flag) {
                WorldListTrashCan.main.getConfig().set("GlobalBanItem", (Object)GlobalItemSetString.toArray());
                WorldListTrashCan.main.saveConfig();
                WorldListTrashCan.main.reloadConfig();
                player.sendMessage(message.find("GlobalBanListTitle"));
                for (String itemString : GlobalItemSetString) {
                    player.sendMessage(message.find("BanItemFormat").replace("%Item%", itemString));
                }
            } else {
                player.sendMessage(message.find("BanNull"));
            }
        }
    }

    @EventHandler
    public void PlayerEnterWorld(PlayerChangedWorldEvent event) {
        World world = event.getPlayer().getWorld();
        String WorldName = world.getName();
        ConfigurationSection WorldDataSection = data.getConfig().getConfigurationSection("WorldData");
        if (WorldListTrashCan.WorldToLocation.get(world) == null && WorldDataSection.getKeys(false).contains(WorldName)) {
            HashSet locStrSet = new HashSet(data.getConfig().getStringList("WorldData." + WorldName + ".SignLocation"));
            HashSet<String> BanItemSet = new HashSet<String>(data.getConfig().getStringList("WorldData." + WorldName + ".BanItem"));
            HashSet<Location> LocationSet = new HashSet<Location>();
            for (String locStr : locStrSet) {
                String[] strings;
                for (String string : strings = locStr.split(",")) {
                    System.out.println("s " + string);
                }
                if (world == null || strings.length != 3) {
                    message.consoleSay(message.find("ConfigError").replace("%world%", WorldName).replace("%location%", locStr));
                    continue;
                }
                double x = Double.parseDouble(strings[0]);
                double y = Double.parseDouble(strings[1]);
                double z = Double.parseDouble(strings[2]);
                Location location = new Location(world, x, y, z);
                LocationSet.add(location);
            }
            WorldListTrashCan.WorldToLocation.put(world, new RashCanInformation(LocationSet, BanItemSet));
        }
    }

    @EventHandler
    public void PlayerJoinGame(PlayerJoinEvent event) {
        World world = event.getPlayer().getWorld();
        String WorldName = world.getName();
        ConfigurationSection WorldDataSection = data.getConfig().getConfigurationSection("WorldData");
        if (WorldListTrashCan.WorldToLocation.get(world) == null && WorldDataSection.getKeys(false).contains(WorldName)) {
            HashSet locStrSet = new HashSet(data.getConfig().getStringList("WorldData." + WorldName + ".SignLocation"));
            HashSet<String> BanItemSet = new HashSet<String>(data.getConfig().getStringList("WorldData." + WorldName + ".BanItem"));
            HashSet<Location> LocationSet = new HashSet<Location>();
            for (String locStr : locStrSet) {
                String[] strings;
                for (String string : strings = locStr.split(",")) {
                    System.out.println("s " + string);
                }
                if (world == null || strings.length != 3) {
                    message.consoleSay(message.find("ConfigError").replace("%world%", WorldName).replace("%location%", locStr));
                    continue;
                }
                double x = Double.parseDouble(strings[0]);
                double y = Double.parseDouble(strings[1]);
                double z = Double.parseDouble(strings[2]);
                Location location = new Location(world, x, y, z);
                LocationSet.add(location);
            }
            WorldListTrashCan.WorldToLocation.put(world, new RashCanInformation(LocationSet, BanItemSet));
        }
    }
}

