/*
 * Decompiled with CFR 0.152.
 */
package org.worldlisttrashcan;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.worldlisttrashcan.TrashMain.RashCanInformation;
import org.worldlisttrashcan.WorldListTrashCan;
import org.worldlisttrashcan.message;

public class data {
    private static File dataFile;
    private static FileConfiguration Data;

    public static FileConfiguration getConfig() {
        return Data;
    }

    public static void LoadData() {
        dataFile = new File(WorldListTrashCan.main.getDataFolder(), "data" + File.separator + "data.yml");
        if (!dataFile.exists()) {
            WorldListTrashCan.main.saveResource("data" + File.separator + "data.yml", false);
        }
        Data = YamlConfiguration.loadConfiguration((File)dataFile);
        WorldListTrashCan.WorldToLocation.clear();
        ConfigurationSection WorldDataSection = Data.getConfigurationSection("WorldData");
        boolean flag = false;
        for (String WorldName : WorldDataSection.getKeys(false)) {
            HashSet locStrSet = new HashSet(data.getConfig().getStringList("WorldData." + WorldName + ".SignLocation"));
            HashSet<String> BanItemSet = new HashSet<String>(data.getConfig().getStringList("WorldData." + WorldName + ".BanItem"));
            World world = Bukkit.getWorld((String)WorldName);
            HashSet<Location> LocationSet = new HashSet<Location>();
            if (!locStrSet.isEmpty()) {
                for (String locStr : locStrSet) {
                    String[] strings = locStr.split(",");
                    if (world == null || strings.length != 3) {
                        message.consoleSay(message.find("ConfigError").replace("%world%", WorldName).replace("%location%", locStr));
                        flag = true;
                        continue;
                    }
                    double x = Double.parseDouble(strings[0]);
                    double y = Double.parseDouble(strings[1]);
                    double z = Double.parseDouble(strings[2]);
                    Location location = new Location(world, x, y, z);
                    LocationSet.add(location);
                }
            }
            WorldListTrashCan.WorldToLocation.put(world, new RashCanInformation(LocationSet, BanItemSet));
        }
        if (flag) {
            message.consoleSay(message.find("HaveHomePlugin"));
        }
    }

    public static int RashMaxCountAdd(World world, int Count) {
        int nowCount = data.getConfig().getInt("WorldData." + world.getName() + ".RashMaxCount");
        int defaultCount = WorldListTrashCan.main.getConfig().getInt("Set.DefaultRashCanMax");
        if (nowCount == 0) {
            nowCount = defaultCount;
        }
        if (Count + nowCount >= defaultCount) {
            if (WorldListTrashCan.main.getConfig().getBoolean("Set.Debug")) {
                message.consoleSay("worldname2: " + world.getName());
                message.consoleSay("Count: " + Count + " nowCount: " + nowCount);
            }
            data.getConfig().set("WorldData." + world.getName() + ".RashMaxCount", (Object)(Count + nowCount));
            data.saveData();
            return Count + nowCount;
        }
        if (WorldListTrashCan.main.getConfig().getBoolean("Set.Debug")) {
            message.consoleSay("worldname1: " + world.getName());
            message.consoleSay("Count: " + Count + " nowCount: " + nowCount);
        }
        data.getConfig().set("WorldData." + world.getName() + ".RashMaxCount", (Object)defaultCount);
        data.saveData();
        return defaultCount;
    }

    public static void dataPut(World world, Set<Location> locationSet) {
        ArrayList<String> locStrList = new ArrayList<String>();
        String WorldName = world.getName();
        for (Location location : locationSet) {
            String locStr = location.getX() + "," + location.getY() + "," + location.getZ();
            locStrList.add(locStr);
        }
        data.getConfig().set("WorldData." + WorldName + ".SignLocation", locStrList);
        if (WorldListTrashCan.WorldToLocation.get(world) == null) {
            WorldListTrashCan.WorldToLocation.put(world, new RashCanInformation(locationSet, null));
        } else {
            WorldListTrashCan.WorldToLocation.put(world, new RashCanInformation(locationSet, WorldListTrashCan.WorldToLocation.get(world).getBanItemSet()));
        }
        data.saveData();
    }

    public static void dataPut(String WorldName, Set<String> NewItemString) {
        data.getConfig().set("WorldData." + WorldName + ".BanItem", (Object)NewItemString.toArray());
        data.saveData();
    }

    public static void saveData() {
        try {
            Data.save(dataFile);
        }
        catch (IOException var2) {
            Bukkit.getLogger().info(message.find("NotFindConfig"));
        }
    }
}

