/*
 * Decompiled with CFR 0.152.
 */
package org.worldlisttrashcan.Method;

import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.worldlisttrashcan.IsVersion;
import org.worldlisttrashcan.message;
import org.worldlisttrashcan.shaded.adventure.platform.bukkit.BukkitAudiences;

public class SendMessageAbstract {
    private BukkitAudiences adventure = null;
    private JavaPlugin plugin;

    public SendMessageAbstract(JavaPlugin plugin) {
        this.plugin = plugin;
        if (!IsVersion.IsPaperServer) {
            this.adventure = BukkitAudiences.create((Plugin)plugin);
        }
    }

    public void sendActionBar(Player player, String msg) {
        try {
            if (IsVersion.Is1_21_5_21_NServer) {
                player.sendActionBar(message.color(msg, true));
                return;
            }
            if (IsVersion.Is1_12_1_16Server) {
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(message.color(msg)));
                return;
            }
            if (this.adventure == null) {
                player.sendActionBar(message.color(msg, true));
            } else {
                this.adventure.player(player).sendActionBar(message.color(msg, true));
            }
        }
        catch (Throwable t) {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(message.color(msg)));
        }
    }

    public void sendSound(Player player, String soundStr) {
        String[] soundStrArr = soundStr.split(",");
        String sound = soundStrArr[0];
        float volume = Float.parseFloat(soundStrArr[1]);
        float pitch = Float.parseFloat(soundStrArr[2]);
        player.playSound(player.getLocation(), sound, volume, pitch);
    }
}

