/*
 * Decompiled with CFR 0.152.
 */
package org.worldlisttrashcan;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.worldlisttrashcan.AutoTrashMain.AutoTrashListener;
import org.worldlisttrashcan.AutoTrashMain.HeightVersionPlayerDropItemListener;
import org.worldlisttrashcan.Bstats.Metrics;
import org.worldlisttrashcan.DropSystem.DropLimitListener;
import org.worldlisttrashcan.IsVersion;
import org.worldlisttrashcan.Method.Method;
import org.worldlisttrashcan.Method.SendMessageAbstract;
import org.worldlisttrashcan.Papi.Papi;
import org.worldlisttrashcan.SimpleChange.NotPickArrowListener;
import org.worldlisttrashcan.SimpleChange.TreadingFarmLandListener;
import org.worldlisttrashcan.SpeakSystem.QuickSpeakListener;
import org.worldlisttrashcan.SpeakSystem.QuickUseCommandListener;
import org.worldlisttrashcan.TrashMain.BanGui;
import org.worldlisttrashcan.TrashMain.ClearItemsTask;
import org.worldlisttrashcan.TrashMain.FoliaClearItemsTask;
import org.worldlisttrashcan.TrashMain.GlobalTrashGui;
import org.worldlisttrashcan.TrashMain.GuiListener;
import org.worldlisttrashcan.TrashMain.RashCanInformation;
import org.worldlisttrashcan.TrashMain.TrashListener;
import org.worldlisttrashcan.WorldLimitEntityCount.BukkitClearGatherEntityTask;
import org.worldlisttrashcan.WorldLimitEntityCount.BukkitPlayerMoveEvent;
import org.worldlisttrashcan.WorldLimitEntityCount.LimitMain;
import org.worldlisttrashcan.WorldLimitEntityCount.PaperEntityMoveEvent;
import org.worldlisttrashcan.WorldLimitEntityCount.removeEntity;
import org.worldlisttrashcan.data;
import org.worldlisttrashcan.log;
import org.worldlisttrashcan.message;

public final class WorldListTrashCan
extends JavaPlugin {
    public static Plugin main;
    public static BossBar bossBar;
    public static WorldListTrashCan worldListTrashCan;
    public ClearItemsTask clearItemsTask;
    public FoliaClearItemsTask foliaClearItemsTask;
    public static GlobalTrashGui globalTrashGui;
    public static SendMessageAbstract sendMessageAbstract;
    public static List<Inventory> GlobalTrashList;
    public static Papi papi;
    public static boolean EconomyFlag;
    public static Map<World, RashCanInformation> WorldToLocation;
    public static List<Player> UseEntityBarPlayerList;
    public static BukkitClearGatherEntityTask bukkitClearGatherEntityTask;
    public static Map<Player, World> PlayerToWorld;
    public static boolean GlobalTrashGuiFlag;
    public static List<String> NoClearContainerLore;
    public static List<String> NoClearContainerName;
    public static List<String> NoClearContainerType;
    AutoTrashListener autoTrashListener = new AutoTrashListener();
    HeightVersionPlayerDropItemListener heightVersionPlayerDropItemListener = new HeightVersionPlayerDropItemListener();
    DropLimitListener dropLimitListener = new DropLimitListener();
    NotPickArrowListener notPickArrowListener = new NotPickArrowListener();
    QuickSpeakListener quickSpeakListener = new QuickSpeakListener();
    TreadingFarmLandListener treadingFarmLandListener = new TreadingFarmLandListener();
    QuickUseCommandListener quickUseCommandListener = new QuickUseCommandListener();
    BukkitPlayerMoveEvent bukkitPlayerMoveEvent = new BukkitPlayerMoveEvent();
    PaperEntityMoveEvent paperEntityMoveEvent = new PaperEntityMoveEvent();
    public static Economy econ;

    public ClearItemsTask getClearItemsTask() {
        return this.clearItemsTask;
    }

    public FoliaClearItemsTask getFoliaClearItemsTask() {
        return this.foliaClearItemsTask;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        List<String> allSubCommands = Arrays.asList("PlayerTrash", "DropMode", "look", "GlobalBan", "help", "reload", "GlobalTrash", "ban", "add", "clear");
        if ((command.getName().equalsIgnoreCase("WorldListTrashCan") || command.getName().equalsIgnoreCase("wtc")) && args.length == 1) {
            String partial = args[0].toLowerCase();
            for (String subCommand : allSubCommands) {
                if (!subCommand.toLowerCase().startsWith(partial)) continue;
                completions.add(subCommand.toLowerCase());
            }
        }
        return completions;
    }

    public void onEnable() {
        int pluginId = 24350;
        Metrics metrics = new Metrics((Plugin)this, pluginId);
        metrics.addCustomChart(new Metrics.SingleLineChart("players", () -> Bukkit.getOnlinePlayers().size()));
        metrics.addCustomChart(new Metrics.SingleLineChart("servers", () -> 1));
        metrics.addCustomChart(new Metrics.MultiLineChart("players_and_servers", () -> {
            HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
            valueMap.put("servers", 1);
            valueMap.put("players", Bukkit.getOnlinePlayers().size());
            return valueMap;
        }));
        main = this;
        worldListTrashCan = this;
        Bukkit.getPluginManager().registerEvents((Listener)new TrashListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new GuiListener(), (Plugin)this);
        IsVersion.IsFoliaServer = Method.AutoCheckFoliaServer();
        Method.hasEnemyClass = Method.isClassPresent("org.bukkit.entity.Enemy");
        IsVersion.IsPaperServer = Method.AutoCheckPaperServer();
        IsVersion.Is1_12_1_16Server = IsVersion.isServerVersionLowerThan("1.16.0");
        IsVersion.Is1_16_1_20Server = !IsVersion.isServerVersionLowerThan("1.16.0");
        IsVersion.Is1_21_1_21_XServer = !IsVersion.isServerVersionLowerThan("1.21.0");
        IsVersion.Is1_21_1_21_5Server = !IsVersion.isServerVersionLowerThan("1.21.0") && IsVersion.isServerVersionLowerThan("1.21.6");
        boolean bl = IsVersion.Is1_21_5_21_NServer = !IsVersion.isServerVersionLowerThan("1.21.5");
        if (!this.setupEconomy()) {
            message.consoleSay("&c\u6ca1\u6709\u627e\u5230Vault\u63d2\u4ef6\uff0c\u5df2\u81ea\u52a8\u5173\u95ed\u76f8\u5173\u529f\u80fd");
        } else {
            EconomyFlag = true;
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            papi = new Papi(this);
            papi.register();
        } else {
            message.consoleSay("&c\u6ca1\u6709\u627e\u5230PlaceholderAPI\u63d2\u4ef6\uff0c\u5df2\u81ea\u52a8\u5173\u95ed\u76f8\u5173\u529f\u80fd");
        }
        this.reload();
        sendMessageAbstract = new SendMessageAbstract((JavaPlugin)main);
        LimitMain limitMain = new LimitMain();
        Bukkit.getPluginManager().registerEvents((Listener)limitMain, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)this.bukkitPlayerMoveEvent, (Plugin)this);
        if (Method.AutoCheckEntityMoveEventServer()) {
            Bukkit.getPluginManager().registerEvents((Listener)this.paperEntityMoveEvent, (Plugin)this);
        } else {
            if (bukkitClearGatherEntityTask != null) {
                bukkitClearGatherEntityTask.Stop();
            }
            bukkitClearGatherEntityTask = new BukkitClearGatherEntityTask();
            bukkitClearGatherEntityTask.Start();
        }
    }

    public boolean onCommand(final CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("WorldListTrashCan") || command.getName().equalsIgnoreCase("WTC")) {
            if (args.length == 0) {
                sender.sendMessage(org.bukkit.ChatColor.GREEN + "WorldListTrashCan " + org.bukkit.ChatColor.BLUE + " \u4f5c\u8005QQ\uff1a2831508831");
                sender.sendMessage(org.bukkit.ChatColor.YELLOW + "/WorldListTrashCan help" + org.bukkit.ChatColor.BLUE + " \u5e2e\u52a9");
            } else if (args[0].equalsIgnoreCase("reload")) {
                if (sender.isOp()) {
                    this.reload();
                    sender.sendMessage(message.find("ReloadInformation"));
                }
            } else if (args[0].equalsIgnoreCase("clear")) {
                if (sender.isOp()) {
                    if (this.foliaClearItemsTask != null) {
                        this.foliaClearItemsTask.Stop();
                        this.foliaClearItemsTask = new FoliaClearItemsTask(0);
                        Bukkit.getAsyncScheduler().runNow(main, this.foliaClearItemsTask.getFoliaRunnable());
                    }
                    if (this.clearItemsTask != null) {
                        this.clearItemsTask.Stop();
                        this.clearItemsTask = new ClearItemsTask(0);
                        this.clearItemsTask.getBukkitRunnable().run();
                    }
                    if (IsVersion.IsFoliaServer) {
                        this.foliaClearItemsTask = new FoliaClearItemsTask(main.getConfig().getInt("Set.SecondCount"));
                        this.foliaClearItemsTask.Start();
                    } else {
                        this.clearItemsTask = new ClearItemsTask(main.getConfig().getInt("Set.SecondCount"));
                        this.clearItemsTask.Start();
                    }
                }
            } else if (args[0].equalsIgnoreCase("help")) {
                if (sender.hasPermission("WorldListTrashCan.help") || sender.isOp()) {
                    for (String string : message.getConfig().getStringList("HelpTitle")) {
                        sender.sendMessage(message.color(string));
                    }
                } else {
                    sender.sendMessage(message.find("NotHavePermission").replace("%permission%", "WorldListTrashCan.help"));
                }
            } else if (args[0].equalsIgnoreCase("Ban")) {
                if (sender instanceof Player) {
                    if (sender.hasPermission("WorldListTrashCan.BanGui") || sender.isOp()) {
                        final Player player = ((Player)sender).getPlayer();
                        PlayerToWorld.put(player, player.getWorld());
                        sender.sendMessage(message.find("SecondCountdown"));
                        if (IsVersion.IsFoliaServer) {
                            ScheduledTask string = player.getScheduler().runDelayed(main, (Consumer)new Consumer<ScheduledTask>(){

                                @Override
                                public void accept(ScheduledTask scheduledTask) {
                                    if (PlayerToWorld.get(player) != null) {
                                        PlayerToWorld.remove(player);
                                        sender.sendMessage(message.find("SecondCountdownEnd"));
                                    }
                                }
                            }, () -> message.consoleSay("Error,Player is null"), 60L);
                        } else {
                            new BukkitRunnable(){
                                int count = 0;

                                public void run() {
                                    if (this.count > 3) {
                                        if (PlayerToWorld.get(player) != null) {
                                            PlayerToWorld.remove(player);
                                            sender.sendMessage(message.find("SecondCountdownEnd"));
                                        }
                                        this.cancel();
                                    }
                                    ++this.count;
                                }
                            }.runTaskTimer((Plugin)this, 0L, 60L);
                        }
                    } else {
                        sender.sendMessage(message.find("NotHavePermission").replace("%permission%", "WorldListTrashCan.BanGui"));
                    }
                } else {
                    sender.sendMessage(message.find("NotIsPlayer"));
                }
            } else if (args[0].equalsIgnoreCase("GlobalBan")) {
                if (sender instanceof Player) {
                    if (sender.hasPermission("WorldListTrashCan.GlobalBan") || sender.isOp()) {
                        Player player = ((Player)sender).getPlayer();
                        Inventory inventory = new BanGui().getGlobalInventory(player);
                        player.openInventory(inventory);
                    } else {
                        sender.sendMessage(message.find("NotHavePermission").replace("%permission%", "WorldListTrashCan.GlobalBan"));
                    }
                } else {
                    sender.sendMessage(message.find("NotIsPlayer"));
                }
            } else if (args[0].equalsIgnoreCase("PlayerTrash")) {
                if (sender instanceof Player) {
                    if (sender.hasPermission("WorldListTrashCan.PlayerTrash") || sender.isOp()) {
                        Player player = ((Player)sender).getPlayer();
                        Inventory inventory = this.autoTrashListener.getPlayerToInventory().get(player);
                        if (inventory == null) {
                            inventory = AutoTrashListener.InitPlayerInv(player);
                            this.autoTrashListener.getPlayerToInventory().put(player, inventory);
                        }
                        player.openInventory(inventory);
                    } else {
                        sender.sendMessage(message.find("NotHavePermission").replace("%permission%", "WorldListTrashCan.PlayerTrash"));
                    }
                } else {
                    sender.sendMessage(message.find("NotIsPlayer"));
                }
            } else if (args[0].equalsIgnoreCase("GlobalTrash") || args[0].equalsIgnoreCase("Trash")) {
                if (sender instanceof Player) {
                    if (sender.hasPermission("WorldListTrashCan.GlobalTrashOpen") || sender.isOp()) {
                        Player player = ((Player)sender).getPlayer();
                        Inventory inventory = globalTrashGui.getInventory();
                        player.openInventory(inventory);
                    } else {
                        sender.sendMessage(message.find("NotHavePermission").replace("%permission%", "WorldListTrashCan.GlobalTrashOpen"));
                    }
                } else {
                    sender.sendMessage(message.find("NotIsPlayer"));
                }
            } else if (args[0].equalsIgnoreCase("DropMode")) {
                if (!this.getConfig().getBoolean("DropItemCheck.Flag")) {
                    return true;
                }
                if (sender instanceof Player) {
                    if (sender.hasPermission("WorldListTrashCan.GlobalTrashOpen") || sender.isOp()) {
                        Player player = ((Player)sender).getPlayer();
                        if (DropLimitListener.PlayerDropList.contains(player)) {
                            DropLimitListener.PlayerDropList.remove(player);
                            player.sendMessage(message.find("OffDropMode"));
                        } else {
                            DropLimitListener.PlayerDropList.add(player);
                            player.sendMessage(message.find("OpenDropMode"));
                        }
                    } else {
                        sender.sendMessage(message.find("NotHavePermission").replace("%permission%", "WorldListTrashCan.DropMode"));
                    }
                } else {
                    sender.sendMessage(message.find("NotIsPlayer"));
                }
            } else if (args[0].equalsIgnoreCase("look")) {
                if (sender instanceof Player) {
                    if (sender.hasPermission("WorldListTrashCan.Look") || sender.isOp()) {
                        Player player = ((Player)sender).getPlayer();
                        UseEntityBarPlayerList.add(player);
                        message.consoleSay((CommandSender)player, message.find("ChunkEntityList"));
                        Entity[] entities = player.getLocation().getChunk().getEntities();
                        HashMap<String, Integer> entityMap = new HashMap<String, Integer>();
                        for (Entity entity : entities) {
                            if (entityMap.containsKey(entity.getName())) {
                                entityMap.put(entity.getName(), (Integer)entityMap.get(entity.getName()) + 1);
                                continue;
                            }
                            entityMap.put(entity.getName(), 1);
                        }
                        for (String typename : entityMap.keySet()) {
                            TextComponent clipboardMessage = new TextComponent("- " + typename + ((Integer)entityMap.get(typename) == 1 ? "" : " *" + entityMap.get(typename)));
                            clipboardMessage.setColor(ChatColor.GREEN);
                            clipboardMessage.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, typename));
                            player.spigot().sendMessage((BaseComponent)clipboardMessage);
                        }
                        String itemStr = player.getInventory().getItemInMainHand().getType().toString();
                        TextComponent clipboardMessage = new TextComponent(message.find("HandItem").replace("%item%", itemStr));
                        clipboardMessage.setColor(ChatColor.GREEN);
                        clipboardMessage.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, itemStr));
                        player.spigot().sendMessage((BaseComponent)clipboardMessage);
                        player.sendMessage(message.find("PleaseRightEntity"));
                    } else {
                        sender.sendMessage(message.find("NotHavePermission").replace("%permission%", "WorldListTrashCan.Look"));
                    }
                } else {
                    sender.sendMessage(message.find("NotIsPlayer"));
                }
            } else if (args[0].equalsIgnoreCase("add")) {
                if (args.length > 2) {
                    if (sender.isOp()) {
                        World world = Bukkit.getWorld((String)args[1]);
                        if (world != null) {
                            try {
                                int inputCount = Integer.parseInt(args[2]);
                                int count = data.RashMaxCountAdd(world, inputCount);
                                sender.sendMessage(message.find("AddRashMaxCountTrue").replace("%world%", world.getName()).replace("%count%", count + ""));
                            }
                            catch (Exception e) {
                                sender.sendMessage(message.find("NotInt"));
                            }
                        } else {
                            sender.sendMessage(message.find("NotFindWorld"));
                        }
                    } else {
                        sender.sendMessage(message.find("NotIsOp"));
                    }
                } else if (args.length > 1) {
                    if (sender instanceof Player) {
                        Player player = ((Player)sender).getPlayer();
                        World world = player.getWorld();
                        try {
                            int inputCount = Integer.parseInt(args[1]);
                            int count = data.RashMaxCountAdd(world, inputCount);
                            sender.sendMessage(message.find("AddRashMaxCountTrue").replace("%world%", world.getName()).replace("%count%", count + ""));
                        }
                        catch (Exception e) {
                            sender.sendMessage(message.find("NotInt"));
                        }
                    } else {
                        sender.sendMessage(message.find("NotInputArgAdd"));
                        sender.sendMessage(message.find("WorldListTrashCanAdd"));
                    }
                } else {
                    sender.sendMessage(message.find("WorldListTrashCanAdd"));
                }
            } else {
                sender.sendMessage(org.bukkit.ChatColor.GREEN + "WorldListTrashCan " + org.bukkit.ChatColor.BLUE + "\u4f5c\u8005QQ\uff1a2831508831");
                sender.sendMessage(org.bukkit.ChatColor.YELLOW + "/WorldListTrashCan help" + org.bukkit.ChatColor.BLUE + "\u63d2\u4ef6\u5e2e\u52a9");
            }
        }
        return true;
    }

    public void onDisable() {
        bossBar.removeAll();
    }

    public void reload() {
        bossBar.removeAll();
        this.saveDefaultConfig();
        this.reloadConfig();
        message.ConfigStringReplace((ConfigurationSection)this.getConfig());
        message.AllMessageLoad();
        message.chanceMessage = this.getConfig().getString("Set.Lang");
        message.reloadMessage();
        data.LoadData();
        log.logFlag = main.getConfig().getBoolean("Set.GlobalTrash.Log.Enable");
        TrashListener.GlobalItemSetString = new HashSet<String>(main.getConfig().getStringList("GlobalBanItem"));
        int MaxCount = main.getConfig().getInt("Set.GlobalTrash.MaxPage");
        globalTrashGui = new GlobalTrashGui(GlobalTrashList, MaxCount);
        if (IsVersion.IsFoliaServer) {
            if (this.foliaClearItemsTask != null) {
                this.foliaClearItemsTask.Stop();
            }
            this.foliaClearItemsTask = new FoliaClearItemsTask(main.getConfig().getInt("Set.SecondCount"));
            this.foliaClearItemsTask.Start();
        } else {
            if (this.clearItemsTask != null) {
                this.clearItemsTask.Stop();
            }
            this.clearItemsTask = new ClearItemsTask(main.getConfig().getInt("Set.SecondCount"));
            this.clearItemsTask.Start();
        }
        GlobalTrashGuiFlag = this.getConfig().getBoolean("Set.GlobalTrash.Flag");
        if (this.getConfig().getBoolean("SimpleOptimize.NotPickArrow")) {
            HandlerList.unregisterAll((Listener)this.notPickArrowListener);
            Bukkit.getPluginManager().registerEvents((Listener)this.notPickArrowListener, (Plugin)this);
        } else {
            HandlerList.unregisterAll((Listener)this.notPickArrowListener);
        }
        if (this.getConfig().getBoolean("SimpleOptimize.NotTreadingFarmLand")) {
            HandlerList.unregisterAll((Listener)this.treadingFarmLandListener);
            Bukkit.getPluginManager().registerEvents((Listener)this.treadingFarmLandListener, (Plugin)this);
        } else {
            HandlerList.unregisterAll((Listener)this.treadingFarmLandListener);
        }
        if (this.getConfig().getBoolean("ChatSet.QuickSendMessage.Flag")) {
            HandlerList.unregisterAll((Listener)this.quickSpeakListener);
            this.quickSpeakListener.Init();
            Bukkit.getPluginManager().registerEvents((Listener)this.quickSpeakListener, (Plugin)this);
        } else {
            HandlerList.unregisterAll((Listener)this.quickSpeakListener);
        }
        if (this.getConfig().getBoolean("ChatSet.QuickUseCommand.Flag")) {
            HandlerList.unregisterAll((Listener)this.quickUseCommandListener);
            this.quickUseCommandListener.Init();
            Bukkit.getPluginManager().registerEvents((Listener)this.quickUseCommandListener, (Plugin)this);
        } else {
            HandlerList.unregisterAll((Listener)this.quickUseCommandListener);
        }
        if (this.getConfig().getBoolean("DropItemCheck.Flag")) {
            HandlerList.unregisterAll((Listener)this.dropLimitListener);
            Bukkit.getPluginManager().registerEvents((Listener)this.dropLimitListener, (Plugin)this);
        } else {
            HandlerList.unregisterAll((Listener)this.dropLimitListener);
        }
        String OriginPath = "Set.PersonalTrashCan.OriginalFeatureClearItemAddGlobalTrash";
        AutoTrashListener.OriginalFeatureClearItemAddGlobalTrashModel = main.getConfig().getInt(OriginPath + ".UseModel");
        AutoTrashListener.NoWorldTrashCanEnterPersonalTrashCan = main.getConfig().getBoolean("Set.PersonalTrashCan.NoWorldTrashCanEnterPersonalTrashCan");
        if (AutoTrashListener.NoWorldTrashCanEnterPersonalTrashCan.booleanValue()) {
            HandlerList.unregisterAll((Listener)this.heightVersionPlayerDropItemListener);
            Bukkit.getPluginManager().registerEvents((Listener)this.heightVersionPlayerDropItemListener, (Plugin)this);
        } else {
            HandlerList.unregisterAll((Listener)this.heightVersionPlayerDropItemListener);
        }
        if (main.getConfig().getBoolean("Set.PersonalTrashCan.Flag")) {
            HandlerList.unregisterAll((Listener)this.autoTrashListener);
            Bukkit.getPluginManager().registerEvents((Listener)this.autoTrashListener, (Plugin)this);
        } else {
            HandlerList.unregisterAll((Listener)this.autoTrashListener);
        }
        this.autoTrashListener = new AutoTrashListener();
        Bukkit.getPluginManager().registerEvents((Listener)this.autoTrashListener, (Plugin)this);
        this.LoadWorldLimitEntityConfig();
        NoClearContainerLore = main.getConfig().getStringList("Set.NoClearContainerLore");
        NoClearContainerName = main.getConfig().getStringList("Set.NoClearContainerName");
        NoClearContainerType = main.getConfig().getStringList("Set.NoClearContainerType");
    }

    public void LoadWorldLimitEntityConfig() {
        int limit;
        Object entityType;
        String[] strings;
        if (!LimitMain.worldLimits.isEmpty()) {
            LimitMain.worldLimits.clear();
        }
        LimitMain.WorldLimitFlag = main.getConfig().getBoolean("WorldEntityLimitCount.Flag");
        LimitMain.GatherLimitFlag = main.getConfig().getBoolean("GatherEntityLimitCount.Flag");
        if (LimitMain.WorldLimitFlag) {
            LimitMain.BanWorlds = new ArrayList<String>();
            for (String EntityToCountStr : main.getConfig().getStringList("WorldEntityLimitCount.DefaultCount")) {
                strings = EntityToCountStr.split(";");
                entityType = LimitMain.getEntityType(strings[0]);
                if (entityType == null) {
                    message.consoleSay(message.find("EntityCountSetError").replace("%EntityName%", strings[0]).replace("%EntityTypes%", LimitMain.getEntityTypes()));
                    continue;
                }
                limit = Integer.parseInt(strings[1]);
                LimitMain.worldLimits.put(entityType.name().toLowerCase(), limit);
                message.consoleSay(message.find("EntityCountSetOK").replace("%Count%", limit + "").replace("%Entity%", entityType.name()));
            }
            LimitMain.BanWorlds.addAll(main.getConfig().getStringList("WorldEntityLimitCount.BanWorldNameList"));
        }
        if (LimitMain.GatherLimitFlag) {
            LimitMain.GatherBanWorlds = new ArrayList<String>();
            for (String EntityToCountStrAndLimitRange : main.getConfig().getStringList("GatherEntityLimitCount.DefaultCount")) {
                strings = EntityToCountStrAndLimitRange.split(";");
                entityType = strings[0].toUpperCase();
                if (entityType == null) continue;
                limit = Integer.parseInt(strings[1]);
                int range = Integer.parseInt(strings[2]);
                int clearCount = Integer.parseInt(strings[3]);
                LimitMain.GatherLimits.put((String)entityType, new int[]{limit, range, clearCount});
            }
            LimitMain.GatherBanWorlds.addAll(main.getConfig().getStringList("GatherEntityLimitCount.BanWorldNameList"));
            removeEntity.ItemDropFlag = main.getConfig().getBoolean("GatherEntityLimitCount.ItemDropFlag");
        }
    }

    public static Economy getEcon() {
        return econ;
    }

    public boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        econ = (Economy)rsp.getProvider();
        return econ != null;
    }

    static {
        bossBar = Bukkit.createBossBar((String)"default", (BarColor)BarColor.BLUE, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        GlobalTrashList = new ArrayList<Inventory>();
        papi = null;
        EconomyFlag = false;
        WorldToLocation = new HashMap<World, RashCanInformation>();
        UseEntityBarPlayerList = new ArrayList<Player>();
        PlayerToWorld = new HashMap<Player, World>();
        GlobalTrashGuiFlag = false;
        NoClearContainerLore = new ArrayList<String>();
        NoClearContainerName = new ArrayList<String>();
        NoClearContainerType = new ArrayList<String>();
        econ = null;
    }
}

