/*
 * Decompiled with CFR 0.152.
 */
package com.epic_engine;

import com.epic_engine.config.EpicEngineCustomConfig;
import com.epic_engine.init.EpicEngineModItems;
import com.epic_engine.init.EpicEngineModSounds;
import com.epic_engine.init.EpicEngineModTabs;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="epic_engine")
public class EpicEngineMod {
    public static final String MODID = "epic_engine";
    public static final Logger LOGGER = LogManager.getLogger();
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("epic_engine", "epic_engine"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;

    public EpicEngineMod() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        EpicEngineModTabs.REGISTRY.register(modBus);
        EpicEngineModSounds.REGISTRY.register(modBus);
        EpicEngineModItems.REGISTRY.register(modBus);
        modBus.addListener(this::onCommonSetup);
        modBus.addListener(this::onConfigReload);
        if (FMLEnvironment.dist.isClient()) {
            modBus.addListener(this::onClientSetup);
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        LOGGER.info("[EPIC ENGINE]: Core initialized");
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            this.initNetworking();
            LOGGER.info("[EPIC ENGINE]: Common setup complete");
        });
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            try {
                EpicEngineCustomConfig.initializeResources();
                LOGGER.info("[EPIC ENGINE]: Client resources initialized");
            }
            catch (Exception e) {
                LOGGER.error("[EPIC ENGINE]: Failed to initialize client resources", (Throwable)e);
            }
        });
    }

    private void onConfigReload(ModConfigEvent event) {
        if (!event.getConfig().getModId().equals(MODID)) {
            return;
        }
        LOGGER.info("[EPIC ENGINE]: Config reloading - {}", (Object)event.getConfig().getFileName());
        if (event.getConfig().getSpec() == EpicEngineCustomConfig.CONFIG && FMLEnvironment.dist.isClient()) {
            try {
                EpicEngineCustomConfig.initializeResources();
                LOGGER.info("[EPIC ENGINE]: Client resources reloaded");
            }
            catch (Exception e) {
                LOGGER.error("[EPIC ENGINE]: Failed to reinitialize resources", (Throwable)e);
            }
        }
    }

    private void initNetworking() {
        EpicEngineMod.addNetworkMessage(ConfigSyncPacket.class, ConfigSyncPacket::encode, ConfigSyncPacket::decode, ConfigSyncPacket::handle);
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && (player = (ServerPlayer)player2).m_20194_() != null && !player.m_20194_().m_129792_()) {
            EpicEngineMod.syncConfigToPlayer(player);
        }
    }

    @SubscribeEvent
    public void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        if (FMLEnvironment.dist.isClient()) {
            EpicEngineCustomConfig.restoreLocalConfig();
            EpicEngineCustomConfig.initializeResources();
            LOGGER.info("[EPIC ENGINE]: Restored local config after leaving server");
        }
    }

    public static void syncConfigToPlayer(ServerPlayer player) {
        try {
            boolean enabled = (Boolean)EpicEngineCustomConfig.PRESET_COMMANDS_ENABLED.get();
            String commands = (String)EpicEngineCustomConfig.PRESET_COMMANDS_LIST.get();
            int delay = (Integer)EpicEngineCustomConfig.PRESET_COMMANDS_DELAY.get();
            ConfigSyncPacket packet = new ConfigSyncPacket(enabled, commands, delay);
            PACKET_HANDLER.sendTo((Object)packet, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            LOGGER.info("[EPIC ENGINE]: Server config sent to {}: enabled={}, {} commands", (Object)player.m_7755_().getString(), (Object)enabled, (Object)(commands != null && !commands.isBlank() ? commands.split(";").length : 0));
        }
        catch (Exception e) {
            LOGGER.error("[EPIC ENGINE]: Failed to sync config to player: {}", (Object)player.m_7755_().getString(), (Object)e);
        }
    }

    public static <T> void addNetworkMessage(Class<T> type, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> handler) {
        PACKET_HANDLER.registerMessage(messageID++, type, encoder, decoder, handler);
    }

    public static class ConfigSyncPacket {
        private boolean presetCommandsEnabled;
        private String presetCommandsList;
        private int presetCommandsDelay;

        public ConfigSyncPacket() {
        }

        public ConfigSyncPacket(boolean enabled, String commands, int delay) {
            this.presetCommandsEnabled = enabled;
            this.presetCommandsList = commands != null ? commands : "";
            this.presetCommandsDelay = delay;
        }

        public void encode(FriendlyByteBuf buffer) {
            buffer.writeBoolean(this.presetCommandsEnabled);
            buffer.m_130070_(this.presetCommandsList);
            buffer.writeInt(this.presetCommandsDelay);
        }

        public static ConfigSyncPacket decode(FriendlyByteBuf buffer) {
            return new ConfigSyncPacket(buffer.readBoolean(), buffer.m_130277_(), buffer.readInt());
        }

        public void handle(Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                if (FMLEnvironment.dist.isClient()) {
                    EpicEngineCustomConfig.overrideFromServer(this.presetCommandsEnabled, this.presetCommandsList, this.presetCommandsDelay);
                    LOGGER.info("[EPIC ENGINE]: Client config overridden by server - commands enabled: {}, {} commands", (Object)this.presetCommandsEnabled, (Object)(this.presetCommandsList != null && !this.presetCommandsList.isBlank() ? this.presetCommandsList.split(";").length : 0));
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

