/*
 * Decompiled with CFR 0.152.
 */
package com.epic_engine.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EpicEngineCustomConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ForgeConfigSpec CONFIG;
    private static final Path EPIC_ENGINE_DIR;
    private static final Path CUSTOM_DIR;
    private static final Path TEXTURES_DIR;
    private static boolean isOverriddenByServer;
    private static boolean serverPresetCommandsEnabled;
    private static String serverPresetCommandsList;
    private static int serverPresetCommandsDelay;
    public static final ForgeConfigSpec.BooleanValue ENABLE_CUSTOMIZATION;
    public static final ForgeConfigSpec.BooleanValue WINDOW_MODULE_ENABLED;
    public static final ForgeConfigSpec.BooleanValue WINDOW_TITLE_ENABLED;
    public static final ForgeConfigSpec.ConfigValue<String> WINDOW_TITLE_TEXT;
    public static final ForgeConfigSpec.BooleanValue WINDOW_ICON_ENABLED;
    public static final ForgeConfigSpec.ConfigValue<String> WINDOW_ICON_16_FILENAME;
    public static final ForgeConfigSpec.ConfigValue<String> WINDOW_ICON_32_FILENAME;
    public static final ForgeConfigSpec.BooleanValue MAIN_MENU_MODULE_ENABLED;
    public static final ForgeConfigSpec.BooleanValue MAIN_MENU_BACKGROUND_ENABLED;
    public static final ForgeConfigSpec.ConfigValue<String> MAIN_MENU_BACKGROUND_FILENAME;
    public static final ForgeConfigSpec.BooleanValue MAIN_MENU_TITLE_ENABLED;
    public static final ForgeConfigSpec.ConfigValue<String> MAIN_MENU_TITLE_FILENAME;
    public static final ForgeConfigSpec.BooleanValue OTHERS_MODULE_ENABLED;
    public static final ForgeConfigSpec.BooleanValue PRESET_COMMANDS_ENABLED;
    public static final ForgeConfigSpec.ConfigValue<String> PRESET_COMMANDS_LIST;
    public static final ForgeConfigSpec.IntValue PRESET_COMMANDS_DELAY;

    public static void overrideFromServer(boolean enabled, String commands, int delay) {
        isOverriddenByServer = true;
        serverPresetCommandsEnabled = enabled;
        serverPresetCommandsList = commands != null ? commands : "";
        serverPresetCommandsDelay = delay;
        LOGGER.info("[EPIC ENGINE]: Config overridden by server - enabled: {}, delay: {}ms, {} commands", (Object)enabled, (Object)(delay * 50), (Object)(commands != null && !commands.isBlank() ? commands.split(";").length : 0));
    }

    public static void restoreLocalConfig() {
        if (isOverriddenByServer) {
            isOverriddenByServer = false;
            serverPresetCommandsEnabled = false;
            serverPresetCommandsList = "";
            serverPresetCommandsDelay = 20;
            LOGGER.info("[EPIC ENGINE]: Restored local config");
        }
    }

    public static boolean getEffectivePresetCommandsEnabled() {
        return isOverriddenByServer ? serverPresetCommandsEnabled : (Boolean)PRESET_COMMANDS_ENABLED.get();
    }

    public static String getEffectivePresetCommandsList() {
        return isOverriddenByServer ? serverPresetCommandsList : (String)PRESET_COMMANDS_LIST.get();
    }

    public static int getEffectivePresetCommandsDelay() {
        return isOverriddenByServer ? serverPresetCommandsDelay : (Integer)PRESET_COMMANDS_DELAY.get();
    }

    public static boolean isOverriddenByServer() {
        return isOverriddenByServer;
    }

    public static String getConfigSource() {
        return isOverriddenByServer ? "SERVER" : "LOCAL";
    }

    public static void initializeResources() {
        EpicEngineCustomConfig.createDirectories();
        try {
            EpicEngineCustomConfig.copyResourceDirectory("assets/epic_engine/custom", CUSTOM_DIR);
            LOGGER.info("[EPIC ENGINE]: Default resources extracted to {}", (Object)CUSTOM_DIR);
        }
        catch (Exception e) {
            LOGGER.error("[EPIC ENGINE]: Failed to extract default resources", (Throwable)e);
        }
    }

    public static File getTextureFile(String filename) {
        return TEXTURES_DIR.resolve(filename).toFile();
    }

    public static boolean isWindowTitleEnabled() {
        try {
            return (Boolean)ENABLE_CUSTOMIZATION.get() != false && (Boolean)WINDOW_MODULE_ENABLED.get() != false && (Boolean)WINDOW_TITLE_ENABLED.get() != false;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public static boolean isWindowIconEnabled() {
        try {
            return (Boolean)ENABLE_CUSTOMIZATION.get() != false && (Boolean)WINDOW_MODULE_ENABLED.get() != false && (Boolean)WINDOW_ICON_ENABLED.get() != false;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public static String getWindowTitle() {
        return EpicEngineCustomConfig.isWindowTitleEnabled() ? (String)WINDOW_TITLE_TEXT.get() : null;
    }

    public static boolean isMainMenuBackgroundEnabled() {
        try {
            return (Boolean)ENABLE_CUSTOMIZATION.get() != false && (Boolean)MAIN_MENU_MODULE_ENABLED.get() != false && (Boolean)MAIN_MENU_BACKGROUND_ENABLED.get() != false;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public static boolean isMainMenuTitleEnabled() {
        try {
            return (Boolean)ENABLE_CUSTOMIZATION.get() != false && (Boolean)MAIN_MENU_MODULE_ENABLED.get() != false && (Boolean)MAIN_MENU_TITLE_ENABLED.get() != false;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    private static void createDirectories() {
        try {
            Files.createDirectories(TEXTURES_DIR, new FileAttribute[0]);
            LOGGER.debug("[EPIC ENGINE]: Resource directories created or already exist");
        }
        catch (IOException e) {
            LOGGER.error("[EPIC ENGINE]: Failed to create resource directories", (Throwable)e);
        }
    }

    private static void copyResourceDirectory(String resourcePath, Path targetDir) throws IOException, URISyntaxException {
        URL url = EpicEngineCustomConfig.class.getClassLoader().getResource(resourcePath);
        if (url == null) {
            LOGGER.warn("[EPIC ENGINE]: Resource folder not found: {}", (Object)resourcePath);
            return;
        }
        URI uri = url.toURI();
        switch (uri.getScheme()) {
            case "file": {
                Path base = Paths.get(uri);
                EpicEngineCustomConfig.walkAndCopy(base, base, targetDir);
                break;
            }
            case "jar": {
                try (FileSystem fs = FileSystems.newFileSystem(uri, Map.of());){
                    Path jarPath = fs.getPath(resourcePath, new String[0]);
                    EpicEngineCustomConfig.walkAndCopy(jarPath, jarPath, targetDir);
                    break;
                }
            }
            case "union": {
                Path base = Paths.get(uri);
                EpicEngineCustomConfig.walkAndCopy(base, base, targetDir);
                break;
            }
            default: {
                LOGGER.warn("[EPIC ENGINE]: Unsupported URI scheme: {}", (Object)uri.getScheme());
            }
        }
    }

    private static void walkAndCopy(Path start, Path base, Path targetBase) throws IOException {
        try (Stream<Path> stream = Files.walk(start, new FileVisitOption[0]);){
            stream.forEach(source -> EpicEngineCustomConfig.copyPath(source, base, targetBase));
        }
    }

    private static void copyPath(Path source, Path base, Path targetBase) {
        block10: {
            try {
                Path relative = base.relativize(source);
                Path target = targetBase.resolve(relative.toString());
                if (Files.isDirectory(source, new LinkOption[0])) {
                    Files.createDirectories(target, new FileAttribute[0]);
                    break block10;
                }
                if (!Files.notExists(target, new LinkOption[0])) break block10;
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                try (InputStream in = EpicEngineCustomConfig.class.getClassLoader().getResourceAsStream(base.resolve(relative).toString());){
                    if (in != null) {
                        Files.copy(in, target, new CopyOption[0]);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("[EPIC ENGINE]: Error copying resource {} -> {}", (Object)source, (Object)targetBase, (Object)e);
            }
        }
    }

    static {
        EPIC_ENGINE_DIR = FMLPaths.CONFIGDIR.get().resolve("epic_engine");
        CUSTOM_DIR = EPIC_ENGINE_DIR.resolve("custom");
        TEXTURES_DIR = CUSTOM_DIR.resolve("textures");
        isOverriddenByServer = false;
        serverPresetCommandsEnabled = false;
        serverPresetCommandsList = "";
        serverPresetCommandsDelay = 20;
        EpicEngineCustomConfig.createDirectories();
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment(new String[]{"Epic Engine Configuration", "Control all customization features of Epic Engine"}).push("epic_engine");
        ENABLE_CUSTOMIZATION = builder.comment("Master switch for all Epic Engine features").define("enableCustomization", true);
        builder.comment(new String[]{"Window Customization Module", "Customize game window appearance"}).push("window_customization");
        WINDOW_MODULE_ENABLED = builder.comment("Enable window customization module").define("moduleEnabled", true);
        builder.comment("Window Title Settings").push("title");
        WINDOW_TITLE_ENABLED = builder.comment("Enable custom window title").define("enabled", true);
        WINDOW_TITLE_TEXT = builder.comment("Custom window title text").define("text", (Object)"Epic Engine: A good tool to make your modpack!");
        builder.pop();
        builder.comment("Window Icon Settings").push("icon");
        WINDOW_ICON_ENABLED = builder.comment("Enable custom window icon").define("enabled", true);
        WINDOW_ICON_16_FILENAME = builder.comment("Small icon filename (16\u00d716) in config/epic_engine/custom/textures/").define("icon16", (Object)"icon16.png");
        WINDOW_ICON_32_FILENAME = builder.comment("Large icon filename (32\u00d732) in config/epic_engine/custom/textures/").define("icon32", (Object)"icon32.png");
        builder.pop();
        builder.pop();
        builder.comment(new String[]{"Main Menu Customization Module", "Customize main menu appearance"}).push("main_menu_customization");
        MAIN_MENU_MODULE_ENABLED = builder.comment("Enable main menu customization module").define("moduleEnabled", true);
        builder.comment("Background Settings").push("background");
        MAIN_MENU_BACKGROUND_ENABLED = builder.comment("Enable custom main menu background").define("enabled", true);
        MAIN_MENU_BACKGROUND_FILENAME = builder.comment("Background image filename in config/epic_engine/custom/textures/").define("filename", (Object)"background.png");
        builder.pop();
        builder.comment("Title Image Settings").push("title_image");
        MAIN_MENU_TITLE_ENABLED = builder.comment("Enable custom main menu title image").define("enabled", true);
        MAIN_MENU_TITLE_FILENAME = builder.comment("Title image filename in config/epic_engine/custom/textures/").define("filename", (Object)"title.png");
        builder.pop();
        builder.pop();
        builder.comment(new String[]{"Others Module", "Customize miscellaneous behaviors"}).push("others");
        OTHERS_MODULE_ENABLED = builder.comment("Enable others module").define("moduleEnabled", true);
        builder.comment(new String[]{"Preset Commands Settings", "Execute commands when players join (SECURITY NOTE: In multiplayer, server config overrides client config)"}).push("preset_commands");
        PRESET_COMMANDS_ENABLED = builder.comment("Enable preset commands execution").define("enabled", true);
        PRESET_COMMANDS_LIST = builder.comment(new String[]{"Commands to execute, separated by semicolons (;)", "WARNING: In multiplayer servers, only server admin can control these commands"}).define("commands", (Object)"say [EPIC ENGINE]:Welcome to Epic Engine!;xp add @a 1");
        PRESET_COMMANDS_DELAY = builder.comment("Delay in ticks before executing commands (20 ticks = 1 second)").defineInRange("delayTicks", 20, 0, 1200);
        builder.pop();
        builder.pop();
        builder.pop();
        CONFIG = builder.build();
    }
}

