/*
 * Decompiled with CFR 0.152.
 */
package com.epic_engine.event;

import com.epic_engine.config.EpicEngineCustomConfig;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class PresetCommandsHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static MinecraftServer serverInstance;
    private static final ScheduledExecutorService scheduler;

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        serverInstance = event.getServer();
        LOGGER.info("[EPIC ENGINE]: PresetCommandsHandler initialized");
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        if (!EpicEngineCustomConfig.getEffectivePresetCommandsEnabled() || !((Boolean)EpicEngineCustomConfig.OTHERS_MODULE_ENABLED.get()).booleanValue()) {
            LOGGER.debug("[EPIC ENGINE]: Preset commands disabled (config source: {})", (Object)EpicEngineCustomConfig.getConfigSource());
            return;
        }
        ServerLevel overworld = serverInstance.m_129783_();
        PresetData data = PresetCommandsHandler.getGlobalPresetData(overworld);
        if (data.hasExecuted()) {
            LOGGER.debug("[EPIC ENGINE]: Preset commands already executed for this server");
            return;
        }
        LOGGER.info("[EPIC ENGINE]: First player joined, triggering preset commands execution (config source: {})", (Object)EpicEngineCustomConfig.getConfigSource());
        PresetCommandsHandler.scheduleCommandExecution(overworld);
    }

    private static PresetData getGlobalPresetData(ServerLevel overworld) {
        return (PresetData)overworld.m_8895_().m_164861_(PresetData::load, PresetData::new, "epic_engine_global_preset_commands");
    }

    private static void scheduleCommandExecution(ServerLevel overworld) {
        int delayTicks = EpicEngineCustomConfig.getEffectivePresetCommandsDelay();
        long delayMillis = (long)delayTicks * 50L;
        scheduler.schedule(() -> {
            try {
                PresetCommandsHandler.executeGlobalPresetCommands(overworld);
            }
            catch (Exception e) {
                LOGGER.error("[EPIC ENGINE]: Error executing global preset commands", (Throwable)e);
            }
        }, delayMillis, TimeUnit.MILLISECONDS);
    }

    private static void executeGlobalPresetCommands(ServerLevel overworld) {
        String[] commands;
        if (serverInstance == null) {
            return;
        }
        if (!EpicEngineCustomConfig.getEffectivePresetCommandsEnabled() || !((Boolean)EpicEngineCustomConfig.OTHERS_MODULE_ENABLED.get()).booleanValue()) {
            LOGGER.warn("[EPIC ENGINE]: Preset commands disabled during execution, aborting (config source: {})", (Object)EpicEngineCustomConfig.getConfigSource());
            return;
        }
        PresetData data = PresetCommandsHandler.getGlobalPresetData(overworld);
        if (data.hasExecuted()) {
            LOGGER.debug("[EPIC ENGINE]: Global preset commands already executed");
            return;
        }
        String raw = EpicEngineCustomConfig.getEffectivePresetCommandsList();
        String[] stringArray = commands = raw == null || raw.isBlank() ? new String[]{} : raw.split(";");
        if (commands.length == 0) {
            data.markAsExecuted();
            LOGGER.info("[EPIC ENGINE]: No preset commands configured, marking as executed (config source: {})", (Object)EpicEngineCustomConfig.getConfigSource());
            return;
        }
        LOGGER.info("[EPIC ENGINE]: Executing {} global preset commands for server initialization (config source: {})", (Object)commands.length, (Object)EpicEngineCustomConfig.getConfigSource());
        Commands commandManager = serverInstance.m_129892_();
        CommandSourceStack source = serverInstance.m_129893_().m_81327_(overworld).m_81325_(4).m_81324_();
        AtomicInteger successCount = new AtomicInteger(0);
        for (int i = 0; i < commands.length; ++i) {
            String cmd = commands[i].trim();
            if (cmd.isEmpty()) continue;
            int commandIndex = i;
            boolean isLastCommand = i == commands.length - 1;
            String finalCmd = cmd;
            scheduler.schedule(() -> {
                block4: {
                    try {
                        LOGGER.info("[EPIC ENGINE]: Running {} command {}/{}: {}", (Object)EpicEngineCustomConfig.getConfigSource(), (Object)(commandIndex + 1), (Object)commands.length, (Object)finalCmd);
                        int result = commandManager.m_230957_(source, finalCmd);
                        if (result > 0) {
                            successCount.incrementAndGet();
                        }
                        if (isLastCommand) {
                            data.markAsExecuted();
                            LOGGER.info("[EPIC ENGINE]: Global preset commands completed: {}/{} succeeded (config source: {})", (Object)successCount.get(), (Object)commands.length, (Object)EpicEngineCustomConfig.getConfigSource());
                            LOGGER.info("[EPIC ENGINE]: Server initialization commands will not run again for this world");
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("[EPIC ENGINE]: Failed to run {} preset command: {}", (Object)EpicEngineCustomConfig.getConfigSource(), (Object)finalCmd, (Object)e);
                        if (!isLastCommand) break block4;
                        data.markAsExecuted();
                        LOGGER.info("[EPIC ENGINE]: Global preset commands completed with errors: {}/{} succeeded (config source: {})", (Object)successCount.get(), (Object)commands.length, (Object)EpicEngineCustomConfig.getConfigSource());
                    }
                }
            }, 50L * (long)commandIndex, TimeUnit.MILLISECONDS);
        }
    }

    public static void resetGlobalExecution() {
        if (serverInstance != null) {
            PresetData data = PresetCommandsHandler.getGlobalPresetData(serverInstance.m_129783_());
            data.reset();
            LOGGER.info("[EPIC ENGINE]: Global preset commands execution status reset - commands will run again");
        }
    }

    public static boolean hasGloballyExecuted() {
        if (serverInstance != null) {
            PresetData data = PresetCommandsHandler.getGlobalPresetData(serverInstance.m_129783_());
            return data.hasExecuted();
        }
        return false;
    }

    public static boolean forceExecuteCommands(ServerPlayer admin) {
        if (serverInstance == null) {
            return false;
        }
        if (!admin.m_20310_(4)) {
            LOGGER.warn("[EPIC ENGINE]: Player {} attempted to force execute preset commands without permission", (Object)admin.m_7755_().getString());
            return false;
        }
        ServerLevel overworld = serverInstance.m_129783_();
        PresetData data = PresetCommandsHandler.getGlobalPresetData(overworld);
        data.reset();
        LOGGER.info("[EPIC ENGINE]: Admin {} is forcing preset commands execution", (Object)admin.m_7755_().getString());
        PresetCommandsHandler.scheduleCommandExecution(overworld);
        return true;
    }

    public static String getExecutionStatusInfo() {
        if (serverInstance == null) {
            return "Server not available";
        }
        PresetData data = PresetCommandsHandler.getGlobalPresetData(serverInstance.m_129783_());
        StringBuilder info = new StringBuilder();
        info.append("Preset Commands Status:\n");
        info.append("- Config Source: ").append(EpicEngineCustomConfig.getConfigSource()).append("\n");
        info.append("- Enabled: ").append(EpicEngineCustomConfig.getEffectivePresetCommandsEnabled()).append("\n");
        info.append("- Commands: ").append(PresetCommandsHandler.getCommandCount()).append("\n");
        info.append("- Executed: ").append(data.hasExecuted()).append("\n");
        if (data.hasExecuted()) {
            info.append("- Execution Time: ").append(new Date(data.getExecutionTime())).append("\n");
            info.append("- Server Version: ").append(data.getServerVersion()).append("\n");
        }
        return info.toString();
    }

    private static int getCommandCount() {
        String raw = EpicEngineCustomConfig.getEffectivePresetCommandsList();
        if (raw == null || raw.isBlank()) {
            return 0;
        }
        return raw.split(";").length;
    }

    public static void shutdown() {
        LOGGER.info("[EPIC ENGINE]: Shutting down PresetCommandsHandler scheduler");
        scheduler.shutdown();
        try {
            if (!scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                LOGGER.warn("[EPIC ENGINE]: Scheduler did not terminate gracefully, forcing shutdown");
                scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("[EPIC ENGINE]: Interrupted while waiting for scheduler shutdown");
            scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    static {
        scheduler = Executors.newSingleThreadScheduledExecutor();
    }

    public static class PresetData
    extends SavedData {
        private boolean executed = false;
        private long executionTime = 0L;
        private String serverVersion = "";
        private String configSource = "";

        public PresetData() {
        }

        public PresetData(CompoundTag tag) {
            this.executed = tag.m_128471_("executed");
            this.executionTime = tag.m_128454_("execution_time");
            this.serverVersion = tag.m_128461_("server_version");
            this.configSource = tag.m_128461_("config_source");
        }

        public static PresetData load(CompoundTag tag) {
            return new PresetData(tag);
        }

        public CompoundTag m_7176_(CompoundTag tag) {
            tag.m_128379_("executed", this.executed);
            tag.m_128356_("execution_time", this.executionTime);
            tag.m_128359_("server_version", this.serverVersion);
            tag.m_128359_("config_source", this.configSource);
            return tag;
        }

        public boolean hasExecuted() {
            return this.executed;
        }

        public void markAsExecuted() {
            this.executed = true;
            this.executionTime = System.currentTimeMillis();
            this.serverVersion = serverInstance != null ? serverInstance.m_7630_() : "unknown";
            this.configSource = EpicEngineCustomConfig.getConfigSource();
            this.m_77762_();
        }

        public void reset() {
            this.executed = false;
            this.executionTime = 0L;
            this.serverVersion = "";
            this.configSource = "";
            this.m_77762_();
        }

        public long getExecutionTime() {
            return this.executionTime;
        }

        public String getServerVersion() {
            return this.serverVersion;
        }

        public String getConfigSource() {
            return this.configSource;
        }
    }
}

