/*
 * Decompiled with CFR 0.152.
 */
package com.epic_engine.mixin;

import com.epic_engine.config.EpicEngineCustomConfig;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TitleScreen.class})
public class MainMenuMixin {
    @Unique
    private static final Logger epicEngine$LOGGER = LogManager.getLogger();
    @Unique
    private static ResourceLocation epicEngine$customBackground = null;
    @Unique
    private static ResourceLocation epicEngine$customTitle = null;
    @Unique
    private static boolean epicEngine$customBackgroundLoaded = false;
    @Unique
    private static boolean epicEngine$customTitleLoaded = false;
    @Unique
    private static boolean epicEngine$resourcesProcessed = false;
    @Unique
    private static int epicEngine$titleWidth = 0;
    @Unique
    private static int epicEngine$titleHeight = 0;
    @Unique
    private static boolean epicEngine$configCached = false;
    @Unique
    private static boolean epicEngine$shouldCustomize = false;
    @Unique
    private static boolean epicEngine$backgroundEnabled = false;
    @Unique
    private static boolean epicEngine$titleEnabled = false;

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void epicEngine$onInit(CallbackInfo ci) {
        epicEngine$LOGGER.info("[EPIC ENGINE]: MainMenu init called! Mixin is working!");
        this.epicEngine$cacheConfig();
        if (!epicEngine$shouldCustomize) {
            return;
        }
        if (!epicEngine$resourcesProcessed) {
            EpicEngineCustomConfig.initializeResources();
            this.epicEngine$loadCustomResources();
            epicEngine$resourcesProcessed = true;
            epicEngine$LOGGER.info("[EPIC ENGINE]: Resources processed and cached");
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    private void epicEngine$onRenderStart(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks, CallbackInfo ci) {
        if (!epicEngine$shouldCustomize || !epicEngine$customBackgroundLoaded && !epicEngine$customTitleLoaded) {
            return;
        }
        if (epicEngine$backgroundEnabled && epicEngine$customBackgroundLoaded) {
            this.epicEngine$renderCustomBackground(guiGraphics);
        } else {
            this.epicEngine$renderOriginalBackground(guiGraphics);
        }
        ((TitleScreen)this).f_169369_.forEach(r -> r.m_88315_(guiGraphics, mouseX, mouseY, partialTicks));
        if (epicEngine$titleEnabled && epicEngine$customTitleLoaded) {
            this.epicEngine$renderCustomTitle(guiGraphics);
        }
        ci.cancel();
    }

    @Unique
    private void epicEngine$cacheConfig() {
        if (!epicEngine$configCached) {
            boolean bl = epicEngine$shouldCustomize = (Boolean)EpicEngineCustomConfig.ENABLE_CUSTOMIZATION.get() != false && (Boolean)EpicEngineCustomConfig.MAIN_MENU_MODULE_ENABLED.get() != false;
            if (epicEngine$shouldCustomize) {
                epicEngine$backgroundEnabled = (Boolean)EpicEngineCustomConfig.MAIN_MENU_BACKGROUND_ENABLED.get();
                epicEngine$titleEnabled = (Boolean)EpicEngineCustomConfig.MAIN_MENU_TITLE_ENABLED.get();
                epicEngine$shouldCustomize = epicEngine$backgroundEnabled || epicEngine$titleEnabled;
            }
            epicEngine$configCached = true;
            epicEngine$LOGGER.info("[EPIC ENGINE]: Configuration cached - customize: {}, bg: {}, title: {}", (Object)epicEngine$shouldCustomize, (Object)epicEngine$backgroundEnabled, (Object)epicEngine$titleEnabled);
        }
    }

    @Unique
    private void epicEngine$renderCustomBackground(GuiGraphics guiGraphics) {
        int sw = Minecraft.m_91087_().m_91268_().m_85445_();
        int sh = Minecraft.m_91087_().m_91268_().m_85446_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280411_(epicEngine$customBackground, 0, 0, sw, sh, 0.0f, 0.0f, 1024, 1024, 1024, 1024);
    }

    @Unique
    private void epicEngine$renderOriginalBackground(GuiGraphics guiGraphics) {
        int sw = Minecraft.m_91087_().m_91268_().m_85445_();
        int sh = Minecraft.m_91087_().m_91268_().m_85446_();
        guiGraphics.m_280024_(0, 0, sw, sh, -15790301, -15790301);
    }

    @Unique
    private void epicEngine$renderCustomTitle(GuiGraphics guiGraphics) {
        try {
            int sw = Minecraft.m_91087_().m_91268_().m_85445_();
            int sh = Minecraft.m_91087_().m_91268_().m_85446_();
            int ow = Math.max(1, epicEngine$titleWidth);
            int oh = Math.max(1, epicEngine$titleHeight);
            float scale = Math.min((float)sw * 0.8f / (float)ow, (float)sh * 0.15f / (float)oh);
            scale = Math.max(scale, 0.5f);
            int drawW = (int)((float)ow * scale);
            int x = (sw - drawW) / 2;
            int y = 30;
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)x, (float)y, 0.0f);
            guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
            guiGraphics.m_280163_(epicEngine$customTitle, 0, 0, 0.0f, 0.0f, ow, oh, ow, oh);
            guiGraphics.m_280168_().m_85849_();
        }
        catch (Exception e) {
            epicEngine$LOGGER.error("[EPIC ENGINE]: Error rendering custom title", (Throwable)e);
        }
    }

    @Unique
    private void epicEngine$loadCustomResources() {
        try {
            File titleFile;
            NativeImage img;
            File bgFile;
            if (epicEngine$backgroundEnabled && (bgFile = EpicEngineCustomConfig.getTextureFile((String)EpicEngineCustomConfig.MAIN_MENU_BACKGROUND_FILENAME.get())).exists() && bgFile.isFile() && (img = this.epicEngine$readImage(bgFile)) != null) {
                epicEngine$customBackground = new ResourceLocation("epic_engine", "custom_background");
                Minecraft.m_91087_().m_91097_().m_118495_(epicEngine$customBackground, (AbstractTexture)new DynamicTexture(img));
                epicEngine$customBackgroundLoaded = true;
                epicEngine$LOGGER.info("[EPIC ENGINE]: Custom background loaded successfully");
            }
            if (epicEngine$titleEnabled && (titleFile = EpicEngineCustomConfig.getTextureFile((String)EpicEngineCustomConfig.MAIN_MENU_TITLE_FILENAME.get())).exists() && titleFile.isFile() && (img = this.epicEngine$readImage(titleFile)) != null) {
                epicEngine$titleWidth = img.m_84982_();
                epicEngine$titleHeight = img.m_85084_();
                epicEngine$customTitle = new ResourceLocation("epic_engine", "custom_title");
                Minecraft.m_91087_().m_91097_().m_118495_(epicEngine$customTitle, (AbstractTexture)new DynamicTexture(img));
                epicEngine$customTitleLoaded = true;
                epicEngine$LOGGER.info("[EPIC ENGINE]: Custom title loaded successfully ({}x{})", (Object)epicEngine$titleWidth, (Object)epicEngine$titleHeight);
            }
        }
        catch (Exception e) {
            epicEngine$LOGGER.error("[EPIC ENGINE]: Error loading custom resources", (Throwable)e);
        }
    }

    @Unique
    private NativeImage epicEngine$readImage(File file) {
        NativeImage nativeImage;
        block8: {
            InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);
            try {
                nativeImage = NativeImage.m_85058_((InputStream)in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    epicEngine$LOGGER.error("[EPIC ENGINE]: Failed to read image: {}", (Object)file.getPath(), (Object)e);
                    return null;
                }
            }
            in.close();
        }
        return nativeImage;
    }
}

