/*
 * Decompiled with CFR 0.152.
 */
package com.epic_engine.mixin;

import com.epic_engine.config.EpicEngineCustomConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import net.minecraft.client.Minecraft;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public class TitleMixin {
    @Unique
    private static final Logger epicEngine$LOGGER = LogManager.getLogger();

    @Unique
    private void epicEngine$applyCustomTitle() {
        String title;
        Minecraft mc = (Minecraft)this;
        if (mc.m_91268_() != null && (title = EpicEngineCustomConfig.getWindowTitle()) != null && !title.isEmpty()) {
            mc.m_91268_().m_85422_(title);
            epicEngine$LOGGER.info("[EPIC ENGINE]: Custom window title applied: {}", (Object)title);
        }
    }

    @Unique
    private void epicEngine$applyCustomIcon() {
        epicEngine$LOGGER.info("[EPIC ENGINE]: Attempting to apply custom window icon");
        if (!EpicEngineCustomConfig.isWindowIconEnabled()) {
            epicEngine$LOGGER.info("[EPIC ENGINE]: Custom window icon is disabled");
            return;
        }
        Minecraft mc = (Minecraft)this;
        if (mc.m_91268_() == null) {
            epicEngine$LOGGER.warn("[EPIC ENGINE]: Window is null, cannot set icon");
            return;
        }
        try {
            File icon16 = EpicEngineCustomConfig.getTextureFile((String)EpicEngineCustomConfig.WINDOW_ICON_16_FILENAME.get());
            File icon32 = EpicEngineCustomConfig.getTextureFile((String)EpicEngineCustomConfig.WINDOW_ICON_32_FILENAME.get());
            boolean has16 = icon16.exists() && icon16.isFile();
            boolean has32 = icon32.exists() && icon32.isFile();
            epicEngine$LOGGER.info("[EPIC ENGINE]: Icon file check - 16x16: {}, 32x32: {}", (Object)has16, (Object)has32);
            if (!has16 && !has32) {
                epicEngine$LOGGER.warn("[EPIC ENGINE]: No custom window icon files found");
                return;
            }
            long windowHandle = mc.m_91268_().m_85439_();
            epicEngine$LOGGER.info("[EPIC ENGINE]: Window handle: {}", (Object)windowHandle);
            try (MemoryStack stack = MemoryStack.stackPush();){
                GLFWImage.Buffer buffer = GLFWImage.malloc((int)2, (MemoryStack)stack);
                int count = 0;
                if (has16) {
                    epicEngine$LOGGER.info("[EPIC ENGINE]: Loading 16x16 icon: {}", (Object)icon16.getAbsolutePath());
                    ByteBuffer data16 = this.epicEngine$loadIcon(icon16, stack);
                    if (data16 != null) {
                        ((GLFWImage.Buffer)buffer.position(count)).width(16).height(16).pixels(data16);
                        ++count;
                        epicEngine$LOGGER.info("[EPIC ENGINE]: 16x16 icon loaded successfully");
                    } else {
                        epicEngine$LOGGER.error("[EPIC ENGINE]: Failed to load 16x16 icon");
                    }
                }
                if (has32) {
                    epicEngine$LOGGER.info("[EPIC ENGINE]: Loading 32x32 icon: {}", (Object)icon32.getAbsolutePath());
                    ByteBuffer data32 = this.epicEngine$loadIcon(icon32, stack);
                    if (data32 != null) {
                        ((GLFWImage.Buffer)buffer.position(count)).width(32).height(32).pixels(data32);
                        ++count;
                        epicEngine$LOGGER.info("[EPIC ENGINE]: 32x32 icon loaded successfully");
                    } else {
                        epicEngine$LOGGER.error("[EPIC ENGINE]: Failed to load 32x32 icon");
                    }
                }
                if (count > 0) {
                    ((GLFWImage.Buffer)buffer.position(0)).limit(count);
                    GLFW.glfwSetWindowIcon((long)windowHandle, (GLFWImage.Buffer)buffer);
                    epicEngine$LOGGER.info("[EPIC ENGINE]: Custom window icon set successfully with {} images", (Object)count);
                } else {
                    epicEngine$LOGGER.error("[EPIC ENGINE]: No valid icon images to set");
                }
            }
        }
        catch (Exception e) {
            epicEngine$LOGGER.error("[EPIC ENGINE]: Failed to set custom window icon", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Unique
    private ByteBuffer epicEngine$loadIcon(File file, MemoryStack stack) {
        try (FileInputStream fis = new FileInputStream(file);){
            ByteBuffer byteBuffer;
            block21: {
                ByteBuffer img;
                FileChannel fc;
                block19: {
                    ByteBuffer byteBuffer2;
                    block20: {
                        IntBuffer c;
                        IntBuffer h;
                        IntBuffer w;
                        block17: {
                            ByteBuffer byteBuffer3;
                            block18: {
                                fc = fis.getChannel();
                                try {
                                    epicEngine$LOGGER.info("[EPIC ENGINE]: Reading icon file: {} (size: {} bytes)", (Object)file.getName(), (Object)fc.size());
                                    ByteBuffer buf = ByteBuffer.allocateDirect((int)fc.size());
                                    fc.read(buf);
                                    buf.flip();
                                    w = stack.mallocInt(1);
                                    h = stack.mallocInt(1);
                                    c = stack.mallocInt(1);
                                    img = STBImage.stbi_load_from_memory((ByteBuffer)buf, (IntBuffer)w, (IntBuffer)h, (IntBuffer)c, (int)4);
                                    if (img != null) break block17;
                                    String reason = STBImage.stbi_failure_reason();
                                    epicEngine$LOGGER.error("[EPIC ENGINE]: STB failed to load icon {}: {}", (Object)file.getName(), (Object)reason);
                                    byteBuffer3 = null;
                                    if (fc == null) break block18;
                                }
                                catch (Throwable throwable) {
                                    if (fc != null) {
                                        try {
                                            fc.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                fc.close();
                            }
                            return byteBuffer3;
                        }
                        int wi = w.get(0);
                        int hi = h.get(0);
                        epicEngine$LOGGER.info("[EPIC ENGINE]: Icon {} loaded: {}x{}, channels: {}", (Object)file.getName(), (Object)wi, (Object)hi, (Object)c.get(0));
                        if (wi == hi && (wi == 16 || wi == 32)) break block19;
                        int targetSize = wi <= 24 ? 16 : 32;
                        epicEngine$LOGGER.info("[EPIC ENGINE]: Scaling icon from {}x{} to {}x{}", (Object)wi, (Object)hi, (Object)targetSize, (Object)targetSize);
                        ByteBuffer scaled = this.epicEngine$scaleIcon(img, wi, hi, targetSize, targetSize);
                        STBImage.stbi_image_free((ByteBuffer)img);
                        byteBuffer2 = scaled;
                        if (fc == null) break block20;
                        fc.close();
                    }
                    return byteBuffer2;
                }
                byteBuffer = img;
                if (fc == null) break block21;
                fc.close();
            }
            return byteBuffer;
        }
        catch (IOException e) {
            epicEngine$LOGGER.error("[EPIC ENGINE]: Failed to read icon file: {}", (Object)file.getAbsolutePath(), (Object)e);
            return null;
        }
    }

    @Unique
    private ByteBuffer epicEngine$scaleIcon(ByteBuffer orig, int sw, int sh, int dw, int dh) {
        ByteBuffer dst = MemoryUtil.memAlloc((int)(dw * dh * 4));
        for (int y = 0; y < dh; ++y) {
            for (int x = 0; x < dw; ++x) {
                int sx = x * sw / dw;
                int sy = y * sh / dh;
                int si = (sy * sw + sx) * 4;
                int di = (y * dw + x) * 4;
                for (int i = 0; i < 4; ++i) {
                    dst.put(di + i, orig.get(si + i));
                }
            }
        }
        return dst;
    }

    @Inject(method={"updateTitle"}, at={@At(value="HEAD")}, cancellable=true)
    private void epicEngine$onUpdateTitle(CallbackInfo ci) {
        if (EpicEngineCustomConfig.isWindowTitleEnabled()) {
            this.epicEngine$applyCustomTitle();
            ci.cancel();
        }
    }

    @Inject(method={"<init>*"}, at={@At(value="RETURN")})
    private void epicEngine$onConstructed(CallbackInfo ci) {
        Minecraft mc = (Minecraft)this;
        mc.m_6937_(() -> {
            if (EpicEngineCustomConfig.isWindowTitleEnabled()) {
                this.epicEngine$applyCustomTitle();
            }
            if (EpicEngineCustomConfig.isWindowIconEnabled()) {
                try {
                    Thread.sleep(500L);
                    this.epicEngine$applyCustomIcon();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    epicEngine$LOGGER.warn("[EPIC ENGINE]: Icon setup interrupted");
                }
            }
        });
    }
}

