/*
 * Decompiled with CFR 0.152.
 */
package com.epic_engine;

import com.epic_engine.config.EpicEngineCustomConfig;
import com.epic_engine.config.EpicEngineWorldConfig;
import com.epic_engine.init.EpicEngineModItems;
import com.epic_engine.init.EpicEngineModSounds;
import com.epic_engine.init.EpicEngineModTabs;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="epic_engine")
public class EpicEngineMod {
    public static final String MODID = "epic_engine";
    public static final Logger LOGGER = LogManager.getLogger();
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("epic_engine", "epic_engine"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Queue<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public EpicEngineMod() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        EpicEngineModSounds.REGISTRY.register(modBus);
        EpicEngineModItems.REGISTRY.register(modBus);
        EpicEngineModTabs.REGISTRY.register(modBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)EpicEngineWorldConfig.CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)EpicEngineCustomConfig.CONFIG);
        modBus.addListener(this::onCommonSetup);
        modBus.addListener(this::onClientSetup);
        modBus.addListener(this::onConfigReload);
        MinecraftForge.EVENT_BUS.register((Object)this);
        LOGGER.info("Epic Engine: Core initialized");
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Epic Engine: Common setup complete \u2014 config should be loaded now");
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        LOGGER.info("Epic Engine: Client setup starting...");
        event.enqueueWork(() -> {
            try {
                EpicEngineCustomConfig.initializeResources();
                LOGGER.info("Epic Engine: Client resources initialized successfully");
            }
            catch (Exception e) {
                LOGGER.error("Epic Engine: Failed to initialize client resources", (Throwable)e);
            }
        });
    }

    private void onConfigReload(ModConfigEvent event) {
        if (!event.getConfig().getModId().equals(MODID)) {
            return;
        }
        LOGGER.info("Epic Engine: Config reloading - {}", (Object)event.getConfig().getFileName());
        if (event.getConfig().getType() == ModConfig.Type.CLIENT) {
            LOGGER.info("Epic Engine: Client config reloaded");
            if (event.getConfig().getSpec() == EpicEngineCustomConfig.CONFIG) {
                try {
                    EpicEngineCustomConfig.initializeResources();
                    LOGGER.info("Epic Engine: Client resources reinitialized after config reload");
                }
                catch (Exception e) {
                    LOGGER.error("Epic Engine: Failed to reinitialize client resources after config reload", (Throwable)e);
                }
            }
        } else if (event.getConfig().getType() == ModConfig.Type.COMMON) {
            LOGGER.info("Epic Engine: World config reloaded");
            if (event.getConfig().getSpec() == EpicEngineWorldConfig.CONFIG) {
                LOGGER.info("Epic Engine: World generation settings updated");
            }
        }
    }

    public static <T> void addNetworkMessage(Class<T> type, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> handler) {
        PACKET_HANDLER.registerMessage(messageID++, type, encoder, decoder, handler);
    }

    public static void queueServerWork(int delayTicks, Runnable task) {
        if (Thread.currentThread().getThreadGroup().getName().equals("SERVER")) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(task, delayTicks));
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        ArrayList ready = new ArrayList();
        workQueue.forEach(entry -> {
            entry.setValue((Integer)entry.getValue() - 1);
            if ((Integer)entry.getValue() <= 0) {
                ready.add(entry);
            }
        });
        ready.forEach(entry -> ((Runnable)entry.getKey()).run());
        workQueue.removeAll(ready);
    }

    @Mod.EventBusSubscriber(modid="epic_engine", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("Epic Engine: Additional client setup via EventBusSubscriber");
        }
    }
}

