/*
 * Decompiled with CFR 0.152.
 */
package com.epic_engine.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EpicEngineCustomConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ForgeConfigSpec CONFIG;
    private static final File EPIC_ENGINE_DIR;
    private static final File TEXTURES_DIR;
    private static final File VIDEOS_DIR;
    private static final File SOUNDS_DIR;
    public static final ForgeConfigSpec.BooleanValue ENABLE_CUSTOMIZATION;
    public static final ForgeConfigSpec.BooleanValue ENABLE_CUSTOM_WINDOW_TITLE;
    public static final ForgeConfigSpec.ConfigValue<String> CUSTOM_WINDOW_TITLE;
    public static final ForgeConfigSpec.BooleanValue ENABLE_CUSTOM_LOADING_SCREEN;
    public static final ForgeConfigSpec.ConfigValue<String> LOADING_SCREEN_BACKGROUND;
    public static final ForgeConfigSpec.ConfigValue<String> LOADING_BAR_COLOR;
    public static final ForgeConfigSpec.ConfigValue<String> LOADING_TEXT_COLOR;
    public static final ForgeConfigSpec.BooleanValue SHOW_LOADING_PERCENTAGE;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> LOADING_TIPS;
    public static final ForgeConfigSpec.BooleanValue ENABLE_CUSTOM_MAIN_MENU;
    public static final ForgeConfigSpec.ConfigValue<String> MAIN_MENU_BACKGROUND;
    public static final ForgeConfigSpec.ConfigValue<String> MAIN_MENU_MUSIC;
    public static final ForgeConfigSpec.ConfigValue<String> MAIN_MENU_TITLE_IMAGE;
    public static final ForgeConfigSpec.BooleanValue CUSTOM_BUTTON_TEXT;
    public static final ForgeConfigSpec.ConfigValue<String> SINGLEPLAYER_BUTTON_TEXT;
    public static final ForgeConfigSpec.ConfigValue<String> MULTIPLAYER_BUTTON_TEXT;
    public static final ForgeConfigSpec.ConfigValue<String> MODS_BUTTON_TEXT;
    public static final ForgeConfigSpec.ConfigValue<String> QUIT_BUTTON_TEXT;
    public static final ForgeConfigSpec.BooleanValue ENABLE_INTRO_VIDEOS;
    public static final ForgeConfigSpec.ConfigValue<String> DEFAULT_INTRO_VIDEO;
    public static final ForgeConfigSpec.BooleanValue ALLOW_VIDEO_SKIP;
    public static final ForgeConfigSpec.IntValue VIDEO_SKIP_HOLD_TIME;
    public static final ForgeConfigSpec.BooleanValue PLAY_VIDEO_ONLY_FIRST_JOIN;
    public static final ForgeConfigSpec.BooleanValue DIMENSION_SPECIFIC_VIDEOS;
    public static final ForgeConfigSpec.ConfigValue<String> OVERWORLD_VIDEO;
    public static final ForgeConfigSpec.ConfigValue<String> NETHER_VIDEO;
    public static final ForgeConfigSpec.ConfigValue<String> END_VIDEO;

    private static void createDirectories() {
        try {
            EPIC_ENGINE_DIR.mkdirs();
            TEXTURES_DIR.mkdirs();
            VIDEOS_DIR.mkdirs();
            SOUNDS_DIR.mkdirs();
            LOGGER.info("Epic Engine: Resource directories created or verified");
        }
        catch (Exception e) {
            LOGGER.error("Epic Engine: Failed to create Epic Engine resource directories", (Throwable)e);
        }
    }

    public static void initializeResources() {
        try {
            LOGGER.info("Epic Engine: Starting resource initialization...");
            EpicEngineCustomConfig.createDirectories();
            LOGGER.info("Epic Engine: Config directory: {}", (Object)FMLPaths.CONFIGDIR.get());
            LOGGER.info("Epic Engine: Epic Engine directory: {}", (Object)EPIC_ENGINE_DIR.getAbsolutePath());
            LOGGER.info("Epic Engine: Textures directory exists: {}", (Object)TEXTURES_DIR.exists());
            LOGGER.info("Epic Engine: Customization enabled: {}", ENABLE_CUSTOMIZATION.get());
            LOGGER.info("Epic Engine: Custom menu enabled: {}", ENABLE_CUSTOM_MAIN_MENU.get());
            EpicEngineCustomConfig.extractDefaultResourceIfNeeded("textures/custom/background.png", EpicEngineCustomConfig.getTextureFile("background.png"));
            EpicEngineCustomConfig.extractDefaultResourceIfNeeded("textures/custom/title.png", EpicEngineCustomConfig.getTextureFile("title.png"));
            EpicEngineCustomConfig.extractDefaultResourceIfNeeded("textures/custom/loading.png", EpicEngineCustomConfig.getTextureFile("loading.png"));
            LOGGER.info("Epic Engine: Default resources initialization completed");
        }
        catch (Exception e) {
            LOGGER.error("Epic Engine: Failed to initialize Epic Engine default resources", (Throwable)e);
        }
    }

    private static void extractDefaultResourceIfNeeded(String resourcePath, File targetFile) {
        if (targetFile.exists()) {
            LOGGER.info("Epic Engine: File already exists, skipping: {}", (Object)targetFile.getName());
            return;
        }
        try {
            String fullPath = "assets/epic_engine/" + resourcePath;
            LOGGER.info("Epic Engine: Attempting to extract resource: {}", (Object)fullPath);
            InputStream inputStream = EpicEngineCustomConfig.class.getClassLoader().getResourceAsStream(fullPath);
            if (inputStream != null) {
                targetFile.getParentFile().mkdirs();
                FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)targetFile);
                LOGGER.info("Epic Engine: Successfully extracted resource to: {}", (Object)targetFile.getPath());
                inputStream.close();
            } else {
                LOGGER.warn("Epic Engine: Default resource not found in jar: {}", (Object)fullPath);
                try {
                    targetFile.getParentFile().mkdirs();
                    targetFile.createNewFile();
                    LOGGER.info("Epic Engine: Created placeholder file: {}", (Object)targetFile.getPath());
                }
                catch (IOException ex) {
                    LOGGER.error("Epic Engine: Failed to create placeholder file", (Throwable)ex);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Epic Engine: Failed to extract default resource: {}", (Object)resourcePath, (Object)e);
        }
    }

    public static File getTextureFile(String filename) {
        return new File(TEXTURES_DIR, filename);
    }

    public static File getVideoFile(String filename) {
        return new File(VIDEOS_DIR, filename);
    }

    public static File getSoundFile(String filename) {
        return new File(SOUNDS_DIR, filename);
    }

    public static String getVideoForDimension(String dimensionId) {
        if (!((Boolean)DIMENSION_SPECIFIC_VIDEOS.get()).booleanValue()) {
            return (String)DEFAULT_INTRO_VIDEO.get();
        }
        switch (dimensionId) {
            case "minecraft:overworld": {
                return (String)OVERWORLD_VIDEO.get();
            }
            case "minecraft:the_nether": {
                return (String)NETHER_VIDEO.get();
            }
            case "minecraft:the_end": {
                return (String)END_VIDEO.get();
            }
        }
        return (String)DEFAULT_INTRO_VIDEO.get();
    }

    public static File getVideoFileForDimension(String dimensionId) {
        return EpicEngineCustomConfig.getVideoFile(EpicEngineCustomConfig.getVideoForDimension(dimensionId));
    }

    public static boolean shouldPlayVideos() {
        return (Boolean)ENABLE_CUSTOMIZATION.get() != false && (Boolean)ENABLE_INTRO_VIDEOS.get() != false;
    }

    public static String getWindowTitle() {
        if (!((Boolean)ENABLE_CUSTOMIZATION.get()).booleanValue() || !((Boolean)ENABLE_CUSTOM_WINDOW_TITLE.get()).booleanValue()) {
            return null;
        }
        return (String)CUSTOM_WINDOW_TITLE.get();
    }

    public static boolean fileExists(File file) {
        return file != null && file.exists() && file.isFile() && file.canRead();
    }

    static {
        EPIC_ENGINE_DIR = new File(FMLPaths.CONFIGDIR.get().toFile(), "epic_engine");
        TEXTURES_DIR = new File(EPIC_ENGINE_DIR, "textures");
        VIDEOS_DIR = new File(EPIC_ENGINE_DIR, "videos");
        SOUNDS_DIR = new File(EPIC_ENGINE_DIR, "sounds");
        EpicEngineCustomConfig.createDirectories();
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("general");
        ENABLE_CUSTOMIZATION = builder.comment("Master switch. When false, all customization features will be disabled.").define("enableCustomization", true);
        builder.pop();
        builder.push("window");
        ENABLE_CUSTOM_WINDOW_TITLE = builder.comment("Enable custom game window title.").define("enableCustomWindowTitle", true);
        CUSTOM_WINDOW_TITLE = builder.comment("Custom game window title text.").define("customWindowTitle", (Object)"Epic Engine:A good tool to make your modpack!");
        builder.pop();
        builder.push("loading_screen");
        ENABLE_CUSTOM_LOADING_SCREEN = builder.comment("Enable custom loading screen.").define("enableCustomLoadingScreen", false);
        LOADING_SCREEN_BACKGROUND = builder.comment("Custom loading screen background image filename in config/epic_engine/textures/. Recommended size: 1920x1080.").define("loadingScreenBackground", (Object)"loading.png");
        LOADING_BAR_COLOR = builder.comment("Custom loading bar color (hexadecimal RGB or RGBA format).").define("loadingBarColor", (Object)"#55AAFF");
        LOADING_TEXT_COLOR = builder.comment("Custom loading text color (hexadecimal RGB or RGBA format).").define("loadingTextColor", (Object)"#FFFFFF");
        SHOW_LOADING_PERCENTAGE = builder.comment("Show loading percentage.").define("showLoadingPercentage", true);
        LOADING_TIPS = builder.comment("Custom loading tips list, randomly displayed during loading.").defineList("loadingTips", Arrays.asList("Tip: Epic Engine brings you more realistic mountains and terrain!", "Tip: You can see farther from mountaintops!", "Tip: Remember to prepare for your adventure!", "Tip: Explore newly generated valleys and canyons!", "Tip: Don't forget to backup your world saves!"), s -> s instanceof String);
        builder.pop();
        builder.push("main_menu");
        ENABLE_CUSTOM_MAIN_MENU = builder.comment("Enable custom main menu.").define("enableCustomMainMenu", true);
        MAIN_MENU_BACKGROUND = builder.comment("Custom main menu background image filename in config/epic_engine/textures/. Recommended size: 1920x1080 or match your game resolution.").define("mainMenuBackground", (Object)"background.png");
        MAIN_MENU_MUSIC = builder.comment("Custom main menu music filename in config/epic_engine/sounds/.").define("mainMenuMusic", (Object)"menu.ogg");
        MAIN_MENU_TITLE_IMAGE = builder.comment("Custom main menu title image filename in config/epic_engine/textures/. Recommended size: 1024x256 with transparent background.").define("mainMenuTitleImage", (Object)"title.png");
        builder.push("buttons");
        CUSTOM_BUTTON_TEXT = builder.comment("Enable custom button text.").define("customButtonText", false);
        SINGLEPLAYER_BUTTON_TEXT = builder.comment("Singleplayer button text.").define("singleplayerButtonText", (Object)"Start Adventure");
        MULTIPLAYER_BUTTON_TEXT = builder.comment("Multiplayer button text.").define("multiplayerButtonText", (Object)"Multiplayer World");
        MODS_BUTTON_TEXT = builder.comment("Mods button text.").define("modsButtonText", (Object)"Mod Options");
        QUIT_BUTTON_TEXT = builder.comment("Quit button text.").define("quitButtonText", (Object)"End Adventure");
        builder.pop();
        builder.pop();
        builder.push("intro_videos");
        ENABLE_INTRO_VIDEOS = builder.comment("Enable intro videos when entering worlds.").define("enableIntroVideos", false);
        DEFAULT_INTRO_VIDEO = builder.comment("Default intro video filename in config/epic_engine/videos/. Recommended format: MP4 with H.264 encoding.").define("defaultIntroVideo", (Object)"default.mp4");
        ALLOW_VIDEO_SKIP = builder.comment("Allow players to skip videos.").define("allowVideoSkip", true);
        VIDEO_SKIP_HOLD_TIME = builder.comment("Time in milliseconds to hold ESC to skip video.").defineInRange("videoSkipHoldTime", 750, 100, 5000);
        PLAY_VIDEO_ONLY_FIRST_JOIN = builder.comment("Only play videos on first world join.").define("playVideoOnlyFirstJoin", true);
        builder.push("dimension_videos");
        DIMENSION_SPECIFIC_VIDEOS = builder.comment("Use different videos for each dimension.").define("dimensionSpecificVideos", false);
        OVERWORLD_VIDEO = builder.comment("Overworld video filename in config/epic_engine/videos/.").define("overworldVideo", (Object)"overworld.mp4");
        NETHER_VIDEO = builder.comment("Nether video filename in config/epic_engine/videos/.").define("netherVideo", (Object)"nether.mp4");
        END_VIDEO = builder.comment("End video filename in config/epic_engine/videos/.").define("endVideo", (Object)"end.mp4");
        builder.pop();
        builder.pop();
        CONFIG = builder.build();
    }
}

