/*
 * Decompiled with CFR 0.152.
 */
package com.epic_engine.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class EpicEngineWorldConfig {
    public static final ForgeConfigSpec CONFIG;
    public static final ForgeConfigSpec.BooleanValue ENABLE_WORLD_MODIFICATIONS;
    public static final ForgeConfigSpec.IntValue MIN_BUILD_HEIGHT;
    public static final ForgeConfigSpec.IntValue MAX_MOUNTAIN_HEIGHT;
    public static final ForgeConfigSpec.IntValue MOUNTAIN_LOW_THRESHOLD;
    public static final ForgeConfigSpec.IntValue MOUNTAIN_MID_THRESHOLD;
    public static final ForgeConfigSpec.DoubleValue MOUNTAIN_LOW_FACTOR;
    public static final ForgeConfigSpec.DoubleValue MOUNTAIN_MID_FACTOR;
    public static final ForgeConfigSpec.DoubleValue MOUNTAIN_HIGH_FACTOR;
    public static final ForgeConfigSpec.DoubleValue JAGGED_PEAKS_EXTRA_FACTOR;
    public static final ForgeConfigSpec.DoubleValue MOUNTAIN_RANGE_SCALE;
    public static final ForgeConfigSpec.DoubleValue MOUNTAIN_CONTINUITY;
    public static final ForgeConfigSpec.DoubleValue RIDGE_STRENGTH;
    public static final ForgeConfigSpec.DoubleValue PERLIN_NOISE_FREQUENCY;
    public static final ForgeConfigSpec.IntValue PERLIN_NOISE_OCTAVES;
    public static final ForgeConfigSpec.DoubleValue PERLIN_NOISE_PERSISTENCE;
    public static final ForgeConfigSpec.DoubleValue PERLIN_NOISE_INFLUENCE;
    public static final ForgeConfigSpec.IntValue BASE_TERRAIN_HEIGHT_LIMIT;
    public static final ForgeConfigSpec.DoubleValue BASE_TERRAIN_FACTOR;
    public static final ForgeConfigSpec.IntValue PLAINS_MAX_HEIGHT_VARIATION;
    public static final ForgeConfigSpec.BooleanValue PLAINS_FILL_SURFACE_CAVES;

    public static int calculateMaxBuildHeight() {
        int minY = (Integer)MIN_BUILD_HEIGHT.get();
        int maxH = (Integer)MAX_MOUNTAIN_HEIGHT.get();
        return maxH - minY + 64 + minY;
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("general");
        ENABLE_WORLD_MODIFICATIONS = builder.comment("Master switch. When false, no world modifications will occur.").define("enableWorldModifications", true);
        MIN_BUILD_HEIGHT = builder.comment("Min build height (including bedrock).").defineInRange("minBuildHeight", -64, -1024, 0);
        MAX_MOUNTAIN_HEIGHT = builder.comment("Max mountain height.").defineInRange("maxMountainHeight", 512, 256, 4096);
        builder.pop();
        builder.push("terrain_modifications");
        builder.push("mountains");
        BASE_TERRAIN_HEIGHT_LIMIT = builder.comment("Height limit for base terrain enhancement. Only terrain below this height gets the enhancement.").defineInRange("baseTerrainHeightLimit", 80, 0, 256);
        BASE_TERRAIN_FACTOR = builder.comment("Enhancement factor for base terrain below the height limit.").defineInRange("baseTerrainFactor", 1.1, 1.0, 1.5);
        MOUNTAIN_LOW_THRESHOLD = builder.comment("Low mountain threshold - below this is considered low mountain area.").defineInRange("lowMountainThreshold", 96, 0, 256);
        MOUNTAIN_MID_THRESHOLD = builder.comment("Mid mountain threshold - below this and above low threshold is mid mountain area.").defineInRange("midMountainThreshold", 128, 96, 512);
        MOUNTAIN_LOW_FACTOR = builder.comment("Enhancement factor for low mountain areas.").defineInRange("lowMountainFactor", 1.3, 1.0, 2.0);
        MOUNTAIN_MID_FACTOR = builder.comment("Enhancement factor for mid mountain areas.").defineInRange("midMountainFactor", 1.8, 1.0, 3.0);
        MOUNTAIN_HIGH_FACTOR = builder.comment("Enhancement factor for high mountain areas.").defineInRange("highMountainFactor", 2.5, 1.0, 4.0);
        JAGGED_PEAKS_EXTRA_FACTOR = builder.comment("Extra enhancement factor for jagged peaks biome.").defineInRange("jaggedPeaksExtraFactor", 1.4, 1.0, 2.0);
        builder.push("mountain_range");
        MOUNTAIN_RANGE_SCALE = builder.comment("Controls the horizontal scale of mountain ranges (smaller values = bigger mountains).").defineInRange("rangeScale", 4.0E-4, 1.0E-4, 0.01);
        MOUNTAIN_CONTINUITY = builder.comment("Controls how continuous mountain ranges are (higher = more continuous).").defineInRange("continuity", 0.8, 0.0, 1.0);
        RIDGE_STRENGTH = builder.comment("Controls how prominent mountain ridges are (higher = more prominent).").defineInRange("ridgeStrength", 0.5, 0.1, 1.0);
        builder.push("noise");
        PERLIN_NOISE_FREQUENCY = builder.comment("Base frequency for Perlin noise.").defineInRange("frequency", 0.006, 0.001, 0.1);
        PERLIN_NOISE_OCTAVES = builder.comment("Octaves for Perlin noise.").defineInRange("octaves", 4, 1, 8);
        PERLIN_NOISE_PERSISTENCE = builder.comment("Persistence for Perlin noise.").defineInRange("persistence", 0.5, 0.1, 0.9);
        PERLIN_NOISE_INFLUENCE = builder.comment("How much the noise affects the terrain (0-1).").defineInRange("influence", 0.25, 0.0, 0.5);
        builder.pop();
        builder.pop();
        builder.pop();
        builder.push("plains");
        PLAINS_MAX_HEIGHT_VARIATION = builder.comment("Maximum height variation for plains biomes (total blocks from lowest to highest).").defineInRange("maxHeightVariation", 4, 1, 16);
        PLAINS_FILL_SURFACE_CAVES = builder.comment("Enable flawless plains by filling surface caves and holes.").define("fillSurfaceCaves", true);
        builder.pop();
        builder.pop();
        CONFIG = builder.build();
    }
}

